/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.FloatingTadpole;
import florent.PUtils;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Context {
    private double time = -1.0;
    private double firePower = 2.0;
    private double energy = 100.0;
    private double myEnergy;
    private double absoluteBearing;
    private double velocity;
    private double lastVelocity;
    private double approachVelocity;
    private double lateralVelocity;
    private double lastLateralVelocity;
    private double heading;
    private double lastHeading;
    private double myBearing;
    private double myHeading;
    private double distance;
    private double myVelocity;
    private double myLastVelocity;
    private double myLateralVelocity;
    private double myBearingDirection = 1.0;
    private int bearingDirection = 1;
    private AdvancedRobot me;
    private Point2D.Double enemyLocation = new Point2D.Double();
    private Point2D.Double myLocation;
    private String name = null;
    private static double avgApproachVelocity;
    private static double scans;

    public Context(AdvancedRobot me) {
        this.me = me;
    }

    public AdvancedRobot getRobot() {
        return this.me;
    }

    public Object clone() {
        return (Context)this.clone();
    }

    public void synch() {
        if (this.time == (double)this.me.getTime()) {
            return;
        }
        this.time = this.me.getTime();
        this.myLastVelocity = this.myVelocity;
        this.myVelocity = this.me.getVelocity();
        this.myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        this.myHeading = this.me.getHeading();
        this.myEnergy = this.me.getEnergy();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.synch();
        this.name = e.getName();
        this.distance = e.getDistance();
        this.energy = e.getEnergy();
        this.enemyLocation = new Point2D.Double();
        FloatingTadpole.toLocation(this.absoluteBearing, this.distance, this.myLocation, this.enemyLocation);
        this.myHeading = this.me.getHeadingRadians();
        this.myLastVelocity = this.myVelocity;
        this.myVelocity = this.me.getVelocity();
        this.myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        this.myEnergy = this.me.getEnergy();
        this.absoluteBearing = this.myHeading + e.getBearingRadians();
        this.lastVelocity = this.velocity;
        this.lastHeading = this.heading;
        this.velocity = e.getVelocity();
        this.heading = e.getHeadingRadians();
        this.myBearing = FloatingTadpole.absoluteBearing(this.enemyLocation, this.myLocation);
        this.lastLateralVelocity = this.lateralVelocity;
        this.lateralVelocity = this.velocity * Math.sin(this.heading - this.absoluteBearing);
        this.approachVelocity = this.velocity * Math.cos(this.heading - this.absoluteBearing);
        if (this.lateralVelocity != 0.0) {
            this.bearingDirection = this.lateralVelocity < 0.0 ? -1 : 1;
        }
        this.myLateralVelocity = this.myVelocity * Math.sin(this.myHeading - this.myBearing);
        if (this.myLateralVelocity != 0.0) {
            this.myBearingDirection = this.myLateralVelocity < 0.0 ? -1 : 1;
        }
        avgApproachVelocity = PUtils.rollingAvg(avgApproachVelocity, Math.abs(this.approachVelocity), Math.min(scans, 500.0));
        scans += 1.0;
    }

    public boolean isRammer() {
        return avgApproachVelocity > 4.5;
    }

    public double getAbsoluteBearing() {
        return this.absoluteBearing;
    }

    public int getBearingDirection() {
        return this.bearingDirection;
    }

    public double getDistance() {
        return this.distance;
    }

    public Point2D.Double getEnemyLocation() {
        return this.enemyLocation;
    }

    public double getHeading() {
        return this.heading;
    }

    public double getLastHeading() {
        return this.lastHeading;
    }

    public double getLastVelocity() {
        return this.lastVelocity;
    }

    public double getLateralVelocity() {
        return this.lateralVelocity;
    }

    public double getMyBearing() {
        return this.myBearing;
    }

    public double getMyHeading() {
        return this.myHeading;
    }

    public Point2D.Double getMyLocation() {
        return this.myLocation;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getMyBearingDirection() {
        return this.myBearingDirection;
    }

    public double getMyLastVelocity() {
        return this.myLastVelocity;
    }

    public double getMyLateralVelocity() {
        return this.myLateralVelocity;
    }

    public double getMyVelocity() {
        return this.myVelocity;
    }

    public double getTime() {
        return this.time;
    }

    public double getEnergy() {
        return this.energy;
    }

    public double getFirePower() {
        return this.firePower;
    }

    public void setFirePower(double firePower) {
        this.firePower = firePower;
    }

    public double getMyEnergy() {
        return this.myEnergy;
    }

    public double getApproachVelocity() {
        return this.approachVelocity;
    }

    public String getName() {
        return this.name;
    }
}

