/*
 * Decompiled with CFR 0.152.
 */
package spin;

import java.util.Vector;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import spin.MathVector;
import spin.PhysicPoint;
import spin.PredictedBullet;
import spin.RoboMath;

public class Enemy
extends PhysicPoint {
    private double heading;
    private double energy;
    private double angularRate;
    private double angularChange;
    private double velocityChange;
    private long updatedAt;
    private double width;
    private double height;
    private Vector<PredictedBullet> bullets;

    public Enemy(ScannedRobotEvent e, MathVector myPos, double myHeading, long updatedAt, double w, double h) {
        this.width = w;
        this.height = h;
        this.heading = e.getHeadingRadians();
        this.bullets = new Vector();
        this.update(e, myPos, myHeading, updatedAt, new MathVector());
    }

    public Enemy(Robot myRobot, long updatedAt, double w, double h) {
        this.width = w;
        this.height = h;
        this.heading = myRobot.getHeading() * Math.PI / 180.0;
        this.bullets = new Vector();
        this.angularRate = 0.0;
        this.setX(myRobot.getX());
        this.setY(myRobot.getY());
        this.setVelocity(new MathVector(Math.sin(this.heading) * myRobot.getVelocity(), Math.cos(this.heading) * myRobot.getVelocity()));
        double energyDrop = 0.0;
        this.setEnergy(myRobot.getEnergy());
        this.setUpdatedAt(updatedAt);
    }

    public void update(ScannedRobotEvent e, MathVector myPos, double myHeading, long updatedAt, MathVector myVelocity) {
        MathVector newVelocity = new MathVector(Math.sin(this.heading) * e.getVelocity(), Math.cos(this.heading) * e.getVelocity());
        double newAngularRate = (this.heading - e.getHeadingRadians()) / (double)(updatedAt - this.updatedAt);
        this.angularChange += Math.abs(newAngularRate);
        this.velocityChange += Math.abs(newVelocity.lenght() - this.getVelocity().lenght());
        this.angularRate = newAngularRate;
        this.setAcceleration(newVelocity.sub(this.getVelocity()).div(updatedAt - this.updatedAt));
        this.heading = e.getHeadingRadians();
        double energyDrop = this.energy - e.getEnergy();
        if (energyDrop < 3.0 && energyDrop > 0.1) {
            this.bullets.add(new PredictedBullet(energyDrop, new MathVector(this.getX(), this.getY()), myPos, this.updatedAt));
            double ticksToReach = myPos.sub(this).lenght() / RoboMath.getBulletSpeed(energyDrop);
            this.bullets.add(new PredictedBullet(energyDrop, new MathVector(this.getX(), this.getY()), myPos.add(myVelocity.mul(ticksToReach)), this.updatedAt));
            this.bullets.add(new PredictedBullet(energyDrop, new MathVector(this.getX(), this.getY()), myPos.add(myVelocity.mul(ticksToReach / 2.0)), this.updatedAt));
            this.bullets.add(new PredictedBullet(energyDrop, new MathVector(this.getX(), this.getY()), myPos.add(myVelocity.norm().mul(8.0).mul(ticksToReach)), this.updatedAt));
            this.bullets.add(new PredictedBullet(energyDrop, new MathVector(this.getX(), this.getY()), myPos.add(myVelocity.norm().mul(-8.0).mul(ticksToReach)), this.updatedAt));
        }
        double angle = (myHeading + e.getBearingRadians()) % (Math.PI * 2);
        this.setX((int)(myPos.getX() + Math.sin(angle) * e.getDistance()));
        this.setY((int)(myPos.getY() + Math.cos(angle) * e.getDistance()));
        this.setVelocity(newVelocity);
        this.setEnergy(e.getEnergy());
        this.setUpdatedAt(updatedAt);
    }

    public double getVeloChangeFactor() {
        return this.velocityChange / (double)this.updatedAt;
    }

    public double getAngularChangeFactor() {
        return this.angularChange / (double)this.updatedAt;
    }

    public void updateBullets(long time) {
        int i = 0;
        while (i < this.bullets.size()) {
            this.bullets.get(i).update(time);
            if (!RoboMath.isInSquare(this.bullets.get(i).getX(), this.bullets.get(i).getY(), this.width, this.height)) {
                this.bullets.remove(i);
            }
            ++i;
        }
    }

    public Vector<PredictedBullet> getBullets() {
        return this.bullets;
    }

    public void setBullets(Vector<PredictedBullet> bullets) {
        this.bullets = bullets;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    @Override
    public String toString() {
        return "enemy [e:" + this.energy + "h:" + this.heading + ", x:" + this.getX() + ", y:" + this.getY() + "]";
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.energy = energy;
    }

    public double getBearingRadians(double myX, double myY) {
        return this.sub(new MathVector(myX, myY)).getAngle();
    }

    public double getNextBearingRadians(double myX, double myY) {
        return this.getNextPosition().sub(new MathVector(myX, myY)).getAngle();
    }

    public double getNextBearingRadians(double myX, double myY, double myHeading) {
        return this.getNextPosition().sub(new MathVector(myX, myY)).getAngle() - myHeading;
    }

    public double getNextBearingRadiansIn(double myX, double myY, long time) {
        return this.getNextPositionIn(time).sub(new MathVector(myX, myY)).getAngle();
    }

    public double getNextBearingRadiansIn(double myX, double myY, double myHeading, long time) {
        return this.getNextPositionIn(time).sub(new MathVector(myX, myY)).getAngle() - myHeading;
    }

    public double getNextBearingRadiansWithAngularIn(double myX, double myY, long time) {
        return this.getNextPositionWithAngularIn(time).sub(new MathVector(myX, myY)).getAngle();
    }

    public double getNextBearingRadiansWithAngularIn(double myX, double myY, double myHeading, long time) {
        return this.getNextPositionWithAngularIn(time).sub(new MathVector(myX, myY)).getAngle() - myHeading;
    }

    public MathVector getNextPositionWithAngularIn(long time) {
        MathVector nextPos = this.add(this.getVelocity().mul(time).mul(1.0 - this.getVeloChangeFactor()).add(this.getAcceleration().mul(Math.pow(time, 2.0) / 2.0).limitLenghtTo(8.0 - this.getVelocity().lenght())).rotate(this.angularRate * (double)time / 2.0 * (1.0 - this.getAngularChangeFactor())));
        if (nextPos.getX() < 0.0) {
            nextPos.setX(0.0);
        } else if (nextPos.getX() > this.width) {
            nextPos.setX(this.width);
        }
        if (nextPos.getY() < 0.0) {
            nextPos.setY(0.0);
        } else if (nextPos.getY() > this.height) {
            nextPos.setY(this.height);
        }
        return nextPos;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public MathVector getOrientation() {
        return new MathVector(Math.sin(this.heading), Math.cos(this.heading));
    }

    private MathVector getLeftSquare(int w, int h) {
        MathVector normal = this.getOrientation().getLeftNormal();
        double mn = normal.getX() / normal.getY();
        double nm = normal.getY() / normal.getX();
        double ax = this.getX() + nm * this.getY();
        double bx = this.getX() - mn * (double)h + nm * this.getY();
        double ay = mn * this.getX() + this.getY();
        double by = this.getY() - mn * (double)w + mn * this.getX();
        MathVector dot1 = null;
        MathVector dot2 = null;
        if (RoboMath.isInSquare(0.0, ay, w, h)) {
            dot1 = new MathVector(0.0, ay);
        } else if (RoboMath.isInSquare(w, by, w, h)) {
            dot1 = new MathVector(w, by);
        }
        if (RoboMath.isInSquare(ax, 0.0, w, h)) {
            dot2 = new MathVector(ax, 0.0);
        } else if (RoboMath.isInSquare(bx, h, w, h)) {
            dot2 = new MathVector(bx, h);
        }
        return null;
    }

    public double getAngularRate() {
        return this.angularRate;
    }

    public void setAngularRate(double angularRate) {
        this.angularRate = angularRate;
    }

    public MathVector getHeadingVector() {
        return new MathVector(Math.sin(this.heading), Math.cos(this.heading));
    }
}

