/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun.waveGun;

import catcat20.core.bot.BotState;
import catcat20.core.utils.LConstants;
import catcat20.core.utils.LUtils;
import catcat20.core.utils.MovementPredictor;
import catcat20.core.utils.PreciseWallSmooth;
import java.awt.geom.Point2D;
import robocode.Rules;
import robocode.util.Utils;

public class GunWave
extends Point2D.Double {
    public double directAngle;
    public int direction = 1;
    public double bulletPower;
    public final double bulletVelocity;
    public BotState enState;
    public BotState oldEnState;
    public BotState myState;
    public BotState oldMyState;
    public long fireTime;
    public boolean isRealWave;
    public double dist8;
    public double dist16;
    public double dist30;
    public double dist60;
    public double dist120;
    public double dirChangeTime;
    public double[] meas;
    public double minGuessFactor = 0.0;
    public double maxGuessFactor = 0.0;
    public double preciseMinGuessFactor = 0.0;
    public double preciseMaxGuessFactor = 0.0;
    PreciseWallSmooth.Trig trig = new PreciseWallSmooth.Trig();

    public GunWave(double x, double y, double directAngle, int direction, double bulletPower, long fireTime, boolean isRealWave, BotState enState, BotState oldEnState, BotState myState, BotState oldMyState) {
        super(x, y);
        this.directAngle = directAngle;
        this.direction = direction;
        this.bulletPower = bulletPower;
        this.enState = enState;
        this.oldEnState = oldEnState;
        this.myState = myState;
        this.oldMyState = oldMyState;
        this.fireTime = fireTime;
        this.isRealWave = isRealWave;
        this.bulletVelocity = Rules.getBulletSpeed((double)bulletPower);
    }

    public double[] getMea(double power, BotState en, double myX, double myY, long time, int direction) {
        MovementPredictor.PredictionStatus status = new MovementPredictor.PredictionStatus(en.x, en.y, en.heading, en.velocity, time);
        double absBearing = LUtils.absoluteBearing(myX, myY, en.x, en.y);
        double distance = Point2D.Double.distance(myX, myY, en.x, en.y);
        double bft = distance / Rules.getBulletSpeed((double)power);
        int count = (int)bft;
        MovementPredictor.PredictionStatus dir1 = (MovementPredictor.PredictionStatus)status.clone();
        double distTravel1 = 0.0;
        for (int i = 0; i < count; ++i) {
            distTravel1 += Rules.getBulletSpeed((double)power);
            double dist1 = Point2D.Double.distance(myX, myY, dir1.x, dir1.y);
            if (!(dist1 - distTravel1 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir1.x, dir1.y, myX, myY) + 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir1.x, dir1.y, -1 * direction);
            dir1 = MovementPredictor.predict(dir1, angle, 8.0);
        }
        double distTravel2 = 0.0;
        MovementPredictor.PredictionStatus dir2 = (MovementPredictor.PredictionStatus)status.clone();
        for (int i = 0; i < count; ++i) {
            distTravel2 += Rules.getBulletSpeed((double)power);
            double dist2 = Point2D.Double.distance(myX, myY, dir2.x, dir2.y);
            if (!(dist2 - distTravel2 > 0.0)) break;
            double angle = LUtils.absoluteBearing(dir2.x, dir2.y, myX, myY) - 1.5707963267948966 * (double)direction;
            this.trig.sin = Math.sin(angle);
            this.trig.cos = Math.cos(angle);
            angle = LConstants.preciseWallSmooth.smoothHeading(angle, this.trig, dir2.x, dir2.y, direction);
            dir2 = MovementPredictor.predict(dir2, angle, 8.0);
        }
        double mea1 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir1.x, dir1.y) - absBearing));
        double mea2 = Utils.normalRelativeAngle((double)(LUtils.absoluteBearing(myX, myY, dir2.x, dir2.y) - absBearing));
        return new double[]{Math.abs(mea1), Math.abs(mea2)};
    }

    public double getDistanceTraveled(long time) {
        return this.bulletVelocity * (double)(time - this.fireTime);
    }

    public double firingAngle(double guessFactor) {
        return this.directAngle + guessFactor * (double)this.direction * this.maxEscapeAngle();
    }

    public double guessFactor(Point2D.Double targetLocation) {
        double bearingToTarget = LUtils.absoluteBearing(this, targetLocation);
        return this.guessFactor(bearingToTarget);
    }

    public double guessFactor(double bearingToTarget) {
        return this.guessAngle(bearingToTarget) / this.maxEscapeAngle();
    }

    public double guessAngle(Point2D.Double targetLocation) {
        double bearingToTarget = LUtils.absoluteBearing(this, targetLocation);
        return this.guessAngle(bearingToTarget);
    }

    public double guessAngle(double bearingToTarget) {
        return (double)this.direction * Utils.normalRelativeAngle((double)(bearingToTarget - this.directAngle));
    }

    public double maxEscapeAngle() {
        return Math.asin(8.0 / this.bulletVelocity);
    }
}

