/*
 * Decompiled with CFR 0.152.
 */
package co.edu.usb.rc;

import co.edu.usb.rc.AGravEngine;
import co.edu.usb.rc.AdvancedBaseRobot;
import co.edu.usb.rc.GravPoint;
import co.edu.usb.rc.Trigonometry;
import java.awt.Color;
import robocode.ScannedRobotEvent;

public class LidisTron
extends AdvancedBaseRobot {
    public static double CORNER_DISTANCE = 100.0;
    public static double ROBOT_INITIAL_ATTRACTION = 20.0;
    public static double ROBOT_ONE_TO_ONE_ATTRACTION = -180.0;
    public static double CORNER_ATTRACTION = -60.0;
    public static double WALL_FORCE = -70.0;
    public static double ROBOT_FORCE = 10.0;
    public static double CENTER_ATTRACTION = 50.0;
    public static double SEGMENT_DISTANCE = 10.0;
    AGravEngine age;
    GravPoint gp0;
    GravPoint gp1;
    GravPoint gp2;
    GravPoint gp3;
    GravPoint gp4;

    public void run() {
        this.prepare();
        while (true) {
            this.look();
            this.fire();
            this.move();
            this.execute();
        }
    }

    public void paint() {
        this.setBodyColor(new Color(0, 0, 0));
        this.setGunColor(new Color(0, 150, 50));
        this.setRadarColor(new Color(0, 100, 100));
        this.setBulletColor(new Color(255, 255, 100));
        this.setBodyColor(new Color(0, 0, 0));
    }

    public void prepare() {
        this.paint();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        double maxW = this.getBattleFieldWidth();
        double maxH = this.getBattleFieldHeight();
        this.age = new AGravEngine(maxW, maxH);
        this.age.setWallForce(WALL_FORCE);
        GravPoint gp0 = new GravPoint(0.0 + CORNER_DISTANCE, 0.0 + CORNER_DISTANCE, CORNER_ATTRACTION, this.getTime(), 0L);
        GravPoint gp1 = new GravPoint(0.0 + CORNER_DISTANCE, maxH - CORNER_DISTANCE, CORNER_ATTRACTION, this.getTime(), 0L);
        GravPoint gp2 = new GravPoint(maxW - CORNER_DISTANCE, 0.0 + CORNER_DISTANCE, CORNER_ATTRACTION, this.getTime(), 0L);
        GravPoint gp3 = new GravPoint(maxW - CORNER_DISTANCE, maxH - CORNER_DISTANCE, CORNER_ATTRACTION, this.getTime(), 0L);
        GravPoint gp4 = new GravPoint(maxW / 2.0, maxH / 2.0, CENTER_ATTRACTION, this.getTime(), 0L);
        this.age.addPoint(gp0);
        this.age.addPoint(gp1);
        this.age.addPoint(gp2);
        this.age.addPoint(gp3);
        this.age.addPoint(gp4);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        GravPoint gp;
        double distance = e.getDistance();
        double bearing = e.getBearing();
        double heading = this.getHeading();
        this.updateRobotInfoWithList(e);
        if (this.getOthers() > 4) {
            double x = Trigonometry.getX(this.getX(), heading, bearing, distance);
            double y = Trigonometry.getY(this.getY(), heading, bearing, distance);
            gp = new GravPoint(x, y, ROBOT_INITIAL_ATTRACTION, e.getTime(), 20L);
        } else {
            double y;
            double x;
            if (distance < 100.0) {
                x = Trigonometry.getX(this.getX(), heading, Trigonometry.inverseBearing(bearing), 140.0 - distance);
                y = Trigonometry.getY(this.getY(), heading, Trigonometry.inverseBearing(bearing), 140.0 - distance);
            } else {
                x = Trigonometry.getX(this.getX(), heading, bearing, distance - 140.0);
                y = Trigonometry.getY(this.getY(), heading, bearing, distance - 140.0);
            }
            gp = new GravPoint(x, y, ROBOT_ONE_TO_ONE_ATTRACTION, e.getTime(), 20L);
        }
        this.age.addPoint(gp);
    }

    public void move() {
        this.age.update(this.getX(), this.getY(), this.getTime());
        this.goTo(this.getX() - this.age.getXForce(), this.getY() - this.age.getYForce());
        System.out.println(this.age);
    }

    public void goTo(double x, double y) {
        double angle = Trigonometry.turnRightAngle(this.getX(), this.getY(), x, y, this.getHeading());
        this.setTurnRight(angle);
        this.setAhead(SEGMENT_DISTANCE);
    }

    public void look() {
        this.setTurnRadarRight(360.0);
    }

    public void fire() {
        this.doChoosePredictiveShoot();
    }
}

