/*
 * Decompiled with CFR 0.152.
 */
package agd.predict;

import agd.predict.Footprint;
import agd.predict.TargetPrediction;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.World;
import java.util.List;
import java.util.ListIterator;

class LinearPrediction
extends TargetPrediction {
    LinearPrediction() {
    }

    public Coord predictTarget(List recentFootprints, long time) {
        Coord predictedPosition = null;
        if (recentFootprints.size() >= 1) {
            ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
            Footprint lastFp = (Footprint)lit.previous();
            if (lastFp == null) {
                System.out.println("LinearPrediction: ------  lastFp is null ----- ");
            } else if (lastFp.getHeading() == null) {
                System.out.println("LinearPrediction: ----- lastFp.getHeading() is null ------");
            }
            Compass lastHeading = lastFp.getHeading();
            long timediff = time - lastFp.getTime();
            double distance = (double)timediff * lastFp.getVelocity();
            predictedPosition = lastFp.getPosition().applyVector(lastFp.getHeading(), distance);
            predictedPosition = predictedPosition.clipToRectangle(Coord.ORIGIN, World.getBattleFieldSize());
        }
        return predictedPosition;
    }

    public String toString() {
        return "Linear";
    }
}

