/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import robocode.AdvancedRobot;

public final class Navigation {
    private Double ahead;
    private Double turn;
    private Double maxturnrate;
    private Double maxvelocity;

    public Navigation() {
        this.ahead = null;
        this.turn = null;
        this.maxturnrate = null;
        this.maxvelocity = null;
    }

    public Navigation(Double ahead, Double turn) {
        this.ahead = ahead;
        this.turn = turn;
        this.maxturnrate = null;
        this.maxvelocity = null;
    }

    public void execute(AdvancedRobot ar) {
        if (this.maxturnrate != null) {
            ar.setMaxTurnRate(this.maxturnrate.doubleValue());
        }
        if (this.maxvelocity != null) {
            ar.setMaxVelocity(this.maxvelocity.doubleValue());
        }
        if (this.ahead != null) {
            ar.setAhead(this.ahead.doubleValue());
        }
        if (this.turn != null) {
            ar.setTurnRight(this.turn.doubleValue());
        }
    }

    public boolean isDoingNothing() {
        boolean doNothing = true;
        if (this.ahead != null && this.ahead != 0.0 || this.turn != null && this.turn != 0.0) {
            doNothing = false;
        }
        return doNothing;
    }

    public void setMaxTurnRate(double maxturnrate) {
        this.maxturnrate = new Double(maxturnrate);
    }

    public void setMaxVelocity(double maxvelocity) {
        this.maxvelocity = new Double(maxvelocity);
    }

    public Double getAhead() {
        return this.ahead;
    }

    public Double getTurn() {
        return this.turn;
    }

    public String toString() {
        StringBuffer string = new StringBuffer(80);
        if (this.maxturnrate != null) {
            string.append("setMaxTurnRate " + this.maxturnrate.intValue() + ";");
        }
        if (this.maxvelocity != null) {
            string.append("setMaxVelocity " + this.maxvelocity.intValue() + ";");
        }
        if (this.ahead != null) {
            string.append("setAhead " + this.ahead.intValue() + ";");
        }
        if (this.turn != null) {
            string.append("setTurnRight " + this.turn.intValue() + ";");
        }
        if (string.toString().equals("")) {
            string.append("doNothing;");
        }
        return string.toString();
    }
}

