/*
 * Decompiled with CFR 0.152.
 */
package agd.util;

import agd.predict.Footprint;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.PredictedBulletFootprint;
import agd.util.World;

public class PredictedBullet {
    private double power;
    private Coord firedFrom;
    private Compass heading;
    private double velocity;
    private long timeFired;
    private Enemy shooter;
    private double probability;

    public PredictedBullet(Enemy shooter, long time, double power, Compass heading) {
        this.firedFrom = shooter.getLastSighting().getTheirPosition();
        this.shooter = shooter;
        this.power = power;
        this.timeFired = time;
        this.heading = heading;
        this.velocity = 20.0 - 3.0 * power;
        this.probability = 1.0;
    }

    public PredictedBullet(Enemy shooter, long time, double power, Compass heading, double probability) {
        this(shooter, time, power, heading);
        this.probability = probability;
    }

    public long getTimeFired() {
        return this.timeFired;
    }

    public Compass getHeading() {
        return this.heading;
    }

    public String getName() {
        return this.shooter.getName();
    }

    public Enemy getShooter() {
        return this.shooter;
    }

    public double getPower() {
        return this.power;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getAcceleration() {
        return 0.0;
    }

    public double getProbability() {
        return this.probability;
    }

    public Coord getPosition() {
        return this.getPosition(World.getTime());
    }

    public Coord getPosition(long predictionTime) {
        double distance = this.velocity * (double)(predictionTime - this.timeFired);
        return this.firedFrom.applyVector(this.heading, distance);
    }

    public String toString() {
        return this.shooter.toString() + " shot power" + this.power + " heading " + this.heading + " from " + this.firedFrom;
    }

    public boolean hasFootprint(long atTime) {
        Coord position;
        boolean onField = true;
        onField = atTime < this.timeFired ? false : (position = this.getPosition(atTime)).inRectangle(Coord.ORIGIN, World.getBattleFieldSize());
        return onField;
    }

    public Footprint getFootprint(long atTime) {
        PredictedBulletFootprint f = null;
        if (this.hasFootprint(atTime)) {
            f = new PredictedBulletFootprint(atTime, this.getPosition(atTime), this.heading, this.velocity);
        }
        return f;
    }

    public long getEarliestFootprintTime() {
        return this.timeFired;
    }

    public long getLatestFootprintTime() {
        return World.getTime() + 90L;
    }

    public Footprint getEarliestFootprint() {
        return this.getFootprint(this.getEarliestFootprintTime());
    }

    public Footprint getLatestFootprint() {
        return this.getFootprint(this.getLatestFootprintTime());
    }

    public long getFootprintCount() {
        return this.getLatestFootprintTime() - this.getEarliestFootprintTime() + 1L;
    }
}

