/*
 * Decompiled with CFR 0.152.
 */
package demetrix.info;

import demetrix.info.WaveRecord;
import demetrix.misc.Physics;
import java.awt.geom.Point2D;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Wave {
    private Vector data;

    public void addWave(Point2D shtPos, long shtTime, double blPwr) {
        this.data.addElement(new WaveRecord(shtPos, shtTime, blPwr));
    }

    public WaveRecord getWave(int waveIndex) {
        if (waveIndex >= this.data.size()) {
            return null;
        }
        return (WaveRecord)this.data.elementAt(waveIndex);
    }

    public double removeWaveForDistance(Point2D targetPoint, long checkTime) {
        double passedBulletPower = 0.0;
        int i = 0;
        while (i < this.data.size()) {
            double Starget;
            WaveRecord wave = this.getWave(i);
            double Vbl = Physics.getBulletVelocity(wave.getBulletPower());
            double Sbl = Vbl * (double)(checkTime - wave.getShootTime());
            if (Sbl > (Starget = wave.getShootPoint().distance(targetPoint) + 18.0)) {
                passedBulletPower = wave.getBulletPower();
                this.data.removeElementAt(i);
                break;
            }
            ++i;
        }
        return passedBulletPower;
    }

    public void removeWaveForBulletHit(Point2D hitPoint, long hitTime) {
        int i = 0;
        while (i < this.data.size()) {
            double S_hit;
            WaveRecord wave = this.getWave(i);
            double Vbl = Physics.getBulletVelocity(wave.getBulletPower());
            double Sbl = Vbl * (double)(hitTime - wave.getShootTime());
            if (Sbl > (S_hit = wave.getShootPoint().distance(hitPoint)) - Vbl && Sbl < S_hit + Vbl) {
                this.data.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    public int getWavesNumber() {
        return this.data.size();
    }

    private final /* synthetic */ void this() {
        this.data = new Vector();
    }

    public Wave() {
        this.this();
    }
}

