/*
 * Decompiled with CFR 0.152.
 */
package tcf;

class Pattern {
    private int m_edge;
    private int m_vel;
    private int m_dist1;
    private int m_dist2;
    private int m_ang1;
    private int m_ang2;
    private long m_hashCode;
    private int m_bin;

    Pattern(double edge, double speed, double dist1, double dist2, double ang1, double ang2) {
        int VEL_RANGE = 17;
        int DIST1_RANGE = 241;
        int DIST2_RANGE = 721;
        int ANG1_RANGE = 301;
        int ANG2_RANGE = 901;
        this.m_edge = (int)Math.rint(Math.min(2.0, (edge - 18.0) / 30.0));
        this.m_vel = (int)Math.rint(speed);
        this.m_dist1 = (int)Math.rint(dist1);
        this.m_dist2 = (int)Math.rint(dist2);
        this.m_ang1 = (int)Math.rint(ang1);
        this.m_ang2 = (int)Math.rint(ang2);
        this.m_hashCode = this.m_edge;
        this.m_hashCode = this.m_hashCode * 17L + (long)this.m_vel + 8L;
        this.m_hashCode = this.m_hashCode * 241L + (long)this.m_dist1 + 120L;
        this.m_hashCode = this.m_hashCode * 301L + (long)this.m_ang1 + 150L;
        this.m_hashCode = this.m_hashCode * 721L + (long)this.m_dist2 + 360L;
        this.m_hashCode = this.m_hashCode * 901L + (long)this.m_ang2 + 450L;
        this.m_bin = this.m_edge;
        this.m_bin = this.m_bin * 17 + (this.m_vel + 10) / 4;
        this.m_bin = this.m_bin * 241 + (this.m_dist1 + 120 + 2) / 4;
    }

    public String toString() {
        return String.format("e:%d v:%d d:%d,%d a:%d,%d", this.m_edge, this.m_vel, this.m_dist1, this.m_dist2, this.m_ang1, this.m_ang2);
    }

    public int hashCode() {
        return (int)this.m_hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pattern)) {
            return false;
        }
        Pattern p = (Pattern)o;
        return this.m_hashCode == p.m_hashCode;
    }

    public int bin() {
        return this.m_bin;
    }

    public double distSq(Pattern p) {
        double dist = 0.0;
        dist += (double)((this.m_edge - p.m_edge) * (this.m_edge - p.m_edge));
        dist += (double)((this.m_vel - p.m_vel) * (this.m_vel - p.m_vel));
        dist += (double)((this.m_dist1 - p.m_dist1) * (this.m_dist1 - p.m_dist1));
        dist += (double)((this.m_dist2 - p.m_dist2) * (this.m_dist2 - p.m_dist2));
        dist += (double)((this.m_ang1 - p.m_ang1) * (this.m_ang1 - p.m_ang1));
        return dist += (double)((this.m_ang2 - p.m_ang2) * (this.m_ang2 - p.m_ang2));
    }
}

