/*
 * Decompiled with CFR 0.152.
 */
package aetos;

import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class AetosFirstBot
extends AdvancedRobot {
    String target;
    double targetDist;
    double targetDir;
    double gunTurn;

    public void run() {
        while (true) {
            if (this.getRadarTurnRemaining() == 0.0) {
                this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
            }
            if (this.targetDist > 100.0) {
                this.setAhead(10.0);
            } else if (this.targetDist < 30.0) {
                this.setAhead(-10.0);
            }
            this.out.println("GunTurn:" + this.gunTurn);
            if (this.gunTurn < 0.05) {
                if (this.targetDist < 40.0) {
                    this.setFire(3.0);
                } else if (this.targetDir < 60.0) {
                    this.setFire(2.0);
                } else if (this.targetDir < 100.0) {
                    this.setFire(1.0);
                }
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.target == null) {
            this.target = e.getName();
        } else if (!this.target.equals(e.getName())) {
            if (e.getDistance() < this.targetDist) {
                this.target = e.getName();
            } else {
                return;
            }
        }
        this.targetDist = e.getDistance();
        this.targetDir = e.getBearingRadians();
        double radarTurn = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getRadarHeadingRadians()));
        double extraTurn = Math.min(Math.atan(36.0 / e.getDistance()), 0.7853981633974483);
        this.setTurnRadarRightRadians(radarTurn + (radarTurn < 0.0 ? -extraTurn : extraTurn));
        this.gunTurn = Utils.normalRelativeAngle((double)(this.getHeadingRadians() + e.getBearingRadians() - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(this.gunTurn);
        this.setTurnRight(e.getBearingRadians() * 10.0);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target) {
            this.target = null;
            this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }
}

