/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.operation.ooplace;

import java.util.Iterator;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.Vectors;
import org.la4j.iterator.RowMajorMatrixIterator;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.DenseMatrix;
import org.la4j.matrix.RowMajorSparseMatrix;
import org.la4j.operation.VectorMatrixOperation;
import org.la4j.vector.DenseVector;
import org.la4j.vector.SparseVector;

public class OoPlaceVectorByMatrixMultiplication
extends VectorMatrixOperation<Vector> {
    @Override
    public Vector apply(SparseVector a, DenseMatrix b) {
        DenseVector result = DenseVector.zero(b.columns());
        for (int j = 0; j < b.columns(); ++j) {
            double acc = 0.0;
            VectorIterator it = a.nonZeroIterator();
            while (it.hasNext()) {
                double x = (Double)it.next();
                int i = it.index();
                acc += x * b.get(i, j);
            }
            result.set(j, acc);
        }
        return result;
    }

    @Override
    public Vector apply(SparseVector a, RowMajorSparseMatrix b) {
        Vector result = a.blankOfLength(b.columns());
        VectorIterator these = a.nonZeroIterator();
        while (these.hasNext()) {
            double x = (Double)these.next();
            int i = these.index();
            VectorIterator those = b.iteratorOfRow(i);
            while (those.hasNext()) {
                double y = (Double)those.next();
                int j = those.index();
                result.updateAt(j, Vectors.asPlusFunction(x * y));
            }
        }
        return result;
    }

    @Override
    public Vector apply(SparseVector a, ColumnMajorSparseMatrix b) {
        Vector result = a.blankOfLength(b.columns());
        Iterator<Integer> columns = b.iteratorOrNonZeroColumns();
        while (columns.hasNext()) {
            int j = columns.next();
            VectorIterator these = a.nonZeroIterator();
            VectorIterator those = b.nonZeroIteratorOfColumn(j);
            result.set(j, these.innerProduct(those));
        }
        return result;
    }

    @Override
    public Vector apply(DenseVector a, DenseMatrix b) {
        Vector result = a.blankOfLength(b.columns());
        for (int j = 0; j < b.columns(); ++j) {
            double acc = 0.0;
            for (int i = 0; i < b.rows(); ++i) {
                acc += a.get(i) * b.get(i, j);
            }
            result.set(j, acc);
        }
        return result;
    }

    @Override
    public Vector apply(DenseVector a, RowMajorSparseMatrix b) {
        SparseVector result = SparseVector.zero(b.columns());
        RowMajorMatrixIterator it = b.rowMajorIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.updateAt(j, Vectors.asPlusFunction(x * a.get(i)));
        }
        return result;
    }

    @Override
    public Vector apply(DenseVector a, ColumnMajorSparseMatrix b) {
        SparseVector result = SparseVector.zero(b.columns());
        Iterator<Integer> columns = b.iteratorOrNonZeroColumns();
        while (columns.hasNext()) {
            int j = columns.next();
            VectorIterator it = b.nonZeroIteratorOfColumn(j);
            double acc = 0.0;
            while (it.hasNext()) {
                double x = (Double)it.next();
                int i = it.index();
                acc += x * a.get(i);
            }
            result.set(j, acc);
        }
        return result;
    }

    @Override
    public void ensureApplicableTo(Vector a, Matrix b) {
        if (a.length() != b.rows()) {
            throw new IllegalArgumentException("Given vector should have the same length as number of rows in the given matrix: " + a.length() + " does not equal to " + b.rows() + ".");
        }
    }
}

