/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.AdvancedEFD;
import EFD.EFDUtils;
import EFD.MovementWave;
import EFD.Statistics;
import EFD.TurnAngle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import robocode.BulletHitBulletEvent;
import robocode.Rules;

public class WaveSurfing {
    static final boolean PAINT_DANGER_ZONES = true;
    private AdvancedEFD r;
    public static int BINS = 51;
    public double[] surfStats = new double[BINS];
    public double surfingRadius = 300.0;

    public WaveSurfing(AdvancedEFD r) {
        this.r = r;
    }

    public void doSurfing() {
        MovementWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            this.r.mov.move(this.r.position, this.r.statistics.log.get((int)0).enemyPosition, this.surfingRadius, 1, 8);
            return;
        }
        double[] surfedWaveData = surfWave.data;
        double[] hitEstimates = new double[BINS];
        int numNeighbors = (int)EFDUtils.limit(0.0, Math.sqrt(Statistics.movementLog.size()), 15.0);
        double[][] nearestNeighbors = this.r.statistics.nearestNeighbors(Statistics.movementLog, surfedWaveData, numNeighbors, 10, Statistics.movementWeights);
        int i = 0;
        while (i < nearestNeighbors.length) {
            MovementWave similarWave = Statistics.movementLogToWave.get(nearestNeighbors[i]);
            int index = EFDUtils.getFactorIndex(similarWave.bearingOnHit, similarWave.bearingOnFired, similarWave.getBulletSpeed(), BINS);
            if (similarWave.onTarget) {
                int x = 0;
                while (x < BINS) {
                    int n = x;
                    hitEstimates[n] = hitEstimates[n] + 0.2 / (Math.pow(index - x, 2.0) + 2.0);
                    ++x;
                }
            }
            ++i;
        }
        this.surfStats = hitEstimates;
        double dangerLeft = this.predictPosition((MovementWave)surfWave, (int)1).danger;
        double dangerRight = this.predictPosition((MovementWave)surfWave, (int)-1).danger;
        int surfSpeed = 1000;
        if (dangerLeft < dangerRight) {
            this.r.mov.move(this.r.position, surfWave.origin, this.surfingRadius, 1, surfSpeed);
        } else {
            this.r.mov.move(this.r.position, surfWave.origin, this.surfingRadius, -1, surfSpeed);
        }
    }

    public EscapePath predictPosition(MovementWave surfWave, int direction) {
        double preferredDistance;
        Point2D.Double predictedPosition = (Point2D.Double)this.r.position.clone();
        double predictedVelocity = this.r.getVelocity();
        double predictedHeading = this.r.getHeadingRadians();
        double bulletSpeed = surfWave.getBulletSpeed();
        double targetAngle = surfWave.bearingOnFired;
        double currentAngle = EFDUtils.normaliseAngle(this.r.statistics.log.get(0).getAbsBearing() + Math.PI);
        int counter = 0;
        boolean intercepted = false;
        double distanceToWaveCenter = this.r.position.distance(surfWave.origin);
        int estimatedTurnsToHit = (int)Math.floor(distanceToWaveCenter / surfWave.getBulletSpeed());
        double radius = (double)estimatedTurnsToHit * surfWave.getBulletSpeed();
        if (radius < (preferredDistance = this.evalDistance())) {
            radius += surfWave.getBulletSpeed();
        }
        if (Math.abs(radius - preferredDistance) > 100.0) {
            double factor = Math.floor(Math.abs(radius - preferredDistance) / 100.0);
            radius = radius < preferredDistance ? (radius += surfWave.getBulletSpeed() * factor) : (radius -= surfWave.getBulletSpeed() * factor);
        }
        this.surfingRadius = radius;
        Graphics2D g = this.r.getGraphics();
        g.setColor(Color.green);
        Point2D.Double oldPosition = (Point2D.Double)predictedPosition.clone();
        int index = EFDUtils.getFactorIndex(currentAngle, targetAngle, bulletSpeed, BINS);
        double minimumDanger = this.surfStats[index];
        do {
            double angle = this.r.mov.getOrbitAngle(predictedPosition, surfWave.origin, radius, direction);
            TurnAngle turnAngle = EFDUtils.turnToAngle(angle, predictedHeading);
            predictedHeading = turnAngle.direction > 0 ? (predictedHeading -= turnAngle.turnAngle) : (predictedHeading += turnAngle.turnAngle);
            if (predictedHeading > Math.PI * 2) {
                predictedHeading -= Math.PI * 2;
            }
            predictedVelocity = predictedVelocity > 0.0 ? (turnAngle.reverse ? (predictedVelocity -= 2.0) : (predictedVelocity += 1.0)) : (turnAngle.reverse ? (predictedVelocity -= 1.0) : (predictedVelocity += 2.0));
            predictedVelocity = EFDUtils.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = turnAngle.reverse ? EFDUtils.projectPoint(predictedPosition, predictedHeading + Math.PI, Math.abs(predictedVelocity)) : EFDUtils.projectPoint(predictedPosition, predictedHeading, Math.abs(predictedVelocity));
            currentAngle = EFDUtils.absoluteAngle(surfWave.origin, predictedPosition);
            index = EFDUtils.getFactorIndex(currentAngle, surfWave.bearingOnFired, surfWave.getBulletSpeed(), BINS);
            double danger = this.surfStats[index] - Math.sqrt(EFDUtils.cornerDistance(predictedPosition, this.r)) / this.r.MAX_CORNER_DISTANCE;
            g.setColor(Color.getHSBColor((float)danger, 1.0f, 1.0f));
            g.drawLine((int)predictedPosition.x, (int)predictedPosition.y, (int)oldPosition.x, (int)oldPosition.y);
            oldPosition = (Point2D.Double)predictedPosition.clone();
            if (danger <= minimumDanger) {
                minimumDanger = danger;
            }
            ++counter;
            if (!(predictedPosition.distance(surfWave.origin) < surfWave.distanceTraveled + (double)(counter + 1) * surfWave.getBulletSpeed())) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return new EscapePath(minimumDanger, predictedPosition);
    }

    public MovementWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        MovementWave surfWave = null;
        int x = 0;
        while (x < this.r.statistics.currentMovementWaves.size()) {
            MovementWave ew = this.r.statistics.currentMovementWaves.get(x);
            double distance = this.r.position.distance(ew.origin) - ew.distanceTraveled;
            if (distance > ew.getBulletSpeed() && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public void registerBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.r.statistics.currentMovementWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            MovementWave hitWave = null;
            int x = 0;
            while (x < this.r.statistics.currentMovementWaves.size()) {
                MovementWave ew = this.r.statistics.currentMovementWaves.get(x);
                if (Math.abs(ew.distanceTraveled - hitBulletLocation.distance(ew.origin)) < 50.0 && Math.abs(Rules.getBulletSpeed((double)e.getBullet().getPower()) - ew.getBulletSpeed()) < 0.001) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.r.statistics.currentMovementWaves.remove(this.r.statistics.currentMovementWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void paintWaves() {
        int i = 0;
        while (i < this.r.statistics.currentMovementWaves.size()) {
            this.r.statistics.currentMovementWaves.get(i).paint(this.r.getGraphics(), Color.blue, this.r.getTime());
            ++i;
        }
    }

    public double evalDistance() {
        if (this.r.statistics.log.size() < 1) {
            return 300.0;
        }
        double hitPercentage = (double)(Statistics.bulletsHit + 1) / (double)(Statistics.bulletsShot + 10) * 100.0;
        double enemyHitPercentage = (double)(Statistics.hitByBullets + 1) / (double)(Statistics.enemyBulletsShot + 10) * 100.0;
        double hitDiff = hitPercentage - enemyHitPercentage;
        double energyQuotient = Math.sqrt((this.r.statistics.log.get((int)0).energy + 1.0) / (this.r.statistics.log.get((int)0).enemyEnergy + 1.0));
        if (hitPercentage - enemyHitPercentage > 10.0) {
            energyQuotient = Math.min(energyQuotient, 1.0);
        }
        double preferredDistance = EFDUtils.limit(150.0, (300.0 + hitDiff * 4.0) / energyQuotient, this.r.MAX_DISTANCE * 0.45);
        return preferredDistance;
    }

    public class EscapePath {
        public double danger;
        public Point2D.Double predictedPosition;

        public EscapePath(double danger, Point2D.Double predictedPosition) {
            this.danger = danger;
            this.predictedPosition = predictedPosition;
        }
    }
}

