/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.bothandling;

import alk.lap.LoudAndProud;
import alk.lap.bothandling.DriverI;
import alk.lap.utils.DVektor;

public class WaveSurfer
implements DriverI {
    private LoudAndProud proud;
    private DVektor target;
    private long remainingMoveTurns = 0L;

    public WaveSurfer(LoudAndProud proud) {
        this.proud = proud;
        this.target = null;
    }

    public void moveProud() {
        if (this.target != null) {
            this.proud.getVc().drawPoint(this.target, "currentTarget");
            this.remainingMoveTurns = this.proud.remainingTurnsToMoveProud(this.target, 13.0, false);
            if (this.remainingMoveTurns == 0L) {
                this.target = null;
            }
        }
        if (this.target == null) {
            this.target = this.proud.getTacticLead().getNextTarget();
        } else {
            this.proud.getTacticLead().drawBeams(10L);
        }
        if (this.target == null) {
            this.turnForRightAngleToEnemy(this.proud);
        } else {
            this.remainingMoveTurns = this.proud.remainingTurnsToMoveProud(this.target, 13.0, false);
        }
    }

    public void reset() {
    }

    public void unMount() {
    }

    public long getRemainingMoveTurns() {
        return this.remainingMoveTurns;
    }

    public DVektor getTarget() {
        return this.target;
    }

    public void turnForRightAngleToEnemy(LoudAndProud proud) {
        if (Math.abs(proud.getTurnRemaining()) < 1.0E-5) {
            proud.setTurnRight(WaveSurfer.angleToOptimalHeading(proud));
        }
    }

    public static double angleToOptimalHeading(LoudAndProud proud) {
        double targetBearing = proud.getTacticLead().getEnemyBearing() + 90.0;
        double angle = LoudAndProud.normalRelativeAngle(targetBearing - proud.getHeading());
        if (angle > 90.0) {
            angle -= 180.0;
        }
        if (angle < -90.0) {
            angle += 180.0;
        }
        return angle;
    }
}

