/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy;

import alk.lap.LoudAndProud;
import alk.lap.SpottingRobotI;
import alk.lap.bothandling.DriverI;
import alk.lap.bothandling.Gunner;
import alk.lap.bothandling.WaveSurfer;
import alk.lap.strategy.StatisticBullet;
import alk.lap.strategy.analysis.Analyst;
import alk.lap.strategy.analysis.AnalystsDatabase;
import alk.lap.strategy.analysis.MovementAnalysis;
import alk.lap.strategy.analysis.Recommendation;
import alk.lap.strategy.targetting.BearingTargeting;
import alk.lap.strategy.targetting.LinearTargeting;
import alk.lap.strategy.targetting.MirrorEnemyTargeting;
import alk.lap.strategy.targetting.MoveRespectingLinT;
import alk.lap.strategy.targetting.OccurenceTargeting;
import alk.lap.strategy.targetting.PatternMatchingTargeting;
import alk.lap.strategy.targetting.StatBasedLinTargeting;
import alk.lap.strategy.targetting.StatBearingTargeting;
import alk.lap.strategy.targetting.StatDistanceTargeting;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.Job;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategicLead
implements Job {
    public static final boolean TALK = true;
    public static final boolean DRAW_BULLETS = true;
    private Analyst[] gunnerAnalysts = new Analyst[]{new MovementAnalysis()};
    private AnalystsDatabase analystsDatabase;
    private static String currentGunner = null;
    private LoudAndProud proud;
    private static TreeMap<String, Gunner> gunners;

    public StrategicLead() {
        gunners = new TreeMap();
        TargetStrategy[] gunnersInit = new TargetStrategy[]{new BearingTargeting(), new LinearTargeting(), new OccurenceTargeting(), new OccurenceTargeting().setPullCurrentToMax(1.5), new OccurenceTargeting().setPullCurrentToMax(2.0), new OccurenceTargeting().setPullCurrentToMax(2.5), new MoveRespectingLinT(), new MoveRespectingLinT().setFireEnergy(2.0), new MoveRespectingLinT().setLookBack(5), new MoveRespectingLinT().setLookBack(2), new MoveRespectingLinT().setLookBack(10).setFireEnergy(2.0), new MoveRespectingLinT().setLookBack(15).setFireEnergy(2.5), new StatBasedLinTargeting().setLookBack(18).setFireEnergy(2.0), new StatBasedLinTargeting().setLookBack(18).setFireEnergy(2.5), new StatBasedLinTargeting().setLookBack(18).setFireEnergy(3.0), new StatBasedLinTargeting().setLookBack(9).setFireEnergy(2.6), new MirrorEnemyTargeting(), new StatBearingTargeting(), new StatBearingTargeting().setAngleInterval(2.0), new StatBearingTargeting().setSearchHead(), new StatBearingTargeting().setSearchInvHead(), new StatBearingTargeting().setType(StatisticBullet.BulletType.CONTINOUS), new StatBearingTargeting().setType(StatisticBullet.BulletType.CONTINOUS).setSearchHead(), new StatBearingTargeting().setType(StatisticBullet.BulletType.CONTINOUS).setSearchInvHead(), new StatBearingTargeting().setType(StatisticBullet.BulletType.CONTINOUS).setAngleInterval(2.0), new StatDistanceTargeting(), new StatDistanceTargeting().setFireEnergy(2.5), new PatternMatchingTargeting()};
        currentGunner = gunnersInit[0].describe();
        int i = 0;
        while (i < gunnersInit.length) {
            TargetStrategy t = gunnersInit[i];
            gunners.put(t.describe(), new Gunner(t));
            ++i;
        }
        this.analystsDatabase = new AnalystsDatabase();
        currentGunner = gunnersInit[0].describe();
    }

    public void setProudInstance(LoudAndProud proud) {
        this.proud = proud;
        this.analystsDatabase.newRound(proud);
        int i = 0;
        while (i < this.gunnerAnalysts.length) {
            Analyst a = this.gunnerAnalysts[i];
            a.newRound(proud);
            ++i;
        }
        for (Gunner gunner : this.allGunners()) {
            gunner.newRound(proud);
        }
    }

    @Override
    public void doJob(SpottingRobotI robot) {
        LoudAndProud proud = (LoudAndProud)robot;
        TreeSet<Recommendation> recommendationsForGunners = new TreeSet<Recommendation>();
        int i = 0;
        while (i < this.gunnerAnalysts.length) {
            Analyst analyst = this.gunnerAnalysts[i];
            Recommendation r = analyst.analyse(proud);
            if (r != null) {
                recommendationsForGunners.add(r);
            }
            ++i;
        }
        Recommendation lastR = null;
        for (Recommendation recommendation : recommendationsForGunners) {
            proud.log(recommendation.toString());
            lastR = recommendation;
        }
        if (lastR != null) {
            proud.log(lastR.describeAction());
            lastR.execute();
        }
    }

    @Override
    public String describeYourself() {
        return "Aktualisieren und Verifizieren der Strategie";
    }

    public Gunner getCurrentGunner() {
        return gunners.get(currentGunner);
    }

    public DriverI getFahrer() {
        return new WaveSurfer(this.proud);
    }

    public AnalystsDatabase getAnalystsDB() {
        return this.analystsDatabase;
    }

    void aDummy() {
    }

    public Gunner getGunner(String recommendedGunner) {
        return gunners.get(recommendedGunner);
    }

    public Iterable<Gunner> allGunners() {
        return gunners.values();
    }

    public Iterable<String> allGunnerNames() {
        return gunners.keySet();
    }

    public void setCurrentGunner(String currentGunner) {
        StrategicLead.currentGunner = currentGunner;
    }
}

