/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.analysis;

import alk.lap.LoudAndProud;
import alk.lap.strategy.analysis.AnalystsDatabase;
import alk.lap.utils.DVektor;
import alk.lap.utils.RollingHistory;
import alk.lap.utils.VirtualCanvas;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitAngleStatistic {
    public static final int SEGMENTATION = 3;
    public static final int STAT_SIZE = 120;
    public final int[] hitsAtBearingDelta = new int[120];
    public int count = 0;

    public HitAngleStatistic() {
        int i = 0;
        while (i < this.hitsAtBearingDelta.length) {
            this.hitsAtBearingDelta[i] = 0;
            ++i;
        }
    }

    public void incAtBearing(double bearing) {
        int n = HitAngleStatistic.indexOf(bearing);
        this.hitsAtBearingDelta[n] = this.hitsAtBearingDelta[n] + 1;
        ++this.count;
    }

    public int getHitsAt(double bearing, double beamSize) {
        int sum = 0;
        int i = Math.max(0, HitAngleStatistic.indexOf(bearing - beamSize));
        while (i <= Math.min(119, HitAngleStatistic.indexOf(bearing + beamSize))) {
            sum += this.hitsAtBearingDelta[i];
            ++i;
        }
        return sum;
    }

    public int getHitsAt(double bearing) {
        return this.hitsAtBearingDelta[HitAngleStatistic.indexOf(bearing)];
    }

    public int getHitsAt(int index) {
        return this.hitsAtBearingDelta[index];
    }

    private static int indexOf(double bearing) {
        return (int)((LoudAndProud.normalRelativeAngle(bearing) + 180.0) / 3.0);
    }

    public static double angleOf(int index) {
        return (double)(index * 3) - 180.0 + 1.5;
    }

    public static void paintAngleStat(LoudAndProud proud, RollingHistory<HitAngleStatistic> stat, Color color, String name, int index) {
        VirtualCanvas vc = proud.getVc();
        AnalystsDatabase db = proud.getStrategicLead().getAnalystsDB();
        AnalystsDatabase.StatMax max = db.getBestAngleto(stat, 0.0);
        double height = 100.0;
        double factor = max.score == 0.0 ? 1.0 : height / max.score;
        double paintedAngle = 180.0;
        int startIndexOf = (int)(180.0 - paintedAngle) / 3;
        double statWidth = 550.0;
        double start = 250.0;
        double yPos = 25.0 + height * (double)index + (double)(10 * index);
        double distanceBetweenDots = statWidth / (double)(120 - 2 * startIndexOf);
        DVektor previous = new DVektor(start, yPos);
        vc.drawDirection(previous, max.value, name, color);
        double midPosX = start + (double)(60 - startIndexOf) * distanceBetweenDots;
        vc.drawLine(new DVektor(midPosX, yPos + factor * max.score + 10.0), new DVektor(midPosX, yPos), "", color);
        int i = startIndexOf;
        while (i < 120 - startIndexOf) {
            double angleScore = db.getAngleScore(HitAngleStatistic.angleOf(i), stat, 0.0);
            DVektor current = new DVektor(start + (double)(i - startIndexOf) * distanceBetweenDots, angleScore * factor + yPos);
            vc.drawLine(previous, current, "", color);
            if (angleScore == max.score && max.score != 0.0) {
                vc.drawLine(new DVektor(current.getIntX(), yPos - 7.0 + 10.0), current, "max at " + HitAngleStatistic.angleOf(i) + " with " + angleScore, color);
            }
            previous = current;
            ++i;
        }
    }
}

