/*
 * Decompiled with CFR 0.152.
 */
package alk.lap.strategy.targetting;

import alk.lap.LoudAndProud;
import alk.lap.strategy.AtomicMove;
import alk.lap.strategy.FireWave;
import alk.lap.strategy.PatternBase;
import alk.lap.strategy.targetting.TargetStrategy;
import alk.lap.utils.DVektor;
import alk.lap.utils.LapUtils;
import java.awt.Color;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.SortedSet;

public class PatternMatchingTargeting
implements TargetStrategy {
    public static final String NAME = "PatternT";
    private static final boolean TALK = true;
    private double fireEnergy = 3.0;
    private String name = "PatternT";
    LoudAndProud proud;

    public String describe() {
        return this.name;
    }

    public TargetStrategy.StrategyType getType() {
        return TargetStrategy.StrategyType.Heuristic;
    }

    public PatternMatchingTargeting setName(String name) {
        this.name = name;
        return this;
    }

    public PatternMatchingTargeting setFireEnergy(double fireEnergy) {
        this.fireEnergy = fireEnergy;
        return this;
    }

    public double[] getFireAngleTo(int target, FireWave wave) {
        PatternBase pBase = this.proud.getStrategicLead().getAnalystsDB().getPatternBase();
        double angle = this.proud.getEnemyBearing();
        SortedSet<PatternBase.PatternOccurence> matchingPatternsOccs = pBase.getCurrentMatchingPatternOccurences();
        boolean foundPattern = false;
        if (matchingPatternsOccs == null) {
            this.proud.log("no occurences in history identified");
            return LapUtils.toDArray(angle);
        }
        this.proud.log("occurences in history identified:" + matchingPatternsOccs.size());
        Iterator matchingPatterOccurencIterator = matchingPatternsOccs.iterator();
        while (!foundPattern && matchingPatterOccurencIterator.hasNext()) {
            PatternBase.PatternOccurence patternTry = (PatternBase.PatternOccurence)matchingPatterOccurencIterator.next();
            ListIterator<AtomicMove> iter = pBase.getItemsBeginningAt(patternTry.indexOfOccurence);
            this.proud.log("trying pattern starting at:" + patternTry.indexOfOccurence);
            double enemyHeading = this.proud.getTacticLead().getEnemyHeading();
            double bulletVel = 20.0 - 3.0 * this.fireEnergy;
            AtomicMove move = null;
            DVektor enemyPos = this.proud.getTacticLead().getEnemyPos().copy();
            DVektor proudPos = this.proud.getPosition();
            boolean found = false;
            double time = 0.0;
            while (!found && iter.hasNext()) {
                move = iter.next();
                enemyPos.add(DVektor.fromPolarCoord(enemyHeading += move.turnRate, move.velocity));
                double distance = proudPos.getDistanceTo(enemyPos);
                double btt = distance / bulletVel;
                if (Math.abs(btt - time) < 1.0) {
                    found = true;
                }
                if (!this.proud.isInBorder(enemyPos)) {
                    this.proud.log("pattern leads outside area");
                    break;
                }
                this.proud.getVc().drawPoint(enemyPos.copy(), "Pos at:" + time);
                time += 1.0;
            }
            if (!found) {
                this.proud.log("not enough successors, or outside.. to current pattern found");
                continue;
            }
            angle = proudPos.getDirectionTo(enemyPos);
            this.proud.getVc().drawCircle(enemyPos.copy(), 10.0, "Pos at:" + time, Color.pink);
            foundPattern = true;
        }
        return LapUtils.toDArray(angle);
    }

    public double getFireEnergy() {
        return this.fireEnergy;
    }

    public double getBeamAngle() {
        return -1.0;
    }

    public Color getColorCode() {
        return Color.pink;
    }

    public void newRound(LoudAndProud proud) {
        this.proud = proud;
    }
}

