/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Attractor;
import fnc.bandit.BulletAttractor;
import fnc.bandit.Force;
import fnc.bandit.ForceField;
import fnc.bandit.Position;
import fnc.bandit.Util;
import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RadarTurnCompleteCondition;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class Bandit
extends AdvancedRobot {
    ForceField thefield;
    long scantime;
    double power;
    Position position;
    Attractor target;
    Attractor scantarget;
    boolean forwards;
    boolean talkative;
    boolean frozen;
    double buffer_length;
    int hit_wall_watchdog;
    int reverse_timer;
    boolean clock_wise;
    final int MaxNumberOfRobots = 60;
    int[] number_of_shots_missed;
    int[] number_of_shots_hit;
    long start_round_time;

    public void run() {
        this.talkative = false;
        this.frozen = false;
        this.buffer_length = 80.0;
        this.start_round_time = 0L;
        this.number_of_shots_missed = new int[60];
        this.number_of_shots_hit = new int[60];
        this.position = new Position(this.getX(), this.getY());
        this.thefield = new ForceField(((Robot)this).out, this.getBattleFieldWidth(), this.getBattleFieldHeight());
        Util.setFieldSize(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this.hit_wall_watchdog = 0;
        this.reverse_timer = 20;
        this.clock_wise = true;
        this.setColors(Color.white, Color.white, Color.white);
        this.addCustomEvent((Condition)new RadarTurnCompleteCondition((AdvancedRobot)this));
        this.setTurnRadarLeft(360.0);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.thefield.countZero();
        while (true) {
            this.execute();
            this.selectTarget();
            if (this.target != null) {
                this.target.analyse();
            }
            while (this.getGunHeat() > 0.0) {
                this.countZero();
                this.aim();
                this.move();
                this.execute();
            }
            int n = 10;
            while (this.target != null && !this.aim() && n > 0) {
                this.countZero();
                this.move();
                this.execute();
                --n;
            }
            if (n == 0) {
                if (!this.talkative) continue;
                ((Robot)this).out.println("aim takes too long");
                continue;
            }
            if (this.target == null) continue;
            if (this.talkative) {
                this.target.dump(((Robot)this).out);
            }
            this.target.firedOn();
            if (this.talkative) {
                ((Robot)this).out.println("Fire! " + this.power);
            }
            this.fire(this.power);
        }
    }

    public void countZero() {
        if (this.hit_wall_watchdog > 0) {
            --this.hit_wall_watchdog;
        }
        this.thefield.countZero();
    }

    public void onCustomEvent(CustomEvent customEvent) {
        if (customEvent.getCondition() instanceof RadarTurnCompleteCondition) {
            this.precision_scan();
        }
    }

    public void statistics(int n) {
        if (this.number_of_shots_hit != null && this.number_of_shots_missed != null && n > 0 && n < 60) {
            int n2 = this.number_of_shots_hit[n] + this.number_of_shots_missed[n];
            if (n2 > 0) {
                ((Robot)this).out.print("[" + n + "] HitRatio: ");
                double d = (double)this.number_of_shots_hit[n] / (double)n2;
                ((Robot)this).out.print(Util.round(d));
                if (this.getTime() - this.start_round_time > 0L) {
                    ((Robot)this).out.println(" Rate: " + Util.round((double)n2 / (double)(this.getTime() - this.start_round_time)));
                } else {
                    ((Robot)this).out.println("");
                }
                this.start_round_time = this.getTime();
            } else {
                ((Robot)this).out.println("[" + n + "] No shots fired");
                this.start_round_time = this.getTime();
            }
        }
    }

    public void turnRadarTo(Position position, double d) {
        double d2 = this.getRadarHeadingRadians();
        this.position.x = this.getX();
        this.position.y = this.getY();
        double d3 = this.position.bearing(position);
        double d4 = Util.offset(d2, d3);
        d4 = d4 < 0.0 ? (d4 -= d) : (d4 += d);
        this.setTurnRadarRightRadians(d4);
    }

    public void precision_scan() {
        this.position.x = this.getX();
        this.position.y = this.getY();
        this.scantarget = this.thefield.findScanTarget(this.getTime());
        if (this.scantarget != null) {
            double d = this.getTime() - this.scantarget.getScanTime();
            if (d > 10.0) {
                this.setTurnRadarLeft(360.0);
            } else {
                double d2 = Math.abs(Math.atan2(d * 16.0, this.position.distance(this.scantarget.getPosition())));
                this.turnRadarTo(this.scantarget.getPosition(), d2);
            }
        } else {
            this.setTurnRadarLeft(360.0);
        }
        if (this.getTime() - this.scantime > 50L) {
            this.setTurnRadarLeft(360.0);
        }
    }

    public void move() {
        double d;
        this.position.x = this.getX();
        this.position.y = this.getY();
        Force force = this.thefield.force(this.position, this.getTime());
        int n = Util.getSector(this.position, this.buffer_length);
        --this.reverse_timer;
        if (this.reverse_timer == 0) {
            this.reverse_timer = 40;
            boolean bl = this.clock_wise = !this.clock_wise;
        }
        if (this.clock_wise) {
            switch (n) {
                case 1: {
                    force.vx = 0.2;
                    force.vy = 1.0;
                    break;
                }
                case 2: {
                    force.vx = 0.1;
                    force.vy = 1.0;
                    break;
                }
                case 3: {
                    force.vx = 1.0;
                    force.vy = -0.1;
                    break;
                }
                case 4: {
                    force.vx = 1.0;
                    force.vy = -0.1;
                    break;
                }
                case 5: {
                    force.vx = -0.1;
                    force.vy = -1.0;
                    break;
                }
                case 6: {
                    force.vx = -0.1;
                    force.vy = -1.0;
                    break;
                }
                case 7: {
                    force.vx = -1.0;
                    force.vy = 0.1;
                    break;
                }
                case 8: {
                    force.vx = -1.0;
                    force.vy = 0.1;
                    break;
                }
                case 9: {
                    break;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    force.vx = 1.0;
                    force.vy = 0.2;
                    break;
                }
                case 2: {
                    force.vx = 0.1;
                    force.vy = -1.0;
                    break;
                }
                case 3: {
                    force.vx = 0.1;
                    force.vy = -1.0;
                    break;
                }
                case 4: {
                    force.vx = -1.0;
                    force.vy = -0.1;
                    break;
                }
                case 5: {
                    force.vx = -1.0;
                    force.vy = -0.1;
                    break;
                }
                case 6: {
                    force.vx = -0.1;
                    force.vy = 1.0;
                    break;
                }
                case 7: {
                    force.vx = -0.1;
                    force.vy = 1.0;
                    break;
                }
                case 8: {
                    force.vx = 1.0;
                    force.vy = 0.1;
                    break;
                }
                case 9: {
                    break;
                }
            }
        }
        if (force.strength() < 0.05) {
            this.setMaxVelocity(0.0);
        } else if (force.strength() < 0.1) {
            this.setMaxVelocity(6.0);
        } else {
            this.setMaxVelocity(8.0);
        }
        double d2 = this.getHeadingRadians();
        double d3 = force.bearing();
        if (!this.forwards && (d3 += Math.PI) > Math.PI * 2) {
            d3 -= Math.PI * 2;
        }
        if (Math.abs(d = Util.offset(d2, d3)) > 1.5707963267948966) {
            this.forwards = !this.forwards;
            d -= Math.PI;
        }
        if (Math.abs(d) > 0.06283185307179587) {
            if (d > 0.0) {
                this.setTurnRightRadians(d);
            } else {
                this.setTurnLeftRadians(-d);
            }
        }
        if (!this.frozen) {
            double d4 = n == 9 ? 90.0 : 20.0;
            if (this.forwards) {
                this.setAhead(d4);
            } else {
                this.setBack(d4);
            }
        }
    }

    public final void selectTarget() {
        double d = this.getGunHeadingRadians();
        this.position.x = this.getX();
        this.position.y = this.getY();
        if (this.target != null) {
            this.target.untarget();
        }
        this.target = this.thefield.findTarget(this.position, d);
        if (this.target != null) {
            this.target.istarget();
        }
    }

    public boolean aim() {
        if (this.target != null) {
            this.position.x = this.getX();
            this.position.y = this.getY();
            this.power = this.target.firePower(this.position);
            double d = this.getGunHeadingRadians();
            double d2 = this.target.gunOffset(this.position, d, this.power, this.getTime());
            if (this.thefield.inside(this.target.getPredicted_position())) {
                if (d2 > 0.0) {
                    this.turnGunRightRadians(d2);
                } else {
                    this.turnGunLeftRadians(-d2);
                }
                if (Math.abs(d2) < 0.5) {
                    if (this.talkative) {
                        ((Robot)this).out.println("Aim ready: " + d2);
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        String string = scannedRobotEvent.getName();
        double d = (this.getHeadingRadians() + scannedRobotEvent.getBearingRadians()) % (Math.PI * 2);
        double d2 = this.getX() + Math.sin(d) * scannedRobotEvent.getDistance();
        double d3 = this.getY() + Math.cos(d) * scannedRobotEvent.getDistance();
        if (!this.thefield.contains(string)) {
            Position position = new Position(d2, d3, this.getTime());
            Attractor attractor = new Attractor(string, position, scannedRobotEvent.getEnergy(), this.getBattleFieldWidth(), this.getBattleFieldHeight(), ((Robot)this).out);
            this.thefield.addAttractor(attractor);
            attractor.analyse();
        } else {
            this.position.x = this.getX();
            this.position.y = this.getY();
            Attractor attractor = this.thefield.getAttractor(string);
            attractor.update(scannedRobotEvent, d2, d3, this.getTime(), this.position);
            attractor.analyse();
            if (attractor.fired()) {
                BulletAttractor bulletAttractor = new BulletAttractor(string + attractor.getNumberFired(), attractor.getFirePosition(), Util.bulletSpeed(attractor.sizeOfLastBullet()), this.getBattleFieldWidth(), this.getBattleFieldHeight());
                this.thefield.addBulletAttractor(bulletAttractor);
            }
        }
        this.scantime = this.getTime();
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        String string = hitByBulletEvent.getName();
        Attractor attractor = this.thefield.getAttractor(string);
        if (attractor != null) {
            attractor.hasHit(this.position);
        }
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        String string = bulletHitEvent.getName();
        Attractor attractor = this.thefield.getAttractor(string);
        if (attractor != null) {
            this.position.x = this.getX();
            this.position.y = this.getY();
            attractor.hit(bulletHitEvent, this.getTime(), this.position);
        }
        int n = this.thefield.count();
        this.number_of_shots_hit[n] = this.number_of_shots_hit[n] + 1;
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        int n = this.thefield.count();
        this.number_of_shots_missed[n] = this.number_of_shots_missed[n] + 1;
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        String string = hitRobotEvent.getName();
        if (this.thefield.contains(string)) {
            if (this.target != null) {
                this.target.untarget();
            }
            this.target = this.thefield.getAttractor(string);
            if (this.target != null) {
                this.target.istarget();
                this.position.x = this.getX();
                this.position.y = this.getY();
                this.target.rammed(this.position, hitRobotEvent);
            }
        }
    }

    public void onWin(WinEvent winEvent) {
        this.setTurnLeftRadians(10.0);
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        String string = robotDeathEvent.getName();
        if (this.target != null) {
            if (string.equals(this.target.getName())) {
                this.target.deathStatistics(((Robot)this).out);
                this.target = null;
            } else if (this.thefield.contains(string)) {
                Attractor attractor = this.thefield.getAttractor(string);
                attractor.deathStatistics(((Robot)this).out);
            }
        }
        if (this.talkative) {
            this.statistics(this.thefield.count());
        }
        this.thefield.removeAttractor(string);
    }
}

