/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Analyser;
import fnc.bandit.Path;
import fnc.bandit.Position;
import fnc.bandit.Util;
import java.io.PrintStream;

public class LinearAnalyser
extends Analyser {
    final int maxpositions = 10;
    int top = 0;
    double[] velocities;
    double[] times;
    double a_0 = 0.0;
    double a_top = 0.0;
    double velocity;
    Position p_0 = new Position(0.0, 0.0, 0.0, 0.0);
    Position p_top = new Position(0.0, 0.0, 0.0, 0.0);

    public LinearAnalyser() {
        this.velocities = new double[10];
        this.times = new double[10];
    }

    public void dump(PrintStream printStream) {
        printStream.print("Linear [" + Util.round(this.abs_error) + "] ");
        if (this.top == 0) {
            printStream.println("undefined");
        } else {
            printStream.println(this.p_0 + "(" + this.velocities[0] + "," + this.a_0 + ") " + this.p_top + " (" + this.velocities[this.top] + "," + this.a_top + " ) ");
        }
    }

    public double analyse(Path path) {
        int n = path.getCount();
        if (n >= 3) {
            if (n > 10) {
                this.computeVelocity(path, 10);
            } else {
                this.computeVelocity(path, n - 1);
            }
        }
        this.absError(path);
        return this.abs_error;
    }

    public void computeVelocity(Path path, int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Position position = path.getPosition(-n);
        this.p_0.t = position.t;
        this.p_0.x = position.x;
        this.p_0.y = position.y;
        this.p_0.h = position.bearing(path.getPosition(0));
        int n2 = 0;
        int n3 = -n + 1;
        while (n3 <= 0) {
            Position position2 = path.getPosition(n3);
            d = position2.t - position.t;
            d3 = position.distance(position2);
            position = position2;
            this.times[n2] = position.t;
            this.velocities[n2] = d3 / d;
            ++n2;
            ++n3;
        }
        this.top = n2 - 1;
        if (this.top > 3) {
            this.a_0 = (this.velocities[3] - this.velocities[0]) / (this.times[3] - this.times[0]);
            if (Math.abs(this.a_0) < 0.1) {
                this.a_0 = 0.0;
            }
            this.a_top = (this.velocities[this.top] - this.velocities[this.top - 3]) / (this.times[this.top] - this.times[this.top - 3]);
            if (Math.abs(this.a_top) < 0.1) {
                this.a_top = 0.0;
            }
        }
        this.p_top.x = position.x;
        this.p_top.y = position.y;
        this.p_top.t = position.t;
        this.p_top.h = this.p_0.h;
    }

    public Position predictPosition(Path path, double d, double d2) {
        Position position = path.getPosition(0);
        if (this.top == 0) {
            Position position2 = new Position(position.x, position.y, d2 + d);
            return position2;
        }
        double d3 = d + d2;
        Position position3 = new Position(0.0, 0.0, d3);
        double d4 = this.p_0.h;
        if (d3 < this.times[0]) {
            position3.x = this.p_0.x;
            position3.y = this.p_0.y;
            position3.h = this.p_0.h;
        } else if (d3 > this.times[this.top]) {
            double d5 = d3 - this.times[this.top];
            double d6 = this.velocities[this.top];
            double d7 = 0.0;
            if (this.a_top > 0.0) {
                double d8 = (8.0 - d6) / this.a_top;
                if (d8 > d5) {
                    d8 = d5;
                }
                d7 += 0.5 * this.a_top * this.a_top * d8;
                d7 += d6 * (d5 - d8);
            } else if (this.a_top < 0.0) {
                double d9 = -(d6 / this.a_top);
                if (d9 > d5) {
                    d9 = d5;
                }
                d7 = 0.5 * this.a_top * this.a_top * d9;
            } else {
                d7 = d5 * d6;
            }
            position3.x = this.p_top.x + d7 * Math.sin(this.p_top.h);
            position3.y = this.p_top.y + d7 * Math.cos(this.p_top.h);
        } else {
            double d10 = d3 - this.times[0];
            position3.x = this.p_0.x + this.velocities[0] * d10 * Math.sin(this.p_top.h);
            position3.y = this.p_0.y + this.velocities[0] * d10 * Math.cos(this.p_top.h);
        }
        return this.keepInside(position3);
    }
}

