/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.util.HashMap;
import java.util.Map;
import robocode.BattleEndedEvent;
import robocode.RoundEndedEvent;
import xander.core.Configuration;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.RobotProxy;
import xander.core.event.RoundListener;
import xander.core.event.TurnListener;
import xander.core.log.Log;
import xander.core.log.Logger;

public class DriveStats
implements TurnListener,
RoundListener {
    private static final String NO_DRIVE = "No Drive";
    private static final Log log = Logger.getLog(DriveStats.class);
    private RobotProxy robotProxy;
    private Map<String, Long> driveTimes = new HashMap<String, Long>();
    private String activeDrive = "No Drive";
    private long activeDriveStartTime = 0L;
    private boolean logDriveTimes;

    public DriveStats(RobotProxy robotProxy, RobotEvents robotEvents, Configuration configuration) {
        this.robotProxy = robotProxy;
        this.logDriveTimes = configuration.isLogDriveTimes();
        robotEvents.addTurnListener(this);
        robotEvents.addRoundListener(this);
    }

    @Override
    public void onTurnBegin() {
    }

    @Override
    public void onTurnEnd() {
        String currentActiveDrive = this.robotProxy.getActiveDriveName();
        if (currentActiveDrive == null) {
            currentActiveDrive = NO_DRIVE;
        }
        if (!currentActiveDrive.equals(this.activeDrive)) {
            long cumulativeTime = Resources.getCumulativeTime();
            long timeForActiveDrive = cumulativeTime - this.activeDriveStartTime;
            if (timeForActiveDrive > 0L) {
                Long prevTime = this.driveTimes.get(this.activeDrive);
                if (prevTime == null) {
                    this.driveTimes.put(this.activeDrive, timeForActiveDrive);
                } else {
                    this.driveTimes.put(this.activeDrive, timeForActiveDrive + prevTime);
                }
            }
            this.activeDrive = currentActiveDrive;
            this.activeDriveStartTime = cumulativeTime;
        }
    }

    public long getDriveTime(String driveName) {
        Long driveTime = this.driveTimes.get(driveName);
        if (driveTime == null) {
            return 0L;
        }
        return driveTime;
    }

    public double getDriveUsagePercent(String driveName) {
        long driveTime = this.getDriveTime(driveName);
        return (double)driveTime / (double)Resources.getCumulativeTime();
    }

    private void logDriveTimes() {
        for (Map.Entry<String, Long> entry : this.driveTimes.entrySet()) {
            log.stat(String.valueOf(entry.getKey()) + ": " + entry.getValue().toString() + " ticks");
        }
    }

    @Override
    public void onBattleEnded(BattleEndedEvent event) {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent event) {
        if (this.logDriveTimes) {
            this.logDriveTimes();
        }
    }
}

