/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.segment;

import xander.core.Resources;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.gfws.segment.Segmenter;

public class DefenderAccelerationSegmenter
implements Segmenter {
    private String myRobotName = Resources.getRobotProxy().getName();

    @Override
    public String getName() {
        return "Defender Acceleration Segmenter";
    }

    @Override
    public int getNumSegments() {
        return 3;
    }

    @Override
    public int getSegmentIndex(Wave wave) {
        double ps;
        SnapshotHistory history = Resources.getSnapshotHistory();
        Snapshot defenderSnapshot = wave.getInitialDefenderSnapshot();
        Snapshot previousDefenderSnapshot = null;
        previousDefenderSnapshot = defenderSnapshot.getName().equals(this.myRobotName) ? history.getMySnapshot(defenderSnapshot.getTime() - 1L) : history.getSnapshot(defenderSnapshot.getName(), defenderSnapshot.getTime() - 1L);
        double s = defenderSnapshot.getVelocity();
        double d = ps = previousDefenderSnapshot == null ? s : previousDefenderSnapshot.getVelocity();
        if (s == ps) {
            return 0;
        }
        if (s > 0.0 && ps < 0.0 || s < 0.0 && ps > 0.0 || Math.abs(s) > Math.abs(ps)) {
            return 2;
        }
        return 1;
    }

    @Override
    public double getSegmentValue(Wave wave) {
        return this.getSegmentIndex(wave);
    }

    @Override
    public double getSegmentValuePercent(Wave wave) {
        int segmentIndex = this.getSegmentIndex(wave);
        switch (segmentIndex) {
            case 0: {
                return 0.5;
            }
            case 1: {
                return 0.0;
            }
        }
        return 1.0;
    }

    @Override
    public String getSegmentDescription(int segmentIndex) {
        switch (segmentIndex) {
            case 0: {
                return "Steady Speed";
            }
            case 1: {
                return "Decelerating";
            }
        }
        return "Accelerating";
    }
}

