/*
 * Decompiled with CFR 0.152.
 */
package Krabb.krabby2;

import Krabb.krabby2.Constants;
import Krabb.krabby2.EnemyStats;
import Krabb.krabby2.HisWave;
import java.awt.Graphics2D;
import java.util.ArrayList;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Enemy
extends Constants {
    private static int hits;
    private static int shots;
    private ArrayList stats;
    private ArrayList waves;
    private boolean alive;
    private double lastv;
    double lastgf;

    public void Step() {
        int size = this.waves.size();
        int i = 0;
        while (i < size) {
            if (!((HisWave)this.waves.get(i)).Step(this)) {
                this.waves.remove(i);
                --size;
            }
            ++i;
        }
    }

    public int getShots() {
        return shots;
    }

    public int getHits() {
        return hits;
    }

    public EnemyStats getEnemyStats() {
        if (!this.stats.isEmpty()) {
            return (EnemyStats)this.stats.get(0);
        }
        return new EnemyStats();
    }

    public EnemyStats getEnemyStats(int i) {
        if (this.stats.size() > i) {
            return (EnemyStats)this.stats.get(i);
        }
        return new EnemyStats();
    }

    public EnemyStats getEnemyTimeStats(long t) {
        if (this.stats.size() == 0) {
            return null;
        }
        int i = 0;
        while (i < 100 && i < this.stats.size()) {
            EnemyStats en = (EnemyStats)this.stats.get(i);
            if (en.time <= t) {
                return en;
            }
            ++i;
        }
        return (EnemyStats)this.stats.get(this.stats.size() - 1);
    }

    public HisWave getEnemyWave(int i) {
        if (this.waves.size() > i) {
            return (HisWave)this.waves.get(i);
        }
        System.out.println("No wave at" + i + " !");
        return (HisWave)this.waves.get(this.waves.size() - 1);
    }

    int getLastEnemyShot() {
        double lasttime = 0.0;
        int last = 0;
        int n = 0;
        while (n < this.waves.size()) {
            double d;
            HisWave w = this.getEnemyWave(n);
            if (!(w.d / w.v < (double)this.getTime() - w.t) && (d = w.t + w.d / w.v) > lasttime) {
                lasttime = d;
                last = n;
            }
            ++n;
        }
        return last;
    }

    int getFirstEnemyShot() {
        double smallesttime = 999999.0;
        int smallest = -1;
        int n = 0;
        while (n < this.waves.size()) {
            double d;
            HisWave w = this.getEnemyWave(n);
            if (!(w.d / w.v < (double)this.getTime() - w.t) && (d = w.t + w.d / w.v) < smallesttime) {
                smallesttime = d;
                smallest = n;
            }
            ++n;
        }
        return smallest;
    }

    public void newEnemyGF(double gf) {
        this.lastgf = gf;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public int getEnemyWaveSize() {
        return this.waves.size();
    }

    public int getEnemySize() {
        return this.stats.size();
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.stats.size() == 0 || ((EnemyStats)this.stats.get((int)0)).time < this.getTime()) {
            this.stats.add(0, new EnemyStats(e, this));
        }
        EnemyStats e0 = this.getEnemyStats(0);
        EnemyStats e1 = this.getEnemyStats(1);
        if (e1.l - e0.l > 0.0 && e0.d > 50.0) {
            ++shots;
            if (e1.l - e0.l >= 0.1 && e1.l - e0.l <= (double)3) {
                this.waves.add(0, new HisWave(this, e0, e1.l - e0.l));
            }
        }
        if (this.lastv * e.getVelocity() <= 0.0) {
            this.getEnemyStats().lchange = this.getTime();
        }
        this.lastv = e.getVelocity();
        super.onScannedRobot(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        double p = e.getBullet().getPower();
        double dmg = (double)4 * p + (double)2 * Math.max(p - 1.0, 0.0);
        this.getEnemyStats().l -= dmg;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        ++hits;
        this.getEnemyStats().l += e.getBullet().getPower() * (double)3;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.alive = false;
        ((EnemyStats)this.stats.get((int)0)).l = -2.0;
    }

    public void onPaint(Graphics2D g) {
        double hitrate = hits == 0 ? 0.0 : (double)hits / ((double)shots / 100.0);
        g.drawString("His Rate:  Hits:" + hits + " Schots:" + shots + " Hitrate: " + hitrate + '%', 300, 20);
        int i = 0;
        while (i < this.waves.size()) {
            ((HisWave)this.waves.get(i)).onPaint(g, this);
            ++i;
        }
        this.getEnemyStats().onPaint(g);
        g.drawString("lastGF: " + this.lastgf, 300, 30);
    }

    private final /* synthetic */ void this() {
        this.stats = new ArrayList();
        this.waves = new ArrayList();
        this.alive = true;
        this.lastv = 0.0;
        this.lastgf = 0.0;
    }

    Enemy() {
        this.this();
    }
}

