/*
 * Decompiled with CFR 0.152.
 */
package rampancy.standard;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import rampancy.RMovementManager;
import rampancy.RampantRobot;
import rampancy.standard.MoveProfile;
import rampancy.standard.MoveStruct;
import rampancy.standard.RDefaultWaveManager;
import rampancy.util.RBattlefield;
import rampancy.util.REnemyRobot;
import rampancy.util.RPoint;
import rampancy.util.RUtil;
import rampancy.util.movement.MovSim;
import rampancy.util.movement.MovSimStat;
import rampancy.util.movement.RMoveChoice;
import rampancy.util.wave.REnemyWave;
import rampancy.util.wave.REnemyWaveWithStats;
import robocode.util.Utils;

public class RDefaultMovementManager
implements RMovementManager {
    public static final double MIN_DISTANCE = 230.0;
    public static final double MIN_WAVE_ORBIT_DISTANCE = 230.0;
    public static final double MAX_ORBIT_DISTANCE = 475.0;
    public static final Color CW_COLOR = new Color(0, 0, 255);
    public static final Color CCW_COLOR = new Color(0, 200, 200);
    public static final int CW = 1;
    public static final int CCW = -1;
    private ArrayList<RMoveChoice> examinedMovementChoices = new ArrayList();
    private RampantRobot reference;
    private int direction;
    private REnemyWave lastWave;

    public RDefaultMovementManager(RampantRobot reference) {
        this.reference = reference;
        this.direction = 1;
    }

    public void updateReference(RampantRobot reference) {
        this.reference = reference;
    }

    public RMoveChoice computeBestMove(REnemyRobot enemy) {
        REnemyWave enemyWave = RampantRobot.getWaveManager().getClosestEnemyWave(this.reference.getLocation());
        REnemyWave secondWave = null;
        if (RampantRobot.getWaveManager() instanceof RDefaultWaveManager) {
            secondWave = ((RDefaultWaveManager)RampantRobot.getWaveManager()).getNthClosestEnemyWave(this.reference.getLocation(), 2);
        }
        if (enemyWave == null) {
            enemyWave = new REnemyWaveWithStats(enemy);
        }
        this.examinedMovementChoices.clear();
        this.lastWave = enemyWave;
        MoveStruct moveStruct = new MoveStruct(this.reference, enemy, enemyWave, secondWave);
        this.simulateMove(moveStruct);
        if (this.examinedMovementChoices.isEmpty()) {
            return null;
        }
        this.computeDangerForMoveChoices(moveStruct);
        this.sortMoveChoices();
        this.setDangerColors();
        this.direction = this.examinedMovementChoices.get((int)0).direction;
        this.examinedMovementChoices.get((int)0).color = Color.pink;
        return this.examinedMovementChoices.get(0);
    }

    public void draw(Graphics2D g) {
        for (RMoveChoice moveChoice : this.examinedMovementChoices) {
            moveChoice.draw(g);
        }
    }

    private void simulateMove(MoveStruct moveStruct) {
        MoveProfile startProfileCW = new MoveProfile(this.reference.getCopyOfLocation(), -5000.0, this.reference.getHeadingRadians(), this.reference.getHeadingRadians(), this.reference.getVelocity(), 8.0, 1, 0);
        startProfileCW.initialOrbitAngle = this.computeOrbitAngle(startProfileCW, moveStruct);
        MoveProfile startProfileCCW = startProfileCW.getCopy();
        startProfileCCW.direction = -1;
        startProfileCCW.initialOrbitAngle = this.computeOrbitAngle(startProfileCCW, moveStruct);
        this.recursiveSimulateMove(1, startProfileCW, moveStruct);
        this.recursiveSimulateMove(-1, startProfileCCW, moveStruct);
    }

    private void recursiveSimulateMove(int direction, MoveProfile currentProfile, MoveStruct moveStruct) {
        if (!moveStruct.wave.intercepted(currentProfile.fromLocation, currentProfile.futureTicks)) {
            this.simulateMoveDirection(direction, currentProfile, moveStruct);
        }
    }

    private void simulateMoveDirection(int direction, MoveProfile currentProfile, MoveStruct moveStruct) {
        MoveProfile moveProfile = currentProfile.getCopy();
        moveProfile.desiredHeading = this.computeOrbitAngle(currentProfile, moveStruct);
        MoveProfile predictedProfile = this.predictPosition(moveProfile);
        this.logLocation(predictedProfile, moveStruct);
        this.recursiveSimulateMove(direction, predictedProfile, moveStruct);
    }

    private void logLocation(MoveProfile currentProfile, MoveStruct moveStruct) {
        double distance = currentProfile.fromLocation.distance(moveStruct.wave.getOrigin());
        double danger = 0.0;
        double guessFactor = RUtil.getFactorIndex(moveStruct.wave, currentProfile.fromLocation, 61);
        RMoveChoice moveChoice = new RMoveChoice(currentProfile.fromLocation, currentProfile.initialOrbitAngle, distance, currentProfile.maxVelocity, danger, guessFactor, currentProfile.futureTicks, currentProfile.direction);
        this.examinedMovementChoices.add(moveChoice);
    }

    private double computeOrbitAngle(MoveProfile currentProfile, MoveStruct moveStruct) {
        RPoint orbitLocation = moveStruct.wave.getOrigin();
        double distanceToCenterOfOrbit = orbitLocation.distance(currentProfile.fromLocation);
        double absB = RUtil.computeAbsoluteBearing(orbitLocation, currentProfile.fromLocation);
        double orbitAngle = absB + 1.5707963267948966 * (double)currentProfile.direction;
        double attackAngle = this.computeAttackAngle(currentProfile, moveStruct) + orbitAngle;
        double wallSmoothedAngle = RUtil.wallSmoothing(currentProfile.fromLocation, attackAngle, currentProfile.direction, distanceToCenterOfOrbit);
        return Utils.normalAbsoluteAngle((double)wallSmoothedAngle);
    }

    private double computeAttackAngle(MoveProfile currentProfile, MoveStruct moveStruct) {
        double distanceToEnemy = currentProfile.fromLocation.distance(moveStruct.enemy.getCurrentState().location);
        double distanceToWaveOrigin = currentProfile.fromLocation.distance(moveStruct.wave.getOrigin());
        if (distanceToEnemy < 230.0) {
            return -0.5235987755982988 * (double)currentProfile.direction;
        }
        if (distanceToEnemy < 475.0) {
            return 0.0;
        }
        return 0.39269908169872414 * (double)currentProfile.direction;
    }

    private void computeDangerForMoveChoices(MoveStruct moveStruct) {
        REnemyWaveWithStats statWave = null;
        REnemyWaveWithStats secondStatWave = null;
        if (moveStruct.wave instanceof REnemyWaveWithStats) {
            statWave = (REnemyWaveWithStats)moveStruct.wave;
        }
        for (RMoveChoice moveChoice : this.examinedMovementChoices) {
            double danger = statWave.getDangerForLocation(moveChoice.destination, 61);
            if (secondStatWave != null) {
                danger += secondStatWave.getDangerForLocation(moveChoice.destination, 61);
            }
            moveChoice.danger += danger;
        }
    }

    private void sortMoveChoices() {
        Collections.sort(this.examinedMovementChoices, new Comparator<RMoveChoice>(){

            @Override
            public int compare(RMoveChoice o1, RMoveChoice o2) {
                return RUtil.sign(o1.danger - o2.danger);
            }
        });
    }

    private void setDangerColors() {
        double largest = this.examinedMovementChoices.get((int)(this.examinedMovementChoices.size() - 1)).danger;
        for (RMoveChoice moveChoice : this.examinedMovementChoices) {
            Color dangerColor = new Color(0, 0, 200);
            if (moveChoice.danger > 0.01) {
                dangerColor = new Color((int)(155.0 * (moveChoice.danger / largest)) + 100, 0, 0);
            }
            moveChoice.color = dangerColor;
        }
    }

    private MoveProfile predictPosition(MoveProfile currentProfile) {
        double angleToTurn = currentProfile.desiredHeading - currentProfile.currentHeading;
        int moveDirection = 1;
        if (Math.cos(angleToTurn) < 0.0) {
            angleToTurn += Math.PI;
            moveDirection = -1;
        }
        RPoint fromLocation = currentProfile.fromLocation;
        angleToTurn = Utils.normalRelativeAngle((double)angleToTurn);
        RBattlefield bf = RampantRobot.getGlobalBattlefield();
        MovSimStat[] nextTick = MovSim.futurePos(1, fromLocation.x, fromLocation.y, currentProfile.currentVelocity, currentProfile.maxVelocity, currentProfile.currentHeading, 1000 * moveDirection, angleToTurn, 10.0, bf.width, bf.height);
        MovSimStat sim = nextTick[0];
        return new MoveProfile(new RPoint(sim.x, sim.y), currentProfile.initialOrbitAngle, sim.h, sim.h, sim.v, currentProfile.maxVelocity, currentProfile.direction, currentProfile.futureTicks + 1);
    }
}

