/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util;

import java.awt.geom.Rectangle2D;
import rampancy.util.RPoint;

public class RRectangle
extends Rectangle2D.Double {
    public static RRectangle getIntersectionRectangle(RPoint p1, RPoint p2) {
        return RRectangle.getIntersectionRectangle(p1, p2, 18.0, 18.0);
    }

    public static RRectangle getIntersectionRectangle(RPoint p1, RPoint p2, double r1, double r2) {
        RRectangle rect1 = new RRectangle(p1, r1);
        RRectangle rect2 = new RRectangle(p2, r2);
        RRectangle intersection = (RRectangle)rect1.createIntersection(rect2);
        if (intersection.width < 0.0 || intersection.height < 0.0) {
            return null;
        }
        return intersection;
    }

    public RRectangle(RPoint point) {
        this(point, 18.0);
    }

    public RRectangle(RPoint point, double radius) {
        this(point.x - radius, point.y - radius, radius * 2.0, radius * 2.0);
    }

    public RRectangle(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public RPoint getCenter() {
        return new RPoint(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }
}

