/*
 * Decompiled with CFR 0.152.
 */
package rampancy.util.data.segmentTree;

import rampancy.util.RRobotState;
import rampancy.util.data.segmentTree.RSTNode;

public class RSegmentTree {
    private RSTNode rootNode;
    private RSTNode[] nodeOrder;
    private int visitsBeforeBranch;

    public RSegmentTree(RSTNode[] order, int visitsBeforeBranch, int numGuessFactorBins) {
        this.visitsBeforeBranch = visitsBeforeBranch;
        this.nodeOrder = order;
        double[] seed = new double[numGuessFactorBins];
        this.rootNode = this.nodeOrder[0].newInstance(seed, 0, this);
    }

    public RSTNode getSegmentForState(RRobotState state) {
        return this.rootNode.getSegmentForState(state);
    }

    public RSTNode getTemplateNodeForDepth(int depth) {
        if (depth >= this.nodeOrder.length) {
            return new RSTNode(null, 0);
        }
        return this.nodeOrder[depth];
    }

    public int getVisitsBeforeBranch() {
        return this.visitsBeforeBranch;
    }

    public int getMaxBranchCount() {
        int count = this.nodeOrder[0].getSegmentSize();
        int i = 1;
        while (i < this.nodeOrder.length) {
            count *= this.nodeOrder[i].getSegmentSize();
            ++i;
        }
        return count;
    }

    public int getBranchCount() {
        return this.rootNode.getBranchCount();
    }

    public int getTerminalBranchCount() {
        return this.rootNode.getTerminalBranchCount(this.nodeOrder.length);
    }

    public String toString() {
        String str = "RSegmentTree:\n";
        str = String.valueOf(str) + this.nodeOrder.length + " unique branch types\n";
        str = String.valueOf(str) + "Generated " + this.getBranchCount() + " of " + this.getMaxBranchCount() + " possible branches\n";
        str = String.valueOf(str) + this.getTerminalBranchCount() + " terminal branches\n\n";
        return str;
    }
}

