/*
 * Decompiled with CFR 0.152.
 */
package vuen.fractal.gun;

import vuen.fractal.data.Memory;
import vuen.fractal.data.Packet;
import vuen.fractal.gun.WaveGL;
import vuen.fractal.util.BotMath;

public class Wave {
    private Packet source;
    private Packet target;
    private int targetid;
    private double speed;
    private int time;
    public int[] bins;
    private boolean gl;
    Memory memory;
    WaveGL wavegl;

    public Packet getSource() {
        return this.source;
    }

    public Packet getTarget() {
        return this.target;
    }

    public int getTargetId() {
        return this.targetid;
    }

    public int getTime() {
        return this.time;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void destroy() {
        if (this.gl) {
            this.wavegl.destroy();
            this.wavegl = null;
        }
        this.memory = null;
    }

    public boolean wasEnemyStopped() {
        return Math.abs(this.target.velocity) < 1.0;
    }

    public boolean isUsable() {
        return this.source != null && this.target != null;
    }

    public boolean isValid() {
        Packet targetnow = this.memory.getPacket(this.targetid);
        if (targetnow == null) {
            return false;
        }
        return !(targetnow.energy < 0.001);
    }

    public Wave(int source, int target, double speed, long time, int[] bins, Memory memory, boolean gl, Object renderer) {
        this.source = memory.getPacket(source);
        this.target = memory.getPacket(target);
        this.targetid = target;
        this.speed = speed;
        this.time = (int)time;
        this.bins = bins;
        this.gl = gl;
        this.memory = memory;
        if (gl) {
            this.wavegl = new WaveGL(renderer, this);
        }
    }

    public double getAngle() {
        Packet targetnow = this.memory.getPacket(this.targetid);
        double angle = Math.toDegrees(BotMath.normalRelativeAngleRadians(Math.atan2(targetnow.x - this.source.x, targetnow.y - this.source.y) - Math.atan2(this.target.x - this.source.x, this.target.y - this.source.y)));
        double newheading = this.target.heading + 90.0 * (BotMath.sign(this.target.velocity) - 1.0);
        double origin = BotMath.anglePoints(this.target.x, this.target.y, this.source.x, this.source.y);
        double sign = BotMath.sign(BotMath.normalRelativeAngle(newheading - origin));
        return angle *= sign;
    }

    public double getSize() {
        return this.speed * (double)(this.memory.getTime() - this.time);
    }

    public boolean isWaveDone() {
        Packet targetnow = this.memory.getPacket(this.targetid);
        if (targetnow == null) {
            return false;
        }
        return this.speed * (double)(this.memory.getTime() - this.time) > BotMath.distancePoints(this.source.x, this.source.y, targetnow.x, targetnow.y) - 20.0;
    }
}

