/*
 * Decompiled with CFR 0.152.
 */
package krillr.mega.utils;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import krillr.mega.utils.DebugShape;
import krillr.mega.utils.Point2d;
import krillr.mega.utils.UnitInfo;
import krillr.mega.utils.UnitTracker;
import krillr.mega.utils.Vector2d;

public class VirtualBullet {
    public Point2d location;
    public Point2d previousLocation;
    public Vector2d vector;
    public UnitTracker targetUnit;
    public Rectangle2D fieldRect;

    public VirtualBullet(Point2d l, Vector2d v, UnitTracker target) {
        this.location = l;
        this.vector = v;
        this.targetUnit = target;
        this.fieldRect = new Rectangle2D.Double(0.0, 0.0, target.bot.getBattleFieldWidth(), target.bot.getBattleFieldHeight());
    }

    public void progress() {
        this.previousLocation = new Point2d(this.location);
        this.location = this.location.applyVector(this.vector);
    }

    public boolean hasHit() {
        UnitInfo previousInfo = this.targetUnit.previousInfo();
        if (previousInfo == null) {
            return false;
        }
        Rectangle2D.Double bulletPosition = new Rectangle2D.Double(this.location.x, this.location.y, 2.0, 2.0);
        Rectangle2D.Double enemyPosition = new Rectangle2D.Double(this.targetUnit.info().location.x - 18.0, this.targetUnit.info().location.y - 18.0, 36.0, 36.0);
        this.targetUnit.bot.shapeList.add(new DebugShape(bulletPosition, new Color(255, 0, 0)));
        this.targetUnit.bot.shapeList.add(new DebugShape(enemyPosition, new Color(0, 255, 0)));
        return enemyPosition.contains(bulletPosition);
    }

    public boolean hasMissed() {
        return !this.fieldRect.contains(this.location);
    }
}

