/*
 * Decompiled with CFR 0.152.
 */
package pulsar.gf;

import java.awt.geom.Point2D;
import pulsar.PulsarMax;
import pulsar.gf.Segmentation;
import pulsar.util.RobotData;
import pulsar.util.Util;

public class WallSegmentation
extends Segmentation {
    private int segments = 3;
    private double direction = 1.0;

    public WallSegmentation(int segments) {
        this(segments, 1.0);
    }

    public WallSegmentation(int segments, double direction) {
        this.segments = segments;
        this.direction = direction;
    }

    public int getNoSegments() {
        return this.segments;
    }

    public int getIndex(RobotData firedFrom, RobotData firedAt, int stepsBack) {
        if (firedAt == null) {
            return 0;
        }
        double distance = firedFrom.getDistanceTo(firedAt, stepsBack) - (double)18;
        int flightTime = Math.max(0, (int)(distance / Util.getBulletSpeed(firedFrom.lastFirePower)));
        double firedAtX = firedAt.getValue(firedAt.x, stepsBack);
        double firedAtY = firedAt.getValue(firedAt.y, stepsBack);
        double firedAtHeading = firedAt.getValue(firedAt.heading, stepsBack);
        double firedAtVelocity = (double)8 * Util.sign(firedAt.getValue(firedAt.velocity, stepsBack)) * this.direction;
        double mod = 1.0;
        if (this.segments == 2) {
            mod = 0.8;
        }
        int i = 1;
        while (i < this.segments) {
            Point2D.Double loc = Util.linearPredict(firedAtX, firedAtY, firedAtHeading, firedAtVelocity, (int)((double)flightTime * mod * (double)i / (double)(this.segments - 1)));
            if (!PulsarMax.fieldWithMargin.contains(loc)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected double getValue(RobotData firedFrom, RobotData firedAt, int stepsBack) {
        throw new UnsupportedOperationException("getValue of " + this.getClass() + " should not be used.");
    }
}

