/*
 * Decompiled with CFR 0.152.
 */
package pulsar.movement;

import apv.MovSim;
import apv.MovSimStat;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pulsar.PulsarMax;
import pulsar.movement.AbstractMovement;
import pulsar.util.RobotData;
import pulsar.util.Util;
import pulsar.util.Wave;
import robocode.AdvancedRobot;

public class MaxDistanceMovement
extends AbstractMovement {
    private static final String NAME = "Max Distance Movement";
    private double goalDirection;
    private static int PREDICT_STEPS = 10;

    public String getName() {
        return NAME;
    }

    public double getScore(AdvancedRobot robot, RobotData target, Map radar, Map wavesMap) {
        if (robot.getOthers() > 1) {
            return 70.0;
        }
        return 30.0;
    }

    public void doMovement(AdvancedRobot robot, RobotData currentTarget, Map radar, Map wavesMap) {
        AbstractMovement.Move bestMove = new AbstractMovement.Move();
        double bestVal = Double.MAX_VALUE;
        double bWidth = PulsarMax.field.getWidth();
        double bHeight = PulsarMax.field.getHeight();
        int i = 1;
        while (i <= 8) {
            double goalDirection = Math.PI * 2 / (double)i;
            AbstractMovement.Move move = this.setMovement(robot, (double)8, goalDirection, currentTarget, true);
            MovSimStat[] pos = MovSim.futurePos(PREDICT_STEPS, robot.getX(), robot.getY(), robot.getVelocity(), move.maxVelocity, robot.getHeadingRadians(), move.ahead, move.turn, MovSim.defaultMaxTurnRate, bWidth, bHeight);
            double tmpVal = this.evalLoc(robot, pos[PREDICT_STEPS - 1], radar, wavesMap);
            if (tmpVal < bestVal) {
                bestVal = tmpVal;
                bestMove = move;
            }
            ++i;
        }
        AbstractMovement.executeMove(bestMove, robot);
        this.removeOldWaves(robot, radar, wavesMap);
    }

    private int getLiveTargets(Map radar) {
        int result = 0;
        Iterator iter = radar.values().iterator();
        while (iter.hasNext()) {
            if (!((RobotData)iter.next()).isAlive) continue;
            ++result;
        }
        return result;
    }

    private double evalLoc(AdvancedRobot robot, MovSimStat pos, Map radar, Map wavesMap) {
        double danger;
        double dist;
        double val = 0.0;
        RobotData target = null;
        long robotTime = robot.getTime();
        int closeTargets = MaxDistanceMovement.closeTargets(200, radar);
        if (closeTargets < 2 && robot.getOthers() > 2) {
            dist = Point2D.distance(PulsarMax.field.getWidth() / (double)2, PulsarMax.field.getHeight() / (double)2, pos.x, pos.y);
            danger = robotTime < (long)100 ? 500 : 200;
            val += danger / Math.pow(dist, 2);
        }
        Iterator iter = radar.values().iterator();
        danger = 0.0;
        while (iter.hasNext()) {
            List waves;
            target = (RobotData)iter.next();
            if (!target.isAlive) continue;
            MovSimStat[] targetMoves = target.predictMovement(PREDICT_STEPS);
            dist = Point2D.distance(targetMoves[MaxDistanceMovement.PREDICT_STEPS - 1].x, targetMoves[MaxDistanceMovement.PREDICT_STEPS - 1].y, pos.x, pos.y);
            danger = target.name.indexOf("sample.") >= 0 ? (danger += (double)20) : (MaxDistanceMovement.isClosestForTarget(target, radar) ? (danger += (double)200) : (danger += (double)100));
            val += danger / Math.pow(dist, 2);
            if (closeTargets >= 3 || (waves = (List)wavesMap.get(target.name)) == null) continue;
            Iterator wavesIter = waves.iterator();
            while (wavesIter.hasNext()) {
                boolean old;
                Wave wave = (Wave)wavesIter.next();
                double distLeft = wave.origin.distance(pos.x, pos.y) - Util.getBulletSpeed(wave.firePower) * (double)(robotTime + (long)PREDICT_STEPS - wave.time);
                int timeLeft = (int)(distLeft / Util.getBulletSpeed(wave.firePower));
                boolean bl = old = robot.getRoundNum() != target.dataFromRound || wave.time > robotTime + (long)100;
                if (timeLeft < -(PREDICT_STEPS + 1) || old) continue;
                Line2D.Double bulletLine = new Line2D.Double(wave.origin.getX(), wave.origin.getY(), wave.locAtFireTime.getX(), wave.locAtFireTime.getY());
                double bulletDist = bulletLine.ptLineDist(pos.x, pos.y);
                val += (double)100 / Math.pow((double)Math.max((timeLeft + PREDICT_STEPS) * 15, 0) + (double)10 * bulletDist, 2);
                if (target.name.indexOf("sample.") >= 0) continue;
                bulletLine = new Line2D.Double(wave.origin.getX(), wave.origin.getY(), wave.linearImpact.getX(), wave.linearImpact.getY());
                bulletDist = bulletLine.ptLineDist(pos.x, pos.y);
                val += (double)100 / Math.pow((double)Math.max((timeLeft + PREDICT_STEPS) * 15, 0) + (double)10 * bulletDist, 2);
            }
        }
        return val;
    }

    private void removeOldWaves(AdvancedRobot robot, Map radar, Map wavesMap) {
        Iterator iter = radar.values().iterator();
        while (iter.hasNext()) {
            RobotData target = (RobotData)iter.next();
            List waves = (List)wavesMap.get(target.name);
            if (waves == null) continue;
            if (!target.isAlive) {
                waves.clear();
                continue;
            }
            Iterator wavesIter = waves.iterator();
            while (wavesIter.hasNext()) {
                boolean old;
                Wave wave = (Wave)wavesIter.next();
                double distLeft = wave.origin.distance(robot.getX(), robot.getY()) - Util.getBulletSpeed(wave.firePower) * (double)(robot.getTime() - wave.time);
                boolean bl = old = robot.getRoundNum() != target.dataFromRound || wave.time > robot.getTime() + (long)100;
                if (distLeft >= (double)-18 && !old) continue;
                wavesIter.remove();
                if (wave.virtual) continue;
                wave.removeBulletGraphics();
            }
        }
    }

    private static boolean isClosestForTarget(RobotData target, Map radar) {
        double distance = PulsarMax.robotStats.getDistanceTo(target, 0) * 0.9;
        Iterator iter = radar.values().iterator();
        while (iter.hasNext()) {
            RobotData otherTarget = (RobotData)iter.next();
            if (!otherTarget.isAlive || otherTarget.name.equals(target.name) || !(target.getDistanceTo(otherTarget, 0) < distance)) continue;
            return false;
        }
        return true;
    }

    private static int closeTargets(double distance, Map radar) {
        int n = 0;
        Iterator iter = radar.values().iterator();
        while (iter.hasNext()) {
            RobotData target = (RobotData)iter.next();
            if (!target.isAlive || !(target.getDistanceTo(PulsarMax.robotStats, 0) < distance)) continue;
            ++n;
        }
        return n;
    }
}

