/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.debug.Debuggable;
import pedersen.debug.DebuggableBase;
import pedersen.physics.Snapshot;
import pedersen.physics.Vehicle;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnRound;

public interface Competitor
extends Debuggable,
OnRound {
    public void update(Snapshot var1);

    public Vehicle getChassis();

    public boolean isSnapshotValid();

    public Snapshot getSnapshot();

    public Snapshot getHistoricalSnapshot(long var1);

    public static abstract class CompetitorBase
    extends DebuggableBase
    implements Competitor {
        private Snapshot present = null;
        public static long counter = 0L;

        protected CompetitorBase() {
            ++counter;
            NotificationSubsystem.getInstance().subscribeOnRound(this);
        }

        @Override
        public void update(Snapshot snapshot) {
            if (snapshot != null && (this.present == null || this.present.getTime() < snapshot.getTime())) {
                if (this.present != null) {
                    snapshot.setPrevious(this.present);
                }
                this.present = snapshot;
            }
        }

        @Override
        public Vehicle getChassis() {
            return this.present.getVehicle();
        }

        @Override
        public Snapshot getSnapshot() {
            return this.present;
        }

        @Override
        public Snapshot getHistoricalSnapshot(long index) {
            Snapshot snapshot = this.present;
            long i = 0L;
            while (i < index && snapshot != null) {
                snapshot = snapshot.getPrevious();
                ++i;
            }
            return snapshot;
        }

        @Override
        public boolean isSnapshotValid() {
            return this.present != null;
        }

        @Override
        public void onRound(int round) {
            if (this.present != null) {
                this.present.breakLinks();
                this.present = null;
            }
        }
    }
}

