/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import pedersen.core.GameState;
import pedersen.divination.WaveOutboundImpl;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.Vehicle;
import pedersen.physics.VelocityVector;
import pedersen.util.Constraints;

public class Instructions {
    private static Instructions singleton = new Instructions();
    private boolean shotFired = false;
    private double chassisHeadingChange = 0.0;
    private double turretHeadingChange = 0.0;
    private double scannerHeadingChange = 0.0;
    private WaveOutboundImpl outboundWave = null;
    private double desiredVelocity = 0.0;
    private Vehicle chassisFuturePosition = null;

    private Instructions() {
    }

    public static Instructions getInstance() {
        return singleton;
    }

    public void refresh() {
        this.shotFired = false;
        this.chassisHeadingChange = 0.0;
        this.turretHeadingChange = 0.0;
        this.scannerHeadingChange = 0.0;
    }

    public WaveOutboundImpl getOutboundWave() {
        return this.outboundWave;
    }

    public void setOutboundWave(WaveOutboundImpl outboundWave) {
        this.outboundWave = outboundWave;
    }

    public boolean isShotFired() {
        return this.shotFired;
    }

    public void setTurretDirectionChange(HasDirection targetHeading) {
        Direction turretHeading = GameState.getInstance().getTurretHeading().addRadians(this.chassisHeadingChange);
        this.turretHeadingChange = Constraints.limitTurretRotation(turretHeading.getRelativeDirection(targetHeading).getRelativeRadians());
    }

    public void setScannerDirectionChange(HasDirection targetHeading) {
        Direction scannerHeading = GameState.getInstance().getScannerHeading().addRadians(this.chassisHeadingChange + this.turretHeadingChange);
        this.scannerHeadingChange = Constraints.limitScannerRotation(scannerHeading.getRelativeDirection(targetHeading).getRelativeRadians());
    }

    public void setMovementVector(VelocityVector movementVector) {
        GameState state = GameState.getInstance();
        if (!state.isDisabled()) {
            this.chassisFuturePosition = state.getChassis().getQualifiedFuturePosition(movementVector);
            this.chassisHeadingChange = state.getChassis().getDirection().getRelativeDirection(this.chassisFuturePosition).getRelativeRadians();
            this.desiredVelocity = this.chassisFuturePosition.getVelocity().velocity();
        } else {
            this.chassisFuturePosition = state.getChassis().getVehicle();
            this.chassisHeadingChange = 0.0;
            this.desiredVelocity = 0.0;
        }
    }

    public double getChassisHeadingChange() {
        return this.chassisHeadingChange;
    }

    public double getTurretHeadingChange() {
        return this.turretHeadingChange;
    }

    public double getScannerHeadingChange() {
        return this.scannerHeadingChange;
    }

    public double getDesiredVelocity() {
        return this.desiredVelocity;
    }

    public void fireGun(WaveOutboundImpl wave) {
        this.shotFired = true;
        this.outboundWave = wave;
    }

    public Vehicle getChassisFuturePosition() {
        return this.chassisFuturePosition;
    }
}

