/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import pedersen.debug.DebuggableBase;
import pedersen.physics.HasCircle;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.physics.constant.PositionImpl;
import pedersen.util.GeometryAdapter;

public class SlopeFormula
extends DebuggableBase {
    private final double slope;
    private final double offset;

    public SlopeFormula(HasPosition position, HasDirection heading) {
        this(position, position.getPosition().addVector(heading, PhysicsConstants.arbitraryDistance));
    }

    public SlopeFormula(HasPosition position, HasPosition position2) {
        double deltaX = position2.getPosition().getX() - position.getPosition().getX();
        double deltaY = position2.getPosition().getY() - position.getPosition().getY();
        if (deltaX == 0.0) {
            this.slope = Double.POSITIVE_INFINITY;
            this.offset = position.getPosition().getX();
        } else {
            this.slope = deltaY / deltaX;
            this.offset = position.getPosition().getY() - this.slope * position.getPosition().getX();
        }
    }

    public double getFunctionOfX(double x) {
        if (!Double.isInfinite(this.slope)) {
            return this.slope * x + this.offset;
        }
        if (x == this.offset) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    public double getFunctionOfY(double y) {
        if (Double.isInfinite(this.slope)) {
            return this.offset;
        }
        if (this.slope != 0.0) {
            return y - this.offset / this.slope;
        }
        if (y == this.offset) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.NaN;
    }

    public Position getPositionForX(double x) {
        return new PositionImpl(x, this.getFunctionOfX(x));
    }

    public Position getPositionForY(double y) {
        return new PositionImpl(this.getFunctionOfY(y), y);
    }

    public Position getPointOfIntercept(SlopeFormula other) {
        if (this.slope != other.slope) {
            if (Double.isInfinite(this.slope)) {
                return other.getPositionForX(this.offset);
            }
            if (Double.isInfinite(other.slope)) {
                return this.getPositionForX(other.offset);
            }
            return this.getPositionForX((other.offset - this.offset) / (this.slope - other.slope));
        }
        return null;
    }

    public Set<Point2D.Double> getPointsOfIntersection(HasCircle c) {
        HashSet<Point2D.Double> set = new HashSet<Point2D.Double>();
        if (Double.isInfinite(this.slope)) {
            for (double y : c.getCircle().getFunctionOfX(this.offset)) {
                set.add(new Point2D.Double(this.offset, y));
            }
        } else {
            double r = c.getCircle().getRadius().radius();
            double h = c.getCircle().getPosition().getX();
            double k = c.getCircle().getPosition().getY();
            double m = this.slope;
            double b = this.offset;
            double qa = m * m + 1.0;
            double qb = 2.0 * m * b - 2.0 * m * k - 2.0 * h;
            double qc = h * h + b * b + k * k - r * r - 2.0 * b * k;
            for (double x : GeometryAdapter.quadraticEquation(qa, qb, qc)) {
                set.add(new Point2D.Double(x, this.getFunctionOfX(x)));
            }
        }
        return set;
    }

    @Override
    public String description() {
        return Double.isInfinite(this.slope) ? "Infinite slope, x = " + this.offset : "Slope: y = " + super.trim(this.slope) + "x + " + super.trim(this.offset);
    }
}

