/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import java.awt.geom.Point2D;
import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.Distance;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.HasMagnitude;
import pedersen.physics.HasPosition;
import pedersen.physics.HasVector;
import pedersen.physics.Position;
import pedersen.physics.constant.DirectionImpl;
import pedersen.physics.constant.DistanceImpl;
import pedersen.physics.constant.DistanceVectorImpl;
import pedersen.physics.constant.PhysicsConstants;
import pedersen.util.Constraints;
import pedersen.util.Conversions;

public class PositionImpl
extends DebuggableBase
implements Position {
    private final Point2D.Double position;

    public PositionImpl(Point2D.Double other) {
        this.position = other;
    }

    public PositionImpl(HasPosition other) {
        this(other.getPosition().getPoint2D());
    }

    public PositionImpl(double x, double y) {
        this(new Point2D.Double(x, y));
    }

    @Override
    public Position getPosition() {
        return this;
    }

    @Override
    public double getX() {
        return this.position.x;
    }

    @Override
    public double getY() {
        return this.position.y;
    }

    @Override
    public Point2D.Double getPoint2D() {
        return this.position;
    }

    @Override
    public Direction getBearing(HasPosition other) {
        double deltaX = other.getPosition().getX() - this.getX();
        double deltaY = other.getPosition().getY() - this.getY();
        Direction bearing = deltaY == 0.0 ? (deltaX < 0.0 ? PhysicsConstants.west : PhysicsConstants.east) : (deltaY < 0.0 ? PhysicsConstants.halfCircle.addRadians(Math.atan(deltaX / deltaY)) : new DirectionImpl(Math.atan(deltaX / deltaY)));
        return bearing;
    }

    @Override
    public Distance getDistance(HasPosition other) {
        Position relativePosition = this.getRelativePosition(other);
        return new DistanceImpl(Conversions.getHypoteneuse(relativePosition.getX(), relativePosition.getY()));
    }

    @Override
    public Position getRelativePosition(HasPosition other) {
        if (other == null) {
            return PhysicsConstants.anchorPosition;
        }
        return new PositionImpl(other.getPosition().getX() - this.getX(), other.getPosition().getY() - this.getY());
    }

    @Override
    public DistanceVector getRelativeDistanceVector(HasPosition other, HasDirection relativeDirection) {
        return this.equalsPosition(other) ? new DistanceVectorImpl(relativeDirection, PhysicsConstants.zeroDistance) : new DistanceVectorImpl((HasDirection)this.getBearing(other), this.getDistance(other));
    }

    @Override
    public boolean equalsPosition(HasPosition other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return Constraints.areEqual(this.position.x, other.getPosition().getX()) && Constraints.areEqual(this.position.y, other.getPosition().getY());
    }

    @Override
    public String description() {
        return "( " + super.trim(this.getX()) + ", " + super.trim(this.getY()) + " )";
    }

    @Override
    public Position addVector(double h, double v) {
        return new PositionImpl(this.position.x + PositionImpl.calculateDeltaX(h, v), this.position.y + PositionImpl.calculateDeltaY(h, v));
    }

    @Override
    public Position addVector(HasVector vector) {
        return this.addVector(vector.getVector().getDirection().getAbsoluteRadians(), vector.getVector().getMagnitude().magnitude());
    }

    @Override
    public Position addVector(HasDirection direction, double v) {
        return this.addVector(direction.getDirection().getAbsoluteRadians(), v);
    }

    @Override
    public Position addVector(HasDirection direction, HasMagnitude magnitude) {
        return this.addVector(direction.getDirection().getAbsoluteRadians(), magnitude.getMagnitude().magnitude());
    }

    private static double calculateDeltaX(double angle, double length) {
        return Math.sin(angle) * length;
    }

    private static double calculateDeltaY(double angle, double length) {
        return Math.cos(angle) * length;
    }
}

