/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.HasVehicle;
import pedersen.physics.HasVelocity;
import pedersen.physics.HasVelocityVector;
import pedersen.physics.Magnitude;
import pedersen.physics.Position;
import pedersen.physics.SlopeFormula;
import pedersen.physics.Vector;
import pedersen.physics.Vehicle;
import pedersen.physics.Velocity;
import pedersen.physics.VelocityVector;
import pedersen.physics.constant.DirectionImpl;
import pedersen.physics.constant.PositionImpl;
import pedersen.physics.constant.VelocityVectorImpl;
import pedersen.util.Constraints;
import pedersen.util.Conversions;

public class VehicleImpl
extends DebuggableBase
implements Vehicle {
    private final Position position;
    private final VelocityVector velocityVector;

    public VehicleImpl(HasPosition position, HasVelocityVector velocityVector) {
        this.position = position.getPosition();
        this.velocityVector = velocityVector.getVelocityVector();
    }

    public VehicleImpl(HasPosition position, HasDirection direction, HasVelocity velocity) {
        this(position, new VelocityVectorImpl(direction, velocity));
    }

    public VehicleImpl(HasPosition position, HasDirection direction, double velocity) {
        this(position, new VelocityVectorImpl(direction, velocity));
    }

    public VehicleImpl(HasPosition position, double direction, double velocity) {
        this(position, new VelocityVectorImpl(direction, velocity));
    }

    public VehicleImpl(double x, double y, double direction, double velocity) {
        this(new PositionImpl(x, y), new VelocityVectorImpl(direction, velocity));
    }

    public VehicleImpl(HasVehicle other) {
        this(other.getVehicle().getPosition(), other.getVehicle().getVelocityVector());
    }

    @Override
    public boolean equalsVehicle(HasVehicle other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.position.equalsPosition(other.getVehicle().getPosition()) && this.velocityVector.equalsVelocityVector(other.getVehicle().getVelocityVector());
    }

    @Override
    public Vehicle getVehicle() {
        return this;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public VelocityVector getVelocityVector() {
        return this.velocityVector;
    }

    @Override
    public Vector getVector() {
        return this.getVelocityVector();
    }

    @Override
    public Direction getDirection() {
        return this.velocityVector.getDirection();
    }

    @Override
    public Velocity getVelocity() {
        return this.velocityVector.getVelocity();
    }

    public Magnitude getMagnitude() {
        return this.velocityVector.getMagnitude();
    }

    @Override
    public Direction getRelativeBearing(HasPosition other) {
        return this.getDirection().getRelativeDirection(this.position.getBearing(other));
    }

    @Override
    public SlopeFormula getTangentSlope() {
        double backupDistance = -0.5 * this.getVelocity().velocity();
        Direction tangent = this.getDirection().getTangentAngle();
        Position stepA = this.position.addVector((HasDirection)this, backupDistance);
        Position stepB = stepA.getPosition().addVector((HasDirection)tangent, 1.0);
        return new SlopeFormula((HasPosition)stepA, stepB);
    }

    @Override
    public Position getTurnCenter(HasPosition referece, double radius) {
        double halfVelocity = 0.5 * this.getVelocity().velocity();
        double apothem = VehicleImpl.getApothem(radius, halfVelocity);
        Position p0 = this.position.addVector((HasDirection)this, -halfVelocity);
        Direction tangent = p0.getBearing(referece);
        Position turnCenter = p0.addVector((HasDirection)tangent, apothem);
        return turnCenter;
    }

    @Override
    public Position getMinimumTurnCircleCenter(boolean clockwise) {
        Position c = this.getPosition();
        if (this.getVelocity().velocity() != 0.0) {
            double halfSpeed = 0.5 * this.getVelocity().velocity();
            double halfTurnRate = 0.5 * Conversions.getAbsMaxTurnRateFromVelocity(this.getVelocity().velocity());
            c = this.getPosition().addVector((HasDirection)this, -halfSpeed).addVector((HasDirection)(clockwise ? this.getDirection().getTangentAngle() : this.getDirection().getTangentAngle().getOpposedAngle()), Math.abs(halfSpeed) / Math.tan(halfTurnRate));
        }
        return c;
    }

    private static double getApothem(double r, double b) {
        return Math.sqrt(r * r - b * b);
    }

    @Override
    public Vehicle addVelocityVector(HasVelocityVector velocityVector) {
        return new VehicleImpl(this.position.addVector(velocityVector), this.velocityVector);
    }

    @Override
    public Vehicle getQualifiedFuturePosition(HasVelocityVector movementVector) {
        double desiredHeading = movementVector.getVelocityVector().getDirection().getAbsoluteRadians();
        double desiredVelocity = movementVector.getVelocity().velocity();
        if (Constraints.isRelativeBearingToRear(this.getDirection().getRelativeDirection(movementVector.getVelocityVector().getDirection()).getRelativeRadians())) {
            desiredHeading += Math.PI;
            desiredVelocity = -desiredVelocity;
        }
        double turnRate = Conversions.getAbsMaxTurnRateFromVelocity(this).getAbsoluteRadians();
        double headingChange = Constraints.limitValue(-turnRate, new DirectionImpl(desiredHeading - this.getDirection().getAbsoluteRadians()).getRelativeRadians(), turnRate);
        double velocity = this.getVelocity().velocity();
        velocity = velocity == 0.0 ? Constraints.limitValue(-1.0, desiredVelocity, 1.0) : (velocity > 0.0 ? Constraints.limitValue(velocity - 2.0, desiredVelocity, velocity + 1.0) : Constraints.limitValue(velocity - 1.0, desiredVelocity, velocity + 2.0));
        velocity = Constraints.limitChassisVelocity(velocity);
        VelocityVectorImpl futureVelocityVector = new VelocityVectorImpl((HasDirection)this.getDirection().addRadians(headingChange), velocity);
        Position futurePosition = this.addVelocityVector(futureVelocityVector).getPosition();
        VehicleImpl futureChassis = new VehicleImpl(futurePosition, futureVelocityVector);
        return futureChassis;
    }

    @Override
    public String description() {
        return "( " + super.trim(this.getPosition().getX()) + ", " + super.trim(this.getPosition().getY()) + " )( " + super.trim(this.getDirection().getAbsoluteRadians()) + ", " + super.trim(this.getVelocity().velocity()) + " )";
    }
}

