/*
 * Decompiled with CFR 0.152.
 */
package pedersen.systems;

import pedersen.core.Combatant;
import pedersen.core.GameState;
import pedersen.debug.Metrics;
import pedersen.divination.WaveOutboundImpl;
import pedersen.opponent.Target;
import pedersen.physics.Firepower;
import pedersen.physics.HasPosition;
import pedersen.physics.HasSnapshot;
import pedersen.physics.Snapshot;
import pedersen.physics.constant.FirepowerImpl;
import pedersen.systems.FireControlBase;
import pedersen.util.Constraints;
import pedersen.util.Conversions;

public class FireControlStandard
extends FireControlBase {
    private static final Firepower defaultFirepower = new FirepowerImpl(2.5);
    private static final Firepower conservativeFirepower = new FirepowerImpl(1.9);

    @Override
    public Firepower getFirepower(HasPosition _firingPosition, HasSnapshot _targetSnapshot) {
        Snapshot targetSnapshot = _targetSnapshot.getSnapshot();
        double killpower = Conversions.getFirepowerFromBulletDamage(targetSnapshot.getEnergy().energy() + 0.01);
        if (killpower < 0.1) {
            if (this.debug) {
                this.consoleTick("killpower < Rules.MIN_BULLET_POWER");
            }
            return this.minFirepower;
        }
        if (killpower < 3.0) {
            if (this.debug) {
                this.consoleTick("killpower < Rules.MAX_BULLET_POWER");
            }
            return new FirepowerImpl(killpower);
        }
        double distance = _firingPosition.getPosition().getDistance(targetSnapshot).distance();
        if (distance < 75.0) {
            if (this.debug) {
                this.consoleTick("distance < 75.0");
            }
            return this.maxFirepower;
        }
        if (GameState.getInstance().getActiveEnemyCount() > 8) {
            if (this.debug) {
                this.consoleTick("ActiveEnemyCount() > 8");
            }
            return this.maxFirepower;
        }
        if (GameState.getInstance().isInDuelMode() && Metrics.getInstance().getFiredShotCount() < 10L) {
            if (this.debug) {
                this.consoleTick("isInDuelMode() && getFiredShotCount() < 10");
            }
            return this.minFirepower;
        }
        double energy = Combatant.getCombatant().getSnapshot().getEnergy().energy();
        if (energy < 5.0) {
            if (this.debug) {
                this.consoleTick("energy < 5.0");
            }
            return this.minFirepower;
        }
        if (energy < targetSnapshot.getEnergy().energy()) {
            if (this.debug) {
                this.consoleTick("energy < targetSnapshot.getEnergy().energy()");
            }
            return conservativeFirepower;
        }
        if (this.debug) {
            this.consoleTick("defaultFirepower");
        }
        return defaultFirepower;
    }

    @Override
    public boolean isFiringAdvisable(WaveOutboundImpl wave, Target target) {
        GameState state;
        double combatantEnergy0 = Combatant.getCombatant().getSnapshot().getEnergy().energy();
        double firepower = Conversions.getFirepowerFromBulletVelocity(wave.velocity());
        if (this.debug) {
            this.consoleTick("isFiringAdvisable firepower: " + firepower);
        }
        double combatantEnergy1 = combatantEnergy0 - firepower;
        double targetEnergy = target.getSnapshot().getEnergy().energy();
        if (combatantEnergy0 < 0.1 || combatantEnergy1 < 0.0) {
            if (this.debug) {
                this.consoleTick("combatantEnergy0 < Rules.MIN_BULLET_POWER || combatantEnergy1 < 0.0");
            }
            return false;
        }
        if (!Constraints.isInRange(0.1, firepower, 3.0)) {
            System.out.println("Firepower (" + firepower + ") as calculated from wave velocity (" + wave.velocity() + ") is outside the legal range.");
        }
        if ((state = GameState.getInstance()).isInDuelMode() && combatantEnergy0 != targetEnergy && Constraints.isInRange(combatantEnergy1, targetEnergy, combatantEnergy0)) {
            if (this.debug) {
                this.consoleTick("state.isInDuelMode() && combatantEnergy0 != targetEnergy && Constraints.isInRange( combatantEnergy1, targetEnergy, combatantEnergy0 )");
            }
            return false;
        }
        boolean positionReconciliation = wave.getPosition().equalsPosition(state);
        boolean turretReconciliation = wave.firingSolution.equalsDirection(state.getTurretHeading());
        if (!(state.isGunCool() && positionReconciliation && turretReconciliation)) {
            if (this.debug) {
                this.consoleTick("!state.isGunCool() || !positionReconciliation || !turretReconciliation");
            }
            return false;
        }
        return true;
    }
}

