/*
 * Decompiled with CFR 0.152.
 */
package apc;

import apc.movement.DesPoints;
import apc.movement.Dodge;
import apc.movement.MinimumRisk;
import apc.network.NeuralNet;
import apc.radar.Radar;
import apc.targeting.Circle;
import apc.targeting.Linear;
import apc.targeting.Pattern;
import apc.utils.EmData;
import apc.utils.EnemyManager;
import apc.utils.HelperMethods;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.GunTurnCompleteCondition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Caan
extends AdvancedRobot {
    MinimumRisk _movement;
    List<DesPoints> destinations;
    ArrayList<EmData> _enemies = new ArrayList();
    Point2D.Double _myLocation = new Point2D.Double(0.0, 0.0);
    EnemyManager _enemyManager = new EnemyManager();
    NeuralNet targetSolution = new NeuralNet(3, 6, 4);
    double[] inp = new double[]{0.0, 0.0, 0.0};
    double[] outp = new double[]{0.0, 0.0, 0.0, 0.0};
    boolean _1v1 = false;
    boolean reset = false;
    Linear _linearTargeting;
    Circle _circleTargeting;
    Pattern _patternTargeting = new Pattern();
    Dodge _dodge;
    Radar _radar;

    public void run() {
        this.readWeights();
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.initizes();
        System.out.println("Kerry57");
        while (true) {
            this.setTurnRadarRight(10.0);
            if (!this._1v1) {
                this.destinations = this._movement.move(this._enemies);
            }
            if (!this._1v1) {
                this._radar.execute();
            }
            this.execute();
        }
    }

    public void initizes() {
        Point2D.Double myLocation = new Point2D.Double(this.getX(), this.getY());
        this._movement = new MinimumRisk(this, this.getBattleFieldWidth(), this.getBattleFieldHeight(), myLocation);
        this._radar = new Radar(this);
        this._dodge = new Dodge(this);
        this._linearTargeting = new Linear(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        this._circleTargeting = new Circle(this.getBattleFieldWidth(), this.getBattleFieldHeight());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EmData bot;
        if (this._1v1) {
            this._dodge.onScannedRobot(e);
        }
        this._1v1 = this.getOthers() <= 1;
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double absoluteBearing2 = Utils.normalAbsoluteAngle((double)(e.getBearingRadians() + this.getHeadingRadians()));
        double theta = 0.0;
        double bulletPower = Math.min(3.0, this.getEnergy());
        Point2D.Double location = new Point2D.Double(this.getX() + e.getDistance() * Math.sin(absoluteBearing), this.getY() + e.getDistance() * Math.cos(absoluteBearing));
        this._myLocation = new Point2D.Double(this.getX(), this.getY());
        String targetingMethod = "";
        if (!this._enemies.isEmpty()) {
            bot = this._enemyManager.findEnemy(e.getName(), this._enemies);
        } else {
            bot = new EmData(e.getName());
            this._enemies.add(bot);
        }
        bot.updateBotData(e.getHeadingRadians(), e.getVelocity(), location, e.getDistance(), e.getBearingRadians(), this.getTime(), absoluteBearing2, e.getEnergy());
        EmData weakest = HelperMethods.findClosestEnemy(this._enemies);
        if (bot.name() != weakest.name() && !this._1v1) {
            return;
        }
        if (this.getEnergy() >= 50.0) {
            bulletPower = 3.0;
        } else if (this.getEnergy() > 20.0) {
            bulletPower = 1.0;
        } else {
            return;
        }
        this.inp[0] = this._enemies.size() > 1 ? 0.0 : 1.0;
        this.inp[1] = bot.changeInHeading() < 1.0E-5 ? 0.0 : 1.0;
        this.inp[2] = bot.scans() < 15.0 ? 0.0 : 1.0;
        if (this._1v1 && !this.reset) {
            bot.setScans();
            this.reset = true;
        }
        this.targetSolution.test(this.inp, this.outp);
        this.targetSolution.convertOutPuts(this.outp);
        if (this.outp[0] == 1.0) {
            theta = this._linearTargeting.targetBot(bot, this.getEnergy(), this.getX(), this.getY(), this.getHeadingRadians());
            targetingMethod = "linear";
        } else if (this.outp[1] == 1.0) {
            theta = this._circleTargeting.targetBot(this.getTime(), this.getGunHeadingRadians(), bulletPower, this._myLocation, bot, this.getHeadingRadians());
            targetingMethod = "circle";
        } else if (this.outp[2] == 1.0) {
            theta = this._patternTargeting.targetBot(bot, this.getHeadingRadians(), bulletPower);
            targetingMethod = "pattern";
        } else if (this.outp[3] == 1.0) {
            theta = 0.0;
        }
        if (this._1v1) {
            this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians())));
        }
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(theta - this.getGunHeadingRadians())));
        this.waitFor((Condition)new GunTurnCompleteCondition((AdvancedRobot)this));
        if (this.getGunHeat() == 0.0 && e.getDistance() < 800.0) {
            this.setFireBullet(bulletPower);
            System.out.println("targetingMethod = " + targetingMethod + "Name Bot " + bot.name());
            System.out.println("_1v1 = " + this._1v1);
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this._dodge.onHitByBullet(e);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        HelperMethods.removeEnemy(this._enemies, event.getName());
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
        this.writeWeights();
    }

    public void onWin(WinEvent e) {
        this.writeWeights();
    }

    public void HitWallEvent(double bearing) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onPaint(Graphics2D g) {
        try {
            g.setColor(new Color(255, 0, 0, 128));
            g.setColor(Color.blue);
            if (!this.destinations.isEmpty()) {
                for (DesPoints des : this.destinations) {
                    g.drawOval((int)des.location.x, (int)des.location.y, 5, 5);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void writeWeights() {
        PrintStream w = null;
        try {
            try {
                w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile("weights.dat")));
                w.println(this.targetSolution.getWeights("w1"));
                w.println(this.targetSolution.getWeights("w2"));
                if (w.checkError()) {
                    this.out.println("I could not write the weightst!");
                }
            }
            catch (IOException e) {
                e.printStackTrace(this.out);
                if (w != null) {
                    w.close();
                }
            }
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public void readWeights() {
        String w1 = "";
        String w2 = "";
        try {
            BufferedReader r = new BufferedReader(new FileReader(this.getDataFile("weights.dat")));
            w1 = r.readLine();
            w2 = r.readLine();
            this.targetSolution.enterWieghts(w1, w2);
        }
        catch (IOException e) {
            this.out.println("IOException trying to read: ");
        }
    }
}

