/*
 * Decompiled with CFR 0.152.
 */
package apc.movement;

import apc.movement.DesPoints;
import apc.utils.BotManager;
import apc.utils.EmData;
import apc.utils.HelperMethods;
import apc.utils.MyBotsState;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import robocode.AdvancedRobot;

public class MinimumRisk {
    private static final int NUM_GRENERATED_DISTINATIONS = 50;
    private static final double BOT_HALF_WIDTH = 18.0;
    private static final int RECENT_LOCATIONS_TO_STORE = 50;
    private static final double CURRENT_DESTINATION_BIAS = 0.8;
    private static final double HALF_PI = 1.5707963267948966;
    private AdvancedRobot _myBot;
    private BotManager _myBotMoveData = new BotManager();
    private DesPoints _currentDestination;
    private double _battleFieldWidth;
    private double _battleFieldHeight;
    Rectangle2D.Double _rectangle;

    public MinimumRisk(AdvancedRobot bot, double bfWidth, double bfHeight, Point2D.Double myLocation) {
        this._myBot = bot;
        this._battleFieldWidth = bfWidth;
        this._battleFieldHeight = bfHeight;
        this._currentDestination = new DesPoints(myLocation, Double.POSITIVE_INFINITY, 0.0);
        this._rectangle = new Rectangle2D.Double(18.0, 18.0, this._battleFieldWidth - 36.0, this._battleFieldHeight - 36.0);
    }

    public List<DesPoints> move(ArrayList<EmData> enemies) {
        if (enemies.isEmpty()) {
            return null;
        }
        Point2D.Double myLocation = new Point2D.Double(this._myBot.getX(), this._myBot.getY());
        EmData closestEnemy = HelperMethods.findClosestEnemy(enemies);
        List<DesPoints> destinations = this.generateDestinations(myLocation, enemies, closestEnemy);
        DesPoints nextDestination = this.getNextDestination(myLocation, destinations);
        double goAngle = HelperMethods.absoluteBearing(myLocation, nextDestination.location);
        HelperMethods.setBackAsFront(this._myBot, goAngle);
        this._currentDestination = nextDestination;
        return destinations;
    }

    private List<DesPoints> generateDestinations(Point2D.Double myLocation, Collection<EmData> enemies, EmData closestEnemy) {
        this._myBotMoveData.updateMoveData(this._myBot.getTime(), myLocation, this._myBot.getVelocity(), this._myBot.getHeadingRadians(), enemies);
        ArrayList<DesPoints> possibleDestinations = new ArrayList<DesPoints>();
        possibleDestinations.addAll(this.generateLocations(myLocation, enemies, closestEnemy));
        if (myLocation.distance(this._currentDestination.location) <= myLocation.distance(closestEnemy.location())) {
            this._currentDestination.goAngle = HelperMethods.absoluteBearing(myLocation, this._currentDestination.location);
            this._currentDestination.risk = 0.8 * this.evaluateRisk(enemies, this._currentDestination.location, this._currentDestination.goAngle);
            possibleDestinations.add(this._currentDestination);
        }
        return possibleDestinations;
    }

    private ArrayList<DesPoints> generateLocations(Point2D.Double myLocation, Collection<EmData> enemies, EmData closestEnemy) {
        ArrayList<DesPoints> destinations = new ArrayList<DesPoints>();
        double distanceToClosestBot = closestEnemy.distance();
        double movementStick = Math.min(100.0 + Math.random() * 100.0, distanceToClosestBot);
        double sliceSize = 0.12566370614359174;
        int x = 0;
        while (x < 50) {
            double angle = (double)x * sliceSize;
            Point2D.Double dest = HelperMethods.project(myLocation, angle, movementStick);
            dest.x = HelperMethods.limit(18.0, dest.x, this._battleFieldWidth - 18.0);
            dest.y = HelperMethods.limit(18.0, dest.y, this._battleFieldHeight - 18.0);
            destinations.add(new DesPoints(dest, this.evaluateRisk(enemies, dest, angle), angle));
            ++x;
        }
        return destinations;
    }

    private double evaluateRisk(Collection<EmData> enemies, Point2D.Double destination, double goAngle) {
        double risk = 0.0;
        for (EmData moveData : enemies) {
            double botRisk = 0.0;
            double distanceSq = destination.distanceSq(moveData.location());
            botRisk = HelperMethods.limit(0.25, moveData.energy() / this._myBot.getEnergy(), 4.0) * (1.0 + Math.abs(Math.cos(moveData.absoluteBearing() - goAngle))) / (distanceSq * (double)(this.botsCloser(enemies, moveData) + 1));
            risk += botRisk;
        }
        return risk;
    }

    private int botsCloser(Collection<EmData> enemies, EmData bot) {
        int closerBots = 0;
        for (EmData enemy : enemies) {
            if (!(enemy.distance() < bot.distance())) continue;
            ++closerBots;
        }
        return closerBots;
    }

    private DesPoints getNextDestination(Point2D.Double myLocation, List<DesPoints> destinations) {
        DesPoints nextDestination;
        MyBotsState currentState = new MyBotsState(myLocation, this._myBot.getHeadingRadians(), this._myBot.getVelocity(), this._myBot.getTime());
        do {
            nextDestination = this.safestDestination(myLocation, destinations);
            destinations.remove(nextDestination);
        } while (this.wouldHitWall(currentState, nextDestination));
        return nextDestination;
    }

    private DesPoints safestDestination(Point2D.Double myLocation, List<DesPoints> possibleDestinations) {
        double lowestRisk = Double.POSITIVE_INFINITY;
        DesPoints safest = null;
        for (DesPoints destination : possibleDestinations) {
            if (!(destination.risk < lowestRisk)) continue;
            lowestRisk = destination.risk;
            safest = destination;
        }
        if (safest == null) {
            safest = this._currentDestination;
        }
        return safest;
    }

    private boolean wouldHitWall(MyBotsState currentState, DesPoints d) {
        long ticksAhead = 15L;
        boolean hitWall = false;
        int x = 0;
        while ((long)x < ticksAhead && !hitWall) {
            currentState = MinimumRisk.nextLocation(currentState.location, currentState.velocity, HelperMethods.absoluteBearing(currentState.location, d.location), currentState.time + (long)x);
            if (!this._rectangle.contains(currentState.location)) {
                hitWall = true;
            }
            ++x;
        }
        return hitWall;
    }

    public static MyBotsState nextLocation(Point2D.Double botLocation, double velocity, double goAngle, long currentTime) {
        Point2D.Double newLocation = HelperMethods.project(botLocation, goAngle, velocity);
        Point2D.Double myNewLocation = new Point2D.Double(botLocation.x + Math.sin(goAngle) * 140.0, botLocation.y + Math.cos(goAngle) * 140.0);
        return new MyBotsState(myNewLocation, goAngle, velocity, currentTime + 1L);
    }
}

