/*
 * Decompiled with CFR 0.152.
 */
package de.erdega.robocode;

import de.erdega.robocode.base.AbstractGun;
import de.erdega.robocode.base.AnalyzedScannedRobotEvent;
import de.erdega.robocode.util.Vector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.util.Utils;

public class StatisticalGun
extends AbstractGun {
    private int _nextIndex = -1;
    private LinkedList<AnalyzedScannedRobotEvent> _snapshots = new LinkedList();
    private LinkedList<AnalyzedScannedRobotEvent> _snapshotsRealShot = new LinkedList();
    private static final int PI_HALF_SCALE = 20;
    private static final int PI_SCALE = 40;
    private static int[] _angleHits = new int[41];
    private static int[] _angleHitsReal;
    private static int[] _angleShots;
    private static int _virtualHitCount;
    private static int _virtualHitCountReal;
    private static int _countShot;
    private static int _maxAngleHit;
    private static int _maxAngleHitReal;
    private static int _maxAngleShot;
    private double _relativeGunAngle = 0.0;

    static {
        int i = 0;
        while (i < _angleHits.length) {
            StatisticalGun._angleHits[i] = 0;
            ++i;
        }
        StatisticalGun._angleHits[20] = 1;
        _angleHitsReal = new int[41];
        i = 0;
        while (i < _angleHitsReal.length) {
            StatisticalGun._angleHitsReal[i] = 0;
            ++i;
        }
        StatisticalGun._angleHitsReal[20] = 1;
        _angleShots = new int[41];
        i = 0;
        while (i < _angleShots.length) {
            StatisticalGun._angleShots[i] = 0;
            ++i;
        }
        StatisticalGun._angleShots[20] = 1;
        _virtualHitCount = 1;
        _virtualHitCountReal = 1;
        _countShot = 1;
        _maxAngleHit = 1;
        _maxAngleHitReal = 1;
        _maxAngleShot = 1;
    }

    public StatisticalGun(AdvancedRobot robot) {
        super(robot);
    }

    public void handleScannedRobotEvent(AnalyzedScannedRobotEvent event) {
        double bulletPower = this.calcBulletPower(event);
        if (event.getEvent().getEnergy() == 0.0) {
            this.getRobot().setTurnGunRightRadians(Utils.normalRelativeAngle((double)(event.getEnemyBearing().getPhi() - event.getRobotGunHeading())));
            this.getRobot().setFire(bulletPower);
        } else {
            int index;
            double diffAngle;
            Vector oldPosToCurrentBearing;
            double oldSign;
            long timeDiff;
            AnalyzedScannedRobotEvent oldEvent;
            double bulletSpeed = Rules.getBulletSpeed((double)bulletPower);
            this._snapshots.addLast(event);
            long time = event.getTime();
            double sign = Math.signum(event.getEnemyBearing().getAngle(event.getEnemyVelocity()));
            Iterator iter = this._snapshotsRealShot.iterator();
            while (iter.hasNext()) {
                oldEvent = (AnalyzedScannedRobotEvent)iter.next();
                timeDiff = time - oldEvent.getTime();
                if (oldEvent.getEnemyBearing().getLength() > bulletSpeed * (double)timeDiff) break;
                oldSign = -Math.signum(oldEvent.getEnemyBearing().getAngle(oldEvent.getEnemyVelocity()));
                oldPosToCurrentBearing = event.getEnemyPosition().sub(oldEvent.getRobotPosition());
                diffAngle = oldPosToCurrentBearing.getPhi() - oldEvent.getEnemyBearing().getPhi();
                diffAngle *= oldSign;
                diffAngle = Utils.normalRelativeAngle((double)diffAngle) + 1.5707963267948966;
                int n = index = Math.min(Math.max((int)Math.round(diffAngle * 40.0 / Math.PI), 0), 40);
                _angleHitsReal[n] = _angleHitsReal[n] + 1;
                _maxAngleHitReal = Math.max(_maxAngleHitReal, _angleHitsReal[index]);
                ++_virtualHitCountReal;
                iter.remove();
            }
            iter = this._snapshots.iterator();
            while (iter.hasNext()) {
                oldEvent = (AnalyzedScannedRobotEvent)iter.next();
                timeDiff = time - oldEvent.getTime();
                if (oldEvent.getEnemyBearing().getLength() > bulletSpeed * (double)timeDiff) break;
                oldSign = -Math.signum(oldEvent.getEnemyBearing().getAngle(oldEvent.getEnemyVelocity()));
                oldPosToCurrentBearing = event.getEnemyPosition().sub(oldEvent.getRobotPosition());
                diffAngle = oldPosToCurrentBearing.getPhi() - oldEvent.getEnemyBearing().getPhi();
                diffAngle *= oldSign;
                diffAngle = Utils.normalRelativeAngle((double)diffAngle) + 1.5707963267948966;
                int n = index = Math.min(Math.max((int)Math.round(diffAngle * 40.0 / Math.PI), 0), 40);
                _angleHits[n] = _angleHits[n] + 1;
                _maxAngleHit = Math.max(_maxAngleHit, _angleHits[index]);
                ++_virtualHitCount;
                iter.remove();
            }
            if (this._nextIndex < 0) {
                int[] reducedArray = new int[_angleHitsReal.length];
                int hitsCount = 0;
                int i = 0;
                while (i < reducedArray.length - 1) {
                    if (_angleHitsReal[i] > _maxAngleHitReal / 2) {
                        reducedArray[i] = (_angleHitsReal[i] - _maxAngleHitReal / 2) * 2;
                        hitsCount += reducedArray[i];
                    } else {
                        reducedArray[i] = 0;
                    }
                    ++i;
                }
                double rnd = Math.random() * (double)hitsCount;
                int sum = 0;
                this._nextIndex = 0;
                while (this._nextIndex < reducedArray.length - 1) {
                    if ((double)(sum += reducedArray[this._nextIndex]) > rnd) break;
                    ++this._nextIndex;
                }
                this._relativeGunAngle = (double)(-(this._nextIndex - 20)) * Math.PI / 40.0 * sign;
            }
            double gunTurn = event.getEnemyBearing().getPhi();
            gunTurn += this._relativeGunAngle;
            gunTurn -= this.getRobot().getGunHeadingRadians();
            gunTurn = Utils.normalRelativeAngle((double)gunTurn);
            this.getRobot().setTurnGunRightRadians(gunTurn);
            if (this.getRobot().getGunHeat() == 0.0) {
                ++_countShot;
                int n = this._nextIndex;
                _angleShots[n] = _angleShots[n] + 1;
                _maxAngleShot = Math.max(_maxAngleShot, _angleShots[this._nextIndex]);
                this._snapshotsRealShot.addLast(event);
                this.getRobot().setFire(bulletPower);
                this._nextIndex = -1;
            }
        }
    }

    private double calcBulletPower(AnalyzedScannedRobotEvent event) {
        double power = event.getRobotEnergy() / 2.0;
        return Math.min(3.0, Math.max(0.1, power));
    }

    public void onPaint(Graphics2D g) {
        int y2;
        int y1;
        int x2;
        int x1;
        double scaleX = (double)g.getClipBounds().width / ((double)_angleHitsReal.length - 1.0);
        double scaleY = (double)g.getClipBounds().height / 3.0 / (double)_maxAngleHitReal;
        g.setColor(Color.RED);
        int i = 1;
        while (i < _angleHitsReal.length) {
            x1 = (int)(scaleX * (double)(i - 1));
            x2 = (int)(scaleX * (double)i);
            y1 = (int)(scaleY * (double)_angleHitsReal[i - 1]) + 1;
            y2 = (int)(scaleY * (double)_angleHitsReal[i]) + 1;
            g.drawLine(x1, y1, x2, y2);
            ++i;
        }
        scaleX = (double)g.getClipBounds().width / ((double)_angleHits.length - 1.0);
        scaleY = (double)g.getClipBounds().height / 3.0 / (double)_maxAngleHit;
        g.setColor(Color.GREEN);
        i = 1;
        while (i < _angleHits.length) {
            x1 = (int)(scaleX * (double)(i - 1));
            x2 = (int)(scaleX * (double)i);
            y1 = (int)(scaleY * (double)_angleHits[i - 1]) + 1;
            y2 = (int)(scaleY * (double)_angleHits[i]) + 1;
            g.drawLine(x1, y1, x2, y2);
            ++i;
        }
        scaleX = (double)g.getClipBounds().width / ((double)_angleShots.length - 1.0);
        scaleY = (double)g.getClipBounds().height / 3.0 / (double)_maxAngleShot;
        g.setColor(Color.WHITE);
        i = 1;
        while (i < _angleShots.length) {
            x1 = (int)(scaleX * (double)(i - 1));
            x2 = (int)(scaleX * (double)i);
            y1 = (int)(scaleY * (double)_angleShots[i - 1]) + 1;
            y2 = (int)(scaleY * (double)_angleShots[i]) + 1;
            g.drawLine(x1, y1, x2, y2);
            ++i;
        }
    }
}

