/*
 * Decompiled with CFR 0.152.
 */
package divineomega;

import divineomega.FileManager;
import divineomega.GunManager;
import divineomega.GunWave;
import divineomega.JBulletShield;
import divineomega.MovementMode;
import divineomega.VirtualBullet;
import divineomega.Wave;
import divineomega.guns.Gun;
import divineomega.patternmatching.PatternMatchingManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.TeamRobot;
import robocode.WinEvent;
import robocode.util.Utils;

public class TrialBot
extends TeamRobot {
    private boolean forward = false;
    private boolean scanComplete = false;
    private HashMap<String, Double> opponentEnergy = new HashMap();
    private static HashMap<String, Double> oldEnemyHeading = new HashMap();
    static Rectangle2D enemyRectangle;
    public static Point2D enemyLocation;
    static double enemyHeading;
    static double enemyVelocity;
    private ArrayList<Wave> waves = new ArrayList();
    ArrayList<GunWave> gunWaves = new ArrayList();
    public static final double fullTurnRadians = Math.PI * 2;
    public static int gunAnglesSize;
    public static HashMap<String, double[]> gunAngles;
    private ArrayList<VirtualBullet> virtualBullets = new ArrayList();
    boolean oneVersusOne = false;
    private String currentEnemyName = "";
    public static Point2D myLocation;
    private Point2D goToDestination;
    private static double battleFieldHeight;
    private static double battleFieldWidth;
    private static String dataFileName;
    private HashMap<Point2D, Double> dangerGrid = new HashMap();
    private double dangerFadeRate = 3.0;
    private boolean initialScanInProgress;
    private double closestEnemyDistance = Double.MAX_VALUE;
    private boolean useMinimumBulletPower = false;
    private int onlyTargetLeaderCountDown;
    public static boolean bulletShieldActive;
    public static HashMap<String, Integer> bulletShieldFailureCount;
    private int bulletShieldFailureThreshold = 50;
    private JBulletShield bulletShield = null;
    public static boolean endGameBulletShieldOverride;

    static {
        gunAnglesSize = 171;
        gunAngles = new HashMap();
        bulletShieldActive = true;
        bulletShieldFailureCount = new HashMap();
        endGameBulletShieldOverride = false;
    }

    public void run() {
        this.bulletShield = new JBulletShield(this);
        dataFileName = String.valueOf(this.getName()) + ".zip";
        if (this.getRoundNum() == 0) {
            FileManager.quotaCheck(this.getDataQuotaAvailable(), this.getDataDirectory());
            FileManager.deleteUnnecessary(this.getDataFile(dataFileName), this.getDataDirectory());
            FileManager.load(this.getDataFile(dataFileName));
        }
        this.oneVersusOne = this.getOthers() == 1;
        battleFieldWidth = this.getBattleFieldWidth();
        battleFieldHeight = this.getBattleFieldHeight();
        int dangerGridSize = 50;
        int dangerGridWallMargin = 50;
        int x = 0;
        while ((double)x <= battleFieldWidth) {
            int y = 0;
            while ((double)y < battleFieldHeight) {
                if (y >= dangerGridWallMargin && !((double)y > battleFieldHeight - (double)dangerGridWallMargin) && x >= dangerGridWallMargin && !((double)x > battleFieldWidth - (double)dangerGridWallMargin)) {
                    this.dangerGrid.put(new Point(x, y), 0.0);
                }
                y += dangerGridSize;
            }
            x += dangerGridSize;
        }
        TrialBot.output("Is this a 1v1 game? " + this.oneVersusOne);
        this.setColors(Color.lightGray, Color.yellow, Color.darkGray);
        this.initialScanInProgress = true;
        double initialScan = 0.0;
        while (initialScan < Math.PI * 2) {
            this.turnRadarRightRadians(Rules.RADAR_TURN_RATE_RADIANS);
            initialScan += Rules.RADAR_TURN_RATE_RADIANS;
        }
        this.initialScanInProgress = false;
        while (true) {
            this.scanComplete = false;
            this.scan();
            if (!this.scanComplete) {
                this.setTurnRadarRightRadians(Math.PI * 2);
            }
            this.execute();
        }
    }

    public void onStatus(StatusEvent e) {
        this.initialisebulletShieldFailureCount(this.currentEnemyName);
        if (this.getTime() != 0L && this.getTime() % 400L == 0L) {
            int x = bulletShieldFailureCount.get(this.currentEnemyName);
            if (x > -9999) {
                --x;
            }
            bulletShieldFailureCount.put(this.currentEnemyName, x);
        }
        if (!(bulletShieldActive = bulletShieldFailureCount.get(this.currentEnemyName) < this.bulletShieldFailureThreshold)) {
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(true);
            this.setAdjustRadarForRobotTurn(true);
        } else {
            this.setAdjustGunForRobotTurn(false);
            this.setAdjustRadarForGunTurn(true);
            this.setAdjustGunForRobotTurn(true);
        }
        myLocation = new Point2D.Double(this.getX(), this.getY());
        ArrayList<Wave> deadWaves = new ArrayList<Wave>();
        for (Wave wave : this.waves) {
            wave.update(this.getTime());
            if (!wave.isDead()) continue;
            deadWaves.add(wave);
        }
        this.waves.removeAll(deadWaves);
        ArrayList<GunWave> deadGunWaves = new ArrayList<GunWave>();
        for (GunWave gunWave : this.gunWaves) {
            gunWave.update(this.getTime());
            if (!gunWave.isDead()) continue;
            deadGunWaves.add(gunWave);
        }
        this.gunWaves.removeAll(deadGunWaves);
        ArrayList<VirtualBullet> deadVirtualBullets = new ArrayList<VirtualBullet>();
        for (VirtualBullet virtualBullet : this.virtualBullets) {
            virtualBullet.update(this.getTime());
            if (!virtualBullet.isDead()) continue;
            deadVirtualBullets.add(virtualBullet);
        }
        this.virtualBullets.removeAll(deadVirtualBullets);
        if (!this.currentEnemyName.equals("") && this.getTime() % 10L == 0L) {
            MovementMode.evaluate(this.currentEnemyName);
            GunManager.evaluate(this.currentEnemyName);
        }
        for (Point2D dangerPoint : this.dangerGrid.keySet()) {
            double danger = this.dangerGrid.get(dangerPoint);
            this.dangerGrid.put(dangerPoint, danger - this.dangerFadeRate);
        }
        if (this.onlyTargetLeaderCountDown > 0) {
            --this.onlyTargetLeaderCountDown;
        }
    }

    public Wave getClosestWave(Point2D.Double myLocation) {
        double closestWaveDistance = Double.MAX_VALUE;
        Wave closestWave = null;
        for (Wave wave : this.waves) {
            double waveDistance = wave.getDistance(myLocation);
            if (!(waveDistance < closestWaveDistance)) continue;
            closestWaveDistance = waveDistance;
            closestWave = wave;
        }
        return closestWave;
    }

    public void onRoundEnded(RoundEndedEvent e) {
        if (this.oneVersusOne) {
            MovementMode.incrementRounds(this.currentEnemyName);
        }
    }

    public static void output(String text) {
        System.out.println(text);
    }

    public void onWin(WinEvent e) {
        if (this.oneVersusOne) {
            MovementMode.incrementWins(this.currentEnemyName);
        }
    }

    public void onDeath(DeathEvent event) {
    }

    public void onBattleEnded(BattleEndedEvent e) {
        FileManager.save(this.getDataFile(dataFileName));
    }

    public void initialiseEnergy(String enemyName, Double enemyEnergy) {
        if (this.opponentEnergy.get(enemyName) == null) {
            this.opponentEnergy.put(enemyName, enemyEnergy);
        }
    }

    public void initialisebulletShieldFailureCount(String enemyName) {
        if (bulletShieldFailureCount.get(enemyName) == null) {
            bulletShieldFailureCount.put(enemyName, 0);
        }
    }

    private void radarTrack(double absoluteBearing) {
        double factor = 2.0;
        if (!this.oneVersusOne && this.getOthers() > 1 && Math.random() * 100.0 < 10.0) {
            factor = 8.0;
        }
        double radarTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians()));
        this.setTurnRadarRightRadians(factor * radarTurn);
    }

    public void gunTurn(double absoluteBearing, double lateralVelocity, double bulletPower, double enemyDistance, double enemyHeading, double enemyVelocity, String enemyName) {
        double gunTurn = absoluteBearing - this.getGunHeadingRadians();
        gunTurn = GunManager.getActiveGun(enemyName).getGunTurnOffset(gunTurn, this.getGunHeadingRadians(), absoluteBearing, lateralVelocity, bulletPower, enemyDistance, enemyHeading, enemyVelocity, enemyName);
        gunTurn = Utils.normalRelativeAngle((double)gunTurn);
        this.setTurnGunRightRadians(gunTurn);
    }

    public static double getCircularTheta(double enemyDistance, double absoluteBearing, String enemyName, double enemyHeading, double enemyVelocity, double bulletPower) {
        double enemyX = myLocation.getX() + enemyDistance * Math.sin(absoluteBearing);
        double enemyY = myLocation.getY() + enemyDistance * Math.cos(absoluteBearing);
        if (oldEnemyHeading.get(enemyName) == null) {
            oldEnemyHeading.put(enemyName, enemyHeading);
        }
        double enemyHeadingChange = enemyHeading - oldEnemyHeading.get(enemyName);
        oldEnemyHeading.put(enemyName, enemyHeading);
        double deltaTime = 0.0;
        double predictedX = enemyX;
        double predictedY = enemyY;
        while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myLocation.getX(), myLocation.getY(), predictedX, predictedY)) {
            predictedY += Math.cos(enemyHeading) * enemyVelocity;
            if (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
            break;
        }
        double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - myLocation.getX(), predictedY - myLocation.getY()));
        return theta;
    }

    private double getIdealBulletPower(String enemyName, double distance) {
        Double enemyEnergy;
        if (this.useMinimumBulletPower) {
            return 0.1;
        }
        double bulletPower = bulletShieldActive ? 0.1 : (distance < 150.0 ? 3.0 : (GunManager.getActiveGun(enemyName).isSuperEffective() ? 3.0 : (distance < 250.0 ? 2.0 : (GunManager.getActiveGun(enemyName).isEffective() ? 2.0 : 1.9))));
        if (!this.oneVersusOne && this.getOthers() > 1) {
            bulletPower *= 1.5;
        }
        if (!this.oneVersusOne && this.getEnergy() <= 2.0) {
            bulletPower = 0.0;
        }
        if ((enemyEnergy = this.opponentEnergy.get(enemyName)) < 3.0) {
            bulletPower = enemyEnergy - 0.1;
        } else if (enemyEnergy < 12.0) {
            bulletPower = enemyEnergy / 4.0 + 0.3;
        }
        if (bulletPower > 3.0) {
            bulletPower = 3.0;
        } else if (bulletPower < 0.1) {
            bulletPower = 0.1;
        }
        return bulletPower;
    }

    public void goTo(Point2D destination) {
        this.goToDestination = destination;
        Point2D.Double myLocation = new Point2D.Double(this.getX(), this.getY());
        double distance = myLocation.distance(destination);
        double angle = TrialBot.absoluteBearing(myLocation, destination) - this.getHeadingRadians();
        if (Math.abs(angle = Utils.normalRelativeAngle((double)angle)) > 1.5707963267948966) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.setTurnRightRadians(angle);
        this.setAhead(distance);
    }

    public double getAngleTowards(Point2D destination) {
        Point2D.Double myLocation = new Point2D.Double(this.getX(), this.getY());
        double angle = TrialBot.absoluteBearing(myLocation, destination) - this.getHeadingRadians();
        angle = Utils.normalRelativeAngle((double)angle);
        return angle;
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        TrialBot.output("SKIPPED TURN: " + e.getSkippedTurn());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double bulletPower;
        ArrayList<String> leaders = new ArrayList<String>();
        leaders.add("Queen");
        leaders.add("Leader");
        leaders.add("ImWithStupid");
        boolean isLeader = false;
        for (String leader : leaders) {
            if (!e.getName().toLowerCase().contains(leader.toLowerCase())) continue;
            this.onlyTargetLeaderCountDown = 25;
            isLeader = true;
            break;
        }
        if (!isLeader && this.onlyTargetLeaderCountDown > 0) {
            return;
        }
        if (!this.isTeammate(e.getName())) {
            if (e.getDistance() < this.closestEnemyDistance) {
                this.closestEnemyDistance = e.getDistance();
            }
            if (!this.oneVersusOne && this.getOthers() > 1 && e.getDistance() > this.closestEnemyDistance) {
                this.closestEnemyDistance += 100.0;
                return;
            }
        }
        this.currentEnemyName = e.getName();
        PatternMatchingManager.addItem(this.currentEnemyName, e.getHeadingRadians(), e.getVelocity());
        this.initialisebulletShieldFailureCount(this.currentEnemyName);
        this.initialiseEnergy(this.currentEnemyName, e.getEnergy());
        GunManager.initialise(this.currentEnemyName);
        MovementMode.initialise(this.currentEnemyName);
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        enemyHeading = e.getHeadingRadians();
        enemyVelocity = e.getVelocity();
        enemyLocation = TrialBot.project(new Point2D.Double(this.getX(), this.getY()), absoluteBearing, e.getDistance());
        enemyRectangle = new Rectangle2D.Double(enemyLocation.getX() - this.getWidth() / 2.0, enemyLocation.getY() - this.getHeight() / 2.0, this.getWidth(), this.getHeight());
        for (Point2D dangerPoint : this.dangerGrid.keySet()) {
            double danger = this.dangerGrid.get(dangerPoint);
            if (dangerPoint.distance(enemyLocation) <= 400.0 && this.isTeammate(e.getName())) {
                danger += 1000.0;
            }
            if (dangerPoint.distance(enemyLocation) <= 200.0) {
                danger += 20.0;
            }
            if (dangerPoint.distance(enemyLocation) <= 400.0) {
                danger += 5.0;
            }
            if (this.initialScanInProgress && dangerPoint.distance(enemyLocation) <= 400.0) {
                danger += 1000.0;
            }
            this.dangerGrid.put(dangerPoint, danger);
        }
        if (this.initialScanInProgress) {
            return;
        }
        if (this.isTeammate(e.getName())) {
            return;
        }
        ArrayList<GunWave> deadGunWaves = new ArrayList<GunWave>();
        for (GunWave gunWave : this.gunWaves) {
            gunWave.update(this.getTime(), enemyLocation);
            if (!gunWave.isDead()) continue;
            deadGunWaves.add(gunWave);
        }
        this.gunWaves.removeAll(deadGunWaves);
        ArrayList<VirtualBullet> deadVirtualBullets = new ArrayList<VirtualBullet>();
        for (VirtualBullet virtualBullet : this.virtualBullets) {
            virtualBullet.update(this.getTime(), enemyLocation);
            if (!virtualBullet.isDead()) continue;
            deadVirtualBullets.add(virtualBullet);
        }
        this.virtualBullets.removeAll(deadVirtualBullets);
        double lateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing);
        if (!bulletShieldActive || !endGameBulletShieldOverride) {
            this.radarTrack(absoluteBearing);
        }
        if (bulletShieldActive || endGameBulletShieldOverride) {
            endGameBulletShieldOverride = e.getEnergy() <= 3.0;
        }
        if (bulletShieldActive && !endGameBulletShieldOverride && this.getOthers() == 1) {
            int x;
            if (this.getTime() >= 400L && this.getEnergy() == 100.0 && e.getEnergy() == 100.0) {
                this.setFire(0.1);
                this.execute();
            } else if (this.getEnergy() <= e.getEnergy() * 0.5 && e.getEnergy() >= 10.0) {
                x = bulletShieldFailureCount.get(this.currentEnemyName);
                bulletShieldFailureCount.put(this.currentEnemyName, x += 10);
            } else if (e.getDistance() <= 20.0) {
                x = bulletShieldFailureCount.get(this.currentEnemyName);
                bulletShieldFailureCount.put(this.currentEnemyName, ++x);
                this.setFire(3.0);
                this.execute();
            } else {
                this.bulletShield.onScannedRobot(e);
                this.execute();
                return;
            }
        }
        if ((bulletPower = this.getIdealBulletPower(e.getName(), e.getDistance())) > this.getEnergy()) {
            bulletPower = 0.1;
        }
        this.gunTurn(absoluteBearing, lateralVelocity, bulletPower, e.getDistance(), e.getHeadingRadians(), e.getVelocity(), e.getName());
        if (this.getGunHeat() == 0.0 && this.getEnergy() >= bulletPower && bulletPower > 0.0) {
            this.setFireBullet(bulletPower);
            this.useMinimumBulletPower = false;
            for (Gun gunToVirtualFire : GunManager.getEnemyNameToGunList().get(e.getName())) {
                double virtualGunTurn = absoluteBearing - this.getGunHeadingRadians();
                virtualGunTurn = gunToVirtualFire.getGunTurnOffset(virtualGunTurn, this.getGunHeadingRadians(), absoluteBearing, lateralVelocity, bulletPower, e.getDistance(), e.getHeadingRadians(), e.getVelocity(), e.getName());
                this.virtualBullets.add(new VirtualBullet(gunToVirtualFire, TrialBot.bulletVelocity(bulletPower), myLocation, this.getGunHeadingRadians() + Utils.normalRelativeAngle((double)virtualGunTurn), this.getTime()));
                gunToVirtualFire.shots += 1.0;
            }
            int velSeg = (int)(e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing));
            GunWave gunWave = new GunWave(TrialBot.bulletVelocity(bulletPower), new Point2D.Double(this.getX(), this.getY()), velSeg, absoluteBearing, this.getTime(), e.getName());
            this.gunWaves.add(gunWave);
        }
        double energyDrop = this.opponentEnergy.get(e.getName()) - e.getEnergy();
        if (this.getOthers() == 1 && energyDrop >= 0.1 && energyDrop <= 3.0) {
            double bulletDirectionHeadon = absoluteBearing;
            bulletDirectionHeadon = bulletDirectionHeadon < Math.PI ? (bulletDirectionHeadon += Math.PI) : (bulletDirectionHeadon -= Math.PI);
            double bulletDirectionLinear = bulletDirectionHeadon;
            double myLateralVelocity = this.getVelocity() * Math.sin(this.getHeadingRadians() - absoluteBearing);
            Wave wave = new Wave(enemyLocation, energyDrop, TrialBot.bulletVelocity(energyDrop), this.getTime(), e.getDistance() + 200.0, bulletDirectionHeadon, bulletDirectionLinear += myLateralVelocity / Rules.getBulletSpeed((double)bulletPower));
            this.waves.add(wave);
        }
        this.performMovement(e);
        this.opponentEnergy.put(e.getName(), e.getEnergy());
        this.scanComplete = true;
    }

    private void performMovement(ScannedRobotEvent e) {
        if (!this.oneVersusOne && this.getOthers() == 1) {
            this.performMovementAgainstFinalMeleeOpponent(e);
        } else if (this.oneVersusOne) {
            this.performMovementAgainstSingleOpponents(e);
        } else {
            this.performMovementAgainstMultipleOpponents(e);
        }
    }

    private void performMovementAgainstMultipleOpponents(ScannedRobotEvent e) {
        double leastDanger = Double.MAX_VALUE;
        Point2D gotoPoint = myLocation;
        for (Point2D dangerPoint : this.dangerGrid.keySet()) {
            double danger;
            if (myLocation.distance(dangerPoint) > 300.0 || !((danger = this.dangerGrid.get(dangerPoint).doubleValue()) <= leastDanger) || !(Math.random() * 100.0 < 75.0)) continue;
            leastDanger = danger;
            gotoPoint = dangerPoint;
        }
        if (this.getDistanceRemaining() == 0.0) {
            this.goTo(gotoPoint);
        }
    }

    private void performMovementAgainstFinalMeleeOpponent(ScannedRobotEvent e) {
        double randomBodyTurnOffset = Math.random() * 0.6283185307179586 - Math.random() * 0.6283185307179586;
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        double energyDrop = this.opponentEnergy.get(e.getName()) - e.getEnergy();
        if (this.getDistanceRemaining() == 0.0 && this.getTurnRemainingRadians() == 0.0) {
            if (e.getDistance() > 800.0) {
                double bodyTurn = absoluteBearing - this.getHeadingRadians();
                bodyTurn += randomBodyTurnOffset;
                bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                this.setTurnRightRadians(bodyTurn);
                double movementAmount = Math.random() * 100.0;
                this.setAhead(movementAmount);
            } else if (e.getDistance() < 100.0) {
                double bodyTurn = absoluteBearing - this.getHeadingRadians() + Math.PI;
                bodyTurn += randomBodyTurnOffset;
                bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                this.setTurnRightRadians(bodyTurn);
                double movementAmount = Math.random() * 150.0;
                this.setAhead(movementAmount);
            } else {
                int wallMargin = 50;
                if (this.getX() <= (double)wallMargin || this.getX() >= this.getBattleFieldWidth() - (double)wallMargin || this.getY() <= (double)wallMargin || this.getY() >= this.getBattleFieldHeight() - (double)wallMargin) {
                    double bodyTurn = absoluteBearing - this.getHeadingRadians();
                    bodyTurn += randomBodyTurnOffset;
                    bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                    this.setTurnRightRadians(bodyTurn);
                    double movementAmount = Math.random() * 100.0;
                    this.setAhead(movementAmount);
                } else {
                    double bodyTurn = absoluteBearing - this.getHeadingRadians() + 1.5707963267948966;
                    bodyTurn += randomBodyTurnOffset;
                    bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                    this.setTurnRightRadians(bodyTurn);
                    if (Math.random() * 100.0 <= 50.0) {
                        this.forward = !this.forward;
                    }
                    double movementAmount = Math.random() * 100.0;
                    if (energyDrop >= 0.1 && energyDrop <= 3.0) {
                        movementAmount += 100.0;
                    }
                    if (this.forward) {
                        this.setAhead(movementAmount);
                    } else {
                        this.setAhead(-movementAmount);
                    }
                }
            }
        }
    }

    private void performMovementAgainstSingleOpponents(ScannedRobotEvent e) {
        double randomBodyTurnOffset = Math.random() * 0.6283185307179586 - Math.random() * 0.6283185307179586;
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        Point2D enemyLocation = TrialBot.project(new Point2D.Double(this.getX(), this.getY()), absoluteBearing, e.getDistance());
        double energyDrop = this.opponentEnergy.get(e.getName()) - e.getEnergy();
        double lateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - absoluteBearing);
        if (MovementMode.get(e.getName()).equals("danger_zones")) {
            double leastDanger = Double.MAX_VALUE;
            Point2D gotoPoint = myLocation;
            for (Point2D dangerPoint : this.dangerGrid.keySet()) {
                double danger;
                if (myLocation.distance(dangerPoint) > 300.0 || !((danger = this.dangerGrid.get(dangerPoint).doubleValue()) <= leastDanger) || !(Math.random() * 100.0 < 75.0)) continue;
                leastDanger = danger;
                gotoPoint = dangerPoint;
            }
            if (this.getDistanceRemaining() == 0.0) {
                this.goTo(gotoPoint);
            }
        } else if (MovementMode.get(e.getName()).equals("mirror_perfect")) {
            double destinationDistanceY;
            double headOnBearing = e.getBearingRadians() + this.getHeadingRadians();
            double destinationDistanceX = this.getBattleFieldWidth() - Math.sin(headOnBearing) * e.getDistance() - this.getX() * 2.0;
            double destinationDistance = Math.sqrt(destinationDistanceX * destinationDistanceX + (destinationDistanceY = this.getBattleFieldHeight() - Math.cos(headOnBearing) * e.getDistance() - this.getY() * 2.0) * destinationDistanceY);
            destinationDistance = destinationDistance > 0.001 ? destinationDistance : 0.0;
            double turn = (destinationDistance > 0.0 ? Math.atan2(destinationDistanceX, destinationDistanceY) : e.getHeadingRadians()) - this.getHeadingRadians();
            double ahead = Double.POSITIVE_INFINITY;
            if (Math.cos(turn) < 0.0) {
                turn -= Math.PI;
                ahead = Double.NEGATIVE_INFINITY;
            }
            this.setTurnRightRadians(Utils.normalRelativeAngle((double)turn));
            this.setAhead(ahead);
            this.setMaxVelocity(destinationDistance);
        } else if (MovementMode.get(e.getName()).equals("mirror_eratic")) {
            if (this.getTime() % 5L == 0L) {
                double destinationDistanceY;
                double headOnBearing = e.getBearingRadians() + this.getHeadingRadians();
                double destinationDistanceX = this.getBattleFieldWidth() - Math.sin(headOnBearing) * e.getDistance() - this.getX() * 2.0;
                double destinationDistance = Math.sqrt(destinationDistanceX * destinationDistanceX + (destinationDistanceY = this.getBattleFieldHeight() - Math.cos(headOnBearing) * e.getDistance() - this.getY() * 2.0) * destinationDistanceY);
                destinationDistance = destinationDistance > 0.001 ? destinationDistance : 0.0;
                double turn = ((destinationDistance *= Math.random()) > 0.0 ? Math.atan2(destinationDistanceX, destinationDistanceY) : e.getHeadingRadians()) - this.getHeadingRadians();
                double ahead = Double.POSITIVE_INFINITY;
                if (Math.cos(turn) < 0.0) {
                    turn -= Math.PI;
                    ahead = Double.NEGATIVE_INFINITY;
                }
                this.setTurnRightRadians(Utils.normalRelativeAngle((double)turn));
                this.setAhead(ahead);
                this.setMaxVelocity(destinationDistance);
            }
        } else if (MovementMode.get(e.getName()).equals("ramming")) {
            double bodyTurn = absoluteBearing - this.getHeadingRadians();
            bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
            this.setTurnRightRadians(bodyTurn += lateralVelocity / 8.0);
            this.setAhead(500.0);
        } else if (MovementMode.get(e.getName()).equals("ramming_headon")) {
            double bodyTurn = absoluteBearing - this.getHeadingRadians();
            bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
            this.setTurnRightRadians(bodyTurn);
            this.setAhead(500.0);
        } else if (this.getDistanceRemaining() == 0.0 && this.getTurnRemainingRadians() == 0.0 || MovementMode.get(e.getName()) != null && MovementMode.get(e.getName()).equals("wave_surfing_continual")) {
            if (e.getDistance() > 600.0) {
                double bodyTurn = absoluteBearing - this.getHeadingRadians();
                bodyTurn += randomBodyTurnOffset;
                bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                this.setTurnRightRadians(bodyTurn);
                double movementAmount = Math.random() * 100.0;
                this.setAhead(movementAmount);
            } else if (e.getDistance() < 100.0) {
                double bodyTurn = absoluteBearing - this.getHeadingRadians() + Math.PI;
                bodyTurn += randomBodyTurnOffset;
                bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                this.setTurnRightRadians(bodyTurn);
                double movementAmount = Math.random() * 150.0;
                this.setAhead(movementAmount);
            } else {
                int wallMargin = 50;
                if (this.getX() <= (double)wallMargin || this.getX() >= this.getBattleFieldWidth() - (double)wallMargin || this.getY() <= (double)wallMargin || this.getY() >= this.getBattleFieldHeight() - (double)wallMargin) {
                    double bodyTurn = absoluteBearing - this.getHeadingRadians();
                    bodyTurn += randomBodyTurnOffset;
                    bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                    this.setTurnRightRadians(bodyTurn);
                    double movementAmount = Math.random() * 100.0;
                    this.setAhead(movementAmount);
                } else if (!MovementMode.get(e.getName()).equals("random") && this.getOthers() == 1) {
                    Point2D.Double myLocation = new Point2D.Double(this.getX(), this.getY());
                    ArrayList<Point2D> bulletLocations = new ArrayList<Point2D>();
                    for (Wave wave : this.waves) {
                        bulletLocations.addAll(wave.getBulletLocations());
                    }
                    Point2D.Double possibleNewLocation = new Point2D.Double(myLocation.getX(), myLocation.getY());
                    int x = 0;
                    double battleFieldWidth = this.getBattleFieldWidth();
                    double battleFieldHeight = this.getBattleFieldHeight();
                    double surfingWallMargin = 75.0;
                    double surfingBulletMargin = 23.0;
                    double surfingEnemyMargin = 75.0;
                    double maxRandomOffset = 150.0;
                    boolean isFarFromAllBulletLocations = false;
                    double velocity = this.getVelocity();
                    while (!isFarFromAllBulletLocations) {
                        if (++x > 10000) break;
                        if (x > 9000) {
                            maxRandomOffset = 350.0;
                        }
                        if (velocity == 0.0 && MovementMode.get(e.getName()).equals("wave_surfing_continual")) {
                            maxRandomOffset = 650.0;
                        }
                        double xOffset = Math.random() * maxRandomOffset - Math.random() * maxRandomOffset;
                        double yOffset = Math.random() * maxRandomOffset - Math.random() * maxRandomOffset;
                        ((Point2D)possibleNewLocation).setLocation(myLocation.getX() + xOffset, myLocation.getY() + yOffset);
                        if (((Point2D)possibleNewLocation).getX() < surfingWallMargin || ((Point2D)possibleNewLocation).getY() < surfingWallMargin || ((Point2D)possibleNewLocation).getX() > battleFieldWidth - surfingWallMargin || ((Point2D)possibleNewLocation).getY() > battleFieldHeight - surfingWallMargin || possibleNewLocation.distance(enemyLocation) <= surfingEnemyMargin) continue;
                        int numberOfBulletLocationsFarAwayFrom = 0;
                        for (Point2D bulletLocation : bulletLocations) {
                            if (!(possibleNewLocation.distance(bulletLocation) >= surfingBulletMargin) || !(possibleNewLocation.distance(bulletLocation) >= myLocation.distance(bulletLocation))) continue;
                            ++numberOfBulletLocationsFarAwayFrom;
                        }
                        if (numberOfBulletLocationsFarAwayFrom != bulletLocations.size()) continue;
                        isFarFromAllBulletLocations = true;
                    }
                    if (isFarFromAllBulletLocations) {
                        this.goTo(possibleNewLocation);
                    }
                } else {
                    double bodyTurn = absoluteBearing - this.getHeadingRadians() + 1.5707963267948966;
                    bodyTurn += randomBodyTurnOffset;
                    bodyTurn = Utils.normalRelativeAngle((double)bodyTurn);
                    this.setTurnRightRadians(bodyTurn);
                    if (Math.random() * 100.0 <= 50.0) {
                        this.forward = !this.forward;
                    }
                    double movementAmount = Math.random() * 100.0;
                    if (energyDrop >= 0.1 && energyDrop <= 3.0) {
                        movementAmount += 100.0;
                    }
                    if (this.forward) {
                        this.setAhead(movementAmount);
                    } else {
                        this.setAhead(-movementAmount);
                    }
                }
            }
        }
    }

    public static double bulletVelocity(double bulletPower) {
        return 20.0 - 3.0 * bulletPower;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (bulletShieldActive && this.getOthers() == 1) {
            this.bulletShield.onBulletHitBullet(e);
            return;
        }
        if (this.oneVersusOne) {
            this.useMinimumBulletPower = true;
        }
        Point2D activeGunBulletPosition = null;
        for (VirtualBullet virtualBullet : this.virtualBullets) {
            if (virtualBullet.getGun() != GunManager.getActiveGun(this.currentEnemyName)) continue;
            activeGunBulletPosition = virtualBullet.getBulletPosition();
            virtualBullet.markAsDead();
        }
        if (activeGunBulletPosition != null) {
            for (VirtualBullet virtualBullet : this.virtualBullets) {
                if (!(virtualBullet.getBulletPosition().distance(activeGunBulletPosition) <= 2.5)) continue;
                virtualBullet.markAsDead();
            }
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (bulletShieldActive && this.getOthers() == 1) {
            this.bulletShield.onHitByBullet(e);
            return;
        }
        for (Point2D dangerPoint : this.dangerGrid.keySet()) {
            if (!(myLocation.distance(dangerPoint) < 200.0)) continue;
            double danger = this.dangerGrid.get(dangerPoint);
            this.dangerGrid.put(dangerPoint, danger + 200.0 + 200.0 * e.getPower());
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (bulletShieldActive && this.getOthers() == 1) {
            this.bulletShield.onBulletHit(e);
            return;
        }
        double power = e.getBullet().getPower();
        double damage = 4.0 * power;
        if (power > 1.0) {
            damage += 2.0 * (power - 1.0);
        }
        this.initialiseEnergy(e.getName(), e.getEnergy());
        this.opponentEnergy.put(e.getName(), this.opponentEnergy.get(e.getName()) - damage);
        GunManager.initialise(e.getName());
    }

    public void onHitRobot(HitRobotEvent e) {
        this.initialiseEnergy(e.getName(), e.getEnergy());
        this.opponentEnergy.put(e.getName(), this.opponentEnergy.get(e.getName()) - 0.6);
        for (Point2D dangerPoint : this.dangerGrid.keySet()) {
            if (!(myLocation.distance(dangerPoint) < 600.0)) continue;
            double danger = this.dangerGrid.get(dangerPoint);
            this.dangerGrid.put(dangerPoint, danger + 1000.0);
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.forward = !this.forward;
        double movementAmount = 50.0 + Math.random() * 50.0;
        if (this.forward) {
            this.setAhead(movementAmount);
        } else {
            this.setAhead(-movementAmount);
        }
        this.execute();
    }

    public static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.green);
        Point2D aimingBodyAt = TrialBot.project(new Point2D.Double(this.getX(), this.getY()), this.getHeadingRadians(), 1000.0);
        g.drawLine((int)this.getX(), (int)this.getY(), (int)aimingBodyAt.getX(), (int)aimingBodyAt.getY());
        g.setColor(Color.red);
        Point2D aimingGunAt = TrialBot.project(new Point2D.Double(this.getX(), this.getY()), this.getGunHeadingRadians(), 1000.0);
        g.drawLine((int)this.getX(), (int)this.getY(), (int)aimingGunAt.getX(), (int)aimingGunAt.getY());
        if (enemyRectangle != null) {
            g.setColor(Color.gray);
            g.drawRect((int)enemyRectangle.getX(), (int)enemyRectangle.getY(), (int)enemyRectangle.getWidth(), (int)enemyRectangle.getHeight());
        }
        if (this.goToDestination != null) {
            g.setColor(Color.blue);
            int robotSize = 36;
            g.drawRect((int)this.goToDestination.getX() - 18, (int)this.goToDestination.getY() - 18, robotSize, robotSize);
        }
        g.setFont(new Font("Arial", 0, 10));
        String text = "Current target: " + this.currentEnemyName;
        g.setColor(Color.white);
        g.drawString(text, 10, 40);
        text = "Bullet shield active: ";
        text = String.valueOf(text) + bulletShieldActive;
        text = String.valueOf(text) + "          ";
        text = String.valueOf(text) + bulletShieldFailureCount.get(this.currentEnemyName) + "/" + this.bulletShieldFailureThreshold;
        text = String.valueOf(text) + " failure count/threshold";
        text = String.valueOf(text) + "          ";
        text = String.valueOf(text) + "End Game override: ";
        text = String.valueOf(text) + endGameBulletShieldOverride;
        g.setColor(Color.white);
        g.drawString(text, 10, 30);
        Gun activeGun = GunManager.getActiveGun(this.currentEnemyName);
        if (activeGun != null) {
            text = "Current gun tactic: " + activeGun.name;
            text = String.valueOf(text) + "          ";
            text = String.valueOf(text) + activeGun.hits + "/" + activeGun.shots + " shots hit";
            if (activeGun.isSuperEffective()) {
                text = String.valueOf(text) + " (super effective)";
            } else if (activeGun.isEffective()) {
                text = String.valueOf(text) + " (effective)";
            }
            g.setColor(Color.white);
            g.drawString(text, 10, 20);
        }
        if (this.oneVersusOne) {
            text = "(1v1) Current movement mode: " + MovementMode.get(this.currentEnemyName);
            text = String.valueOf(text) + "          ";
            text = String.valueOf(text) + MovementMode.getWins().get(this.currentEnemyName) + "/" + MovementMode.getRounds().get(this.currentEnemyName) + " rounds won";
            if (MovementMode.isTacticSuperEffective(this.currentEnemyName)) {
                text = String.valueOf(text) + " (super effective)";
            } else if (MovementMode.isTacticEffective(this.currentEnemyName)) {
                text = String.valueOf(text) + " (effective)";
            }
        } else {
            text = "(Melee) ";
            text = this.getOthers() == 1 ? String.valueOf(text) + "Single opponent" : String.valueOf(text) + "Multiple opponents";
        }
        g.setColor(Color.white);
        g.drawString(text, 10, 10);
        if (this.oneVersusOne && MovementMode.get(this.currentEnemyName) != null && (MovementMode.get(this.currentEnemyName).equals("wave_surfing_continual") || MovementMode.get(this.currentEnemyName).equals("wave_surfing"))) {
            Point2D.Double myLocation = new Point2D.Double(this.getX(), this.getY());
            for (Wave wave : this.waves) {
                if (this.getClosestWave(myLocation) == wave) {
                    wave.paint(g, Color.white);
                    wave.paintBulletLocations(g, Color.red);
                    continue;
                }
                wave.paint(g, Color.gray);
            }
        }
        for (GunWave gunWave : this.gunWaves) {
            gunWave.paint(g, Color.cyan);
        }
        for (VirtualBullet virtualBullet : this.virtualBullets) {
            if (virtualBullet.getGun() == GunManager.getActiveGun(this.currentEnemyName)) {
                virtualBullet.paint(g, Color.red);
                continue;
            }
            virtualBullet.paint(g, Color.yellow);
        }
        if (!this.oneVersusOne && this.getOthers() > 1 || MovementMode.get(this.currentEnemyName) != null && MovementMode.get(this.currentEnemyName).equals("danger_zones")) {
            int dangerPointSize = 1;
            for (Point2D point2D : this.dangerGrid.keySet()) {
                if (this.dangerGrid.get(point2D) <= 0.0) {
                    g.setColor(Color.green);
                } else if (this.dangerGrid.get(point2D) <= 500.0) {
                    g.setColor(Color.yellow);
                } else if (this.dangerGrid.get(point2D) <= 1000.0) {
                    g.setColor(Color.red);
                } else {
                    g.setColor(Color.black);
                }
                g.drawOval((int)point2D.getX() - dangerPointSize / 2, (int)point2D.getY() - dangerPointSize / 2, dangerPointSize, dangerPointSize);
            }
        }
        g.setColor(Color.pink);
        PatternMatchingManager.paint(g, this.currentEnemyName, enemyLocation, enemyHeading, enemyVelocity);
    }
}

