/*
 * Decompiled with CFR 0.152.
 */
package cf.Guns;

import cf.target;
import cf.util.Calc;
import cf.util.Gun;
import cf.util.PM;
import cf.util.PMData;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.RobocodeFileOutputStream;
import robocode.ScannedRobotEvent;

public class PMGun
implements Gun {
    AdvancedRobot bot;
    PM pm;
    boolean firstScan = true;
    String e_name;
    double e_dist;
    double e_energy;
    double e_head;
    double e_x;
    double e_y;
    double e_absBear;
    Point2D.Double e_pos;

    public PMGun(AdvancedRobot bot) {
        this.bot = bot;
        this.pm = new PM(500);
    }

    public void work() {
    }

    public void end() {
        this.savePMData();
    }

    public void shoot() {
        target t;
        if (this.firstScan || this.e_pos == null) {
            return;
        }
        double power = 900.0 / this.e_dist;
        double killPower = Calc.getKillPower(this.e_energy);
        if (killPower < power) {
            power = killPower;
        }
        if ((t = this.pm.getTarget(new Point((int)this.bot.getX(), (int)this.bot.getY()), (int)this.bot.getTime(), new Point((int)this.e_pos.getX(), (int)this.e_pos.getY()), this.e_head, power)) != null) {
            this.fireAt(t);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.firstScan) {
            this.firstScan = false;
            StringTokenizer st = new StringTokenizer(e.getName(), "[({_ ");
            this.e_name = st.nextToken();
            this.readPMData();
            this.e_head = e.getHeading();
            this.e_dist = e.getDistance();
            this.e_energy = e.getEnergy();
            this.e_absBear = e.getBearing() + this.bot.getHeading();
            this.e_x = this.bot.getX() + e.getDistance() * Math.sin(Math.toRadians(this.e_absBear));
            this.e_y = this.bot.getY() + e.getDistance() * Math.cos(Math.toRadians(this.e_absBear));
            this.e_pos = new Point2D.Double(this.e_x, this.e_y);
            return;
        }
        this.e_dist = e.getDistance();
        this.e_energy = e.getEnergy();
        this.e_absBear = e.getBearing() + this.bot.getHeading();
        this.e_x = this.bot.getX() + e.getDistance() * Math.sin(Math.toRadians(this.e_absBear));
        this.e_y = this.bot.getY() + e.getDistance() * Math.cos(Math.toRadians(this.e_absBear));
        this.e_pos = new Point2D.Double(this.e_x, this.e_y);
        this.pm.add(false, (int)this.bot.getTime(), e.getVelocity(), e.getHeading() - this.e_head);
        this.e_head = e.getHeading();
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readPMData() {
        try {
            File dataFile = this.bot.getDataFile(this.e_name + ".cfpm");
            if (!dataFile.exists()) {
                System.out.println("No pm New bot:" + this.e_name);
                return;
            }
            ObjectInputStream reader = new ObjectInputStream(new GZIPInputStream(new FileInputStream(dataFile)));
            try {
                while (true) {
                    PMData pmd = (PMData)reader.readObject();
                    this.pm.add(true, pmd.timeDiff, pmd.speed, pmd.angleChange);
                }
            }
            catch (EOFException e2) {
                reader.close();
                return;
            }
        }
        catch (Exception e1) {
            System.out.println("e1:" + e1);
        }
    }

    public void savePMData() {
        try {
            File dataFile = this.bot.getDataFile(this.e_name + ".cfpm");
            ObjectOutputStream writer = new ObjectOutputStream(new GZIPOutputStream((OutputStream)new RobocodeFileOutputStream(dataFile)));
            int i = 0;
            while (i < 100) {
                writer.writeObject(this.pm.getPMData(i));
                ++i;
            }
            writer.close();
        }
        catch (Exception e1) {
            System.out.println("e1:" + e1);
        }
    }

    void fireAt(target t) {
        double power = t.Diffc;
        if (power > 3.0) {
            power = 3.0;
        }
        if (power < 0.0 || this.bot.getEnergy() - power < 0.2) {
            return;
        }
        double angle = Calc.angle(t.X - this.bot.getX(), t.Y - this.bot.getY());
        this.bot.setTurnGunRight(Calc.normalRelativeAngle(angle - this.bot.getGunHeading()));
        this.bot.setFire(power);
    }
}

