/*
 * Decompiled with CFR 0.152.
 */
package com.cohesiva.robocode;

import com.cohesiva.robocode.Enemy;
import com.cohesiva.robocode.GravPoint;
import com.cohesiva.robocode.ManOwaR;
import com.cohesiva.robocode.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import robocode.HitByBulletEvent;

public class AntiGravMovement {
    private static final double CORNER_STRENGTH = -3000.0;
    private static final double CORNER_POWER = 2.0;
    private static final double CENTER_POWER = 2.0;
    private static final double CENTER_STRENGTH = -1000.0;
    private static final int WALL_STRENGTH = -8000;
    private static final double WALL_POWER = 3.0;
    private static final int NO_OF_ATTRACTION_POINTS = 5;
    private double yforce;
    private double xforce;
    public GravPoint attractionPoint;
    private long attractionCreatedTurn = 0L;
    private ManOwaR robot;
    private long turn = -1L;
    private Set<GravPoint> gravityPoints = new HashSet<GravPoint>();
    private Boolean movingClockwiseAgainstEnemy = true;
    private int directionChangeRandomRange = 99;
    private double[] directionChangeRandomRangeWeights = new double[100];

    public AntiGravMovement(ManOwaR robot) {
        this.robot = robot;
        this.gravityPoints.add(new GravPoint(robot.getBattleFieldWidth() / 2.0, robot.getBattleFieldHeight() / 2.0, -1000.0, 2.0));
        this.gravityPoints.add(new GravPoint(0.0, 0.0, -3000.0, 2.0));
        this.gravityPoints.add(new GravPoint(robot.getBattleFieldWidth(), 0.0, -3000.0, 2.0));
        this.gravityPoints.add(new GravPoint(0.0, robot.getBattleFieldHeight(), -3000.0, 2.0));
        this.gravityPoints.add(new GravPoint(robot.getBattleFieldWidth(), robot.getBattleFieldHeight(), -3000.0, 2.0));
    }

    public double getYforce() {
        if (this.robot.getTime() != this.turn) {
            this.turn = this.robot.getTime();
            this.recalculate();
        }
        return this.yforce;
    }

    private void recalculate() {
        this.xforce = 0.0;
        this.yforce = 0.0;
        if ((long)new Random().nextInt(this.directionChangeRandomRange * 10) < this.robot.getTime() - this.attractionCreatedTurn) {
            this.movingClockwiseAgainstEnemy = this.movingClockwiseAgainstEnemy == false;
            this.attractionCreatedTurn = this.robot.getTime();
        }
        for (Enemy en : this.robot.getEnemies().values()) {
            if (!en.isLive()) continue;
            this.recalculate(new GravPoint(en.getX(), en.getY(), -1000.0, 2.0));
        }
        for (GravPoint gravPoint : this.gravityPoints) {
            this.recalculate(gravPoint);
        }
        this.xforce -= -8000.0 / Math.pow(this.robot.getBattleFieldWidth() - this.robot.getX(), 3.0);
        this.xforce += -8000.0 / Math.pow(this.robot.getX(), 3.0);
        this.yforce -= -8000.0 / Math.pow(this.robot.getBattleFieldHeight() - this.robot.getY(), 3.0);
        this.yforce += -8000.0 / Math.pow(this.robot.getY(), 3.0);
        if (this.movingClockwiseAgainstEnemy != null && this.robot.getCurrentTarget() != null) {
            double bearingBetweenTargetAndRobot = Utils.absBearing(this.robot.getCurrentTarget().getX(), this.robot.getCurrentTarget().getY(), this.robot.getX(), this.robot.getY());
            double newAngle = this.movingClockwiseAgainstEnemy != false ? bearingBetweenTargetAndRobot + 1.5707963267948966 : bearingBetweenTargetAndRobot - 1.5707963267948966;
            newAngle = Utils.normaliseBearing(newAngle);
            double dist = 60.0;
            this.attractionPoint = new GravPoint((int)(this.robot.getX() + Math.sin(newAngle) * dist), (int)(this.robot.getY() + Math.cos(newAngle) * dist), 300.0, 2.0);
            if (!this.attractionPoint.isInsideField(this.robot.getBattleFieldWidth(), this.robot.getBattleFieldHeight())) {
                this.attractionPoint = new GravPoint((int)(this.robot.getX() + Math.sin(newAngle += 1.5707963267948966) * dist), (int)(this.robot.getY() + Math.cos(newAngle) * dist), 300.0, 2.0);
                this.movingClockwiseAgainstEnemy = this.movingClockwiseAgainstEnemy == false;
                this.attractionCreatedTurn = this.robot.getTime();
            }
            this.recalculate(this.attractionPoint);
        }
    }

    private void recalculate(GravPoint gravPoint) {
        if (gravPoint == null) {
            return;
        }
        double force = gravPoint.getStrength() / Math.pow(Utils.getRange(this.robot.getX(), this.robot.getY(), gravPoint.getX(), gravPoint.getY()), gravPoint.getPower());
        double ang = Utils.normaliseBearing(1.5707963267948966 - Math.atan2(this.robot.getY() - gravPoint.getY(), this.robot.getX() - gravPoint.getX()));
        this.xforce += Math.sin(ang) * force;
        this.yforce += Math.cos(ang) * force;
    }

    public double getXforce() {
        if (this.robot.getTime() != this.turn) {
            this.turn = this.robot.getTime();
            this.recalculate();
        }
        return this.xforce;
    }

    public void onHitByBullet(HitByBulletEvent event) {
        int i = -5;
        while (i <= 5) {
            int index = this.directionChangeRandomRange + i;
            if (index > 0 && index < 100) {
                if (i != 0) {
                    int n = index;
                    this.directionChangeRandomRangeWeights[n] = this.directionChangeRandomRangeWeights[n] + Math.abs(1.0 / (double)i);
                } else {
                    int n = index;
                    this.directionChangeRandomRangeWeights[n] = this.directionChangeRandomRangeWeights[n] + 1.0;
                }
            }
            ++i;
        }
        ArrayList<Integer> list = new ArrayList<Integer>(100);
        double lowest = 100.0;
        int i2 = 0;
        while (i2 < 100) {
            if (this.directionChangeRandomRangeWeights[i2] < lowest) {
                list.clear();
                lowest = this.directionChangeRandomRangeWeights[i2];
            } else if (this.directionChangeRandomRangeWeights[i2] < lowest + 0.1) {
                list.add(i2);
            }
            ++i2;
        }
        this.directionChangeRandomRange = (Integer)list.get(new Random().nextInt(list.size()));
    }
}

