/*
 * Decompiled with CFR 0.152.
 */
package rjw.radar;

import rjw.util.Particle;
import rjw.util.Vector;
import robocode.ScannedRobotEvent;

public class EnemyScan
extends Particle {
    private String _name;
    private long _tick;
    private Particle _origin;
    private double _energy;
    private double _damage;
    private boolean _collidedWithEnemy;

    public EnemyScan(ScannedRobotEvent event, Particle origin) {
        this._name = event.getName();
        double t = origin.getAbsoluteBearing(event.getBearingRadians());
        this._p = new Vector(t, event.getDistance()).translate(origin.p());
        this._v = new Vector(event.getHeadingRadians(), event.getVelocity());
        this._tick = event.getTime();
        this._origin = origin;
        this._energy = event.getEnergy();
    }

    public String getName() {
        return this._name;
    }

    public long getTick() {
        return this._tick;
    }

    public Particle getOrigin() {
        return this._origin;
    }

    public double getEnergy() {
        return this._energy;
    }

    public double getDamage() {
        return this._damage;
    }

    public void addDamage(double damage) {
        this._damage += damage;
    }

    public boolean getCollidedWithEnemy() {
        return this._collidedWithEnemy;
    }

    public void recordEnemyCollision() {
        this._collidedWithEnemy = true;
        this.addDamage(0.6);
    }
}

