/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.Iterator;
import pedersen.divination.WaveData;
import pedersen.tactics.grail.BearingOffsetRange;
import pedersen.tactics.grail.SegmentBase;

public class SegmentBearingOffsetImpl
extends SegmentBase {
    public static final int fixedBinSize = 50;
    private static final double maximumValue = 0.8726646259971648;
    private long zero = 0L;
    private final long[] positive = new long[this.positiveBinSize];
    private final long[] negative = new long[this.negativeBinSize];

    SegmentBearingOffsetImpl() {
        super(0.8726646259971648, 50, 50);
    }

    protected void buildOrganicBins() {
    }

    public void addWaveData(WaveData waveData) {
        Iterator iterator = waveData.getBearingOffsetRangeIterator();
        while (iterator.hasNext()) {
            this.addRange((BearingOffsetRange)iterator.next());
        }
    }

    private void addRange(BearingOffsetRange bearingOffsetRange) {
        int min = this.convertValueToSignedBinWithOffset(bearingOffsetRange.min());
        int max = this.convertValueToSignedBinWithOffset(bearingOffsetRange.max());
        if (min > 0) {
            int i = min;
            while (i < this.positiveBinSize && i <= max) {
                int n = i - 1;
                this.positive[n] = this.positive[n] + 1L;
                ++i;
            }
        } else if (max < 0) {
            int i = -max;
            while (i < this.negativeBinSize && i <= -min) {
                int n = i - 1;
                this.negative[n] = this.negative[n] + 1L;
                ++i;
            }
        } else {
            ++this.zero;
            int i = 1;
            while (i < this.positiveBinSize && i <= max) {
                int n = i - 1;
                this.positive[n] = this.positive[n] + 1L;
                ++i;
            }
            i = 1;
            while (i < this.negativeBinSize && i <= -min) {
                int n = i - 1;
                this.negative[n] = this.negative[n] + 1L;
                ++i;
            }
        }
    }

    public double getMostVisitedValue(WaveData waveData) {
        int mostVisitedSignedBinWithOffset = 0;
        long mostVisitedCount = this.zero;
        int i = 0;
        while (i < this.positiveBinSize) {
            if (this.positive[i] > mostVisitedCount) {
                mostVisitedSignedBinWithOffset = i + 1;
                mostVisitedCount = this.positive[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.negativeBinSize) {
            if (this.negative[i] > mostVisitedCount) {
                mostVisitedSignedBinWithOffset = -(i + 1);
                mostVisitedCount = this.negative[i];
            }
            ++i;
        }
        return this.convertSignedBinWithOffsetToValue(mostVisitedSignedBinWithOffset);
    }

    public double getLeastVisitedValue(WaveData waveData) {
        int leastVisitedSignedBinWithOffset = 0;
        long leastVisitedCount = this.zero;
        int i = 0;
        while (i < this.positiveBinSize) {
            if (this.positive[i] > 0L && this.positive[i] < leastVisitedCount) {
                leastVisitedSignedBinWithOffset = i + 1;
                leastVisitedCount = this.positive[i];
            }
            ++i;
        }
        i = 0;
        while (i < this.negativeBinSize) {
            if (this.negative[i] > 0L && this.negative[i] < leastVisitedCount) {
                leastVisitedSignedBinWithOffset = -(i + 1);
                leastVisitedCount = this.negative[i];
            }
            ++i;
        }
        return this.convertSignedBinWithOffsetToValue(leastVisitedSignedBinWithOffset);
    }

    public long getHitCountByIndex(int index) {
        long hitCount = this.zero;
        if (index > 0) {
            hitCount = this.positive[index - 1];
        } else if (index < 0) {
            hitCount = this.negative[-index - 1];
        }
        return hitCount;
    }

    public void debug() {
    }
}

