/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.Iterator;
import pedersen.core.Snapshot;
import pedersen.divination.WaveData;
import pedersen.misc.Arena;
import pedersen.physics.Projection;
import pedersen.physics.StaticPosition;
import pedersen.tactics.grail.Segment;
import pedersen.tactics.grail.SegmentBase;
import pedersen.tactics.grail.SegmentElapsedTimeSinceLastStopImpl;
import pedersen.tactics.targeting.TargetingMethod;

public class SegmentTimeToImpactWallImpl
extends SegmentBase
implements Segment {
    public static final double maximumValue = 20.0;
    private static final int maxBinSize = 10;

    public SegmentTimeToImpactWallImpl() {
        super(20.0, 10);
        this.zero = new SegmentElapsedTimeSinceLastStopImpl();
        this.positive = new SegmentElapsedTimeSinceLastStopImpl[0];
        this.negative = new SegmentElapsedTimeSinceLastStopImpl[0];
        this.buildOrganicBins();
    }

    protected void buildOrganicBins() {
        if (this.positiveBinSize != this.positive.length) {
            this.positive = new SegmentElapsedTimeSinceLastStopImpl[this.positiveBinSize];
            int i = 0;
            while (i < this.positiveBinSize) {
                this.positive[i] = new SegmentElapsedTimeSinceLastStopImpl();
                ++i;
            }
            Iterator iterator = this.positiveWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
        if (this.negativeBinSize != this.negative.length) {
            this.negative = new SegmentElapsedTimeSinceLastStopImpl[this.negativeBinSize];
            int i = 0;
            while (i < this.negativeBinSize) {
                this.negative[i] = new SegmentElapsedTimeSinceLastStopImpl();
                ++i;
            }
            Iterator iterator = this.negativeWaveData.iterator();
            while (iterator.hasNext()) {
                this.addWaveDataBypass((WaveData)iterator.next());
            }
        }
    }

    public void addWaveData(WaveData waveData) {
        super.addWaveData(waveData, waveData.originalTimeToImpactWall);
    }

    public void addWaveDataBypass(WaveData waveData) {
        super.addWaveDataBypass(waveData, waveData.originalTimeToImpactWall);
    }

    public double getMostVisitedBearingOffset(WaveData waveData) {
        return super.getMostVisitedBearingOffset(waveData, waveData.originalTimeToImpactWall);
    }

    public double getLeastVisitedBearingOffset(WaveData waveData) {
        return super.getLeastVisitedBearingOffset(waveData, waveData.originalTimeToImpactWall);
    }

    public double getMostVisitedLinearProjection(WaveData waveData) {
        return super.getMostVisitedLinearProjection(waveData, waveData.originalTimeToImpactWall);
    }

    public TargetingMethod getFavoredTargetingMethod(WaveData waveData) {
        return super.getFavoredTargetingMethod(waveData, waveData.originalTimeToImpactWall);
    }

    public static int calculateTimeToImpactWall(Snapshot subject) {
        double heading = subject.getHeading();
        if (subject.getVelocity() < 0.0) {
            heading += Math.PI;
        }
        return SegmentTimeToImpactWallImpl.calculateTimeToImpactWall(subject, heading);
    }

    private static int calculateTimeToImpactWall(StaticPosition position, double heading) {
        Projection projection = new Projection(position, heading, 8.0);
        int timeToImpactWall = 0;
        do {
            projection.setAbsoluteTargetVelocity(8.0);
            projection.project();
            ++timeToImpactWall;
        } while (Arena.isVehicleCenterInBoundary(projection.getStaticPosition()));
        return timeToImpactWall;
    }
}

