/*
 * Decompiled with CFR 0.152.
 */
package md;

import java.awt.Color;
import md.Enemy;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.CustomEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

public class VelociRaptor
extends AdvancedRobot {
    public boolean BulletHitTarget = false;
    public boolean BulletMissedTarget = false;
    public boolean HitByBullet = false;
    public boolean ScannedRobot = false;
    public boolean HitRobot = false;
    public boolean HitWall = false;
    public boolean NearWall = false;
    public boolean RaptorMode = true;
    public double arenaXsize;
    public double arenaYsize;
    public double wallBufferZone;
    public double WallBearing;
    public double Direction = 1.0;
    public Enemy target;

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setMaxVelocity(8.0);
        this.target = new Enemy();
        this.setEventPriority("HitByBulletEvent", this.getEventPriority("ScannedRobotEvent") - 2);
        this.setEventPriority("HitRobotEvent", this.getEventPriority("ScannedRobotEvent") + 5);
        this.setEventPriority("HitWallEvent", this.getEventPriority("ScannedRobotEvent") - 1);
        this.setEventPriority("RobotDeathEvent", 95);
        this.setEventPriority("BulletMissedEvent", this.getEventPriority("ScannedRobotEvent") - 3);
        this.setColors(Color.green, Color.red, Color.yellow);
        this.arenaXsize = this.getBattleFieldWidth();
        this.arenaYsize = this.getBattleFieldHeight();
        this.wallBufferZone = Math.max(this.getWidth(), this.getHeight());
        ((Robot)this).out.println("Buffer Zone Set to " + this.wallBufferZone);
        this.addCustomEvent(new Condition(this, "NearWall", 11){
            private final /* synthetic */ VelociRaptor this$0;

            public final boolean test() {
                return this.this$0.distFromWall() < this.this$0.wallBufferZone && (this.this$0.getOthers() > 1 || !this.this$0.RaptorMode);
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0, $1, $2);
            }

            private final void constructor$0(VelociRaptor velociRaptor, String $1, int $2) {
            }
        });
        this.addCustomEvent(new Condition(this, "DefensiveNearWall", 5){
            private final /* synthetic */ VelociRaptor this$0;

            public final boolean test() {
                return this.this$0.distFromWall() < this.this$0.wallBufferZone && this.this$0.getOthers() < 2 && this.this$0.RaptorMode;
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0, $1, $2);
            }

            private final void constructor$0(VelociRaptor velociRaptor, String $1, int $2) {
            }
        });
        while (true) {
            this.setAttackMode();
            ((Robot)this).out.println("Moving...");
            this.moveBot();
            ((Robot)this).out.println("Scanning...");
            this.turnRadar();
            ((Robot)this).out.println("Attacking...");
            this.attackEnemy(this.determineFirePower());
            this.execute();
        }
    }

    void setAttackMode() {
        this.RaptorMode = this.getEnergy() >= 50.0;
    }

    void moveBot() {
        if (this.RaptorMode) {
            this.setTurnRight(this.Direction * 90.0);
            this.setAhead(100.0);
        } else {
            this.setAhead(200.0);
            this.setTurnLeft(this.Direction * 90.0);
        }
        if (this.ScannedRobot) {
            ((Robot)this).out.println("I got here!!");
            if (this.RaptorMode) {
                this.setTurnRight(this.target.getBearing());
                this.setAhead(this.target.getDistance() + 100.0);
            } else {
                if (this.target.getDistance() < 200.0) {
                    // empty if block
                }
                ((Robot)this).out.println("CurrEnergy = " + this.target.getEnergy() + " PrevEnergy = " + this.target.getPrevEnergy());
                if (Math.abs(this.target.getPrevEnergy() - this.target.getEnergy()) <= 3.0 && Math.abs(this.target.getPrevEnergy() - this.target.getEnergy()) >= 0.1) {
                    this.evadeAttack(this.target.getBearing(), this.target.getDistance());
                }
            }
        }
    }

    void turnRadar() {
        if (!this.ScannedRobot) {
            this.setTurnRadarRight(45.0);
        }
        if (!this.RaptorMode) {
            // empty if block
        }
    }

    double determineFirePower() {
        double Power;
        if (this.RaptorMode) {
            Power = 900.0 / this.target.getDistance();
            ((Robot)this).out.println("Firing with Power " + Power);
        } else {
            Power = 300.0 / this.target.getDistance();
            ((Robot)this).out.println("Firing with Power " + Power);
        }
        return Power;
    }

    void attackEnemy(double firePower) {
        if (this.ScannedRobot) {
            this.ScannedRobot = false;
            if (this.target.PredictiveTargeting) {
                double absoluteEnemyHeading = Math.toRadians(this.getHeading() + this.target.getBearing());
                double myX = this.getX();
                double myY = this.getY();
                double enemyX = myX + this.target.getDistance() * Math.sin(absoluteEnemyHeading);
                double enemyY = myY + this.target.getDistance() * Math.cos(absoluteEnemyHeading);
                double enemyAngle = Math.toRadians(this.target.getHeading());
                double bulletVelocity = 20.0 - 3.0 * firePower;
                double deltaX = enemyX + this.target.getDistance() * (this.target.getRunningAvgVelocity() / bulletVelocity) * Math.sin(enemyAngle);
                double deltaY = enemyY + this.target.getDistance() * (this.target.getRunningAvgVelocity() / bulletVelocity) * Math.cos(enemyAngle);
                double futureHeading = Math.atan2(deltaX - myX, deltaY - myY);
                double gunHeading = Math.toRadians(this.getGunHeading());
                double radarHeading = Math.toRadians(this.getRadarHeading());
                double firingAngle = this.normalRelativeBearing(Math.toDegrees(futureHeading - gunHeading));
                double scanningAngle = this.normalRelativeBearing(Math.toDegrees(futureHeading - radarHeading));
                ((Robot)this).out.println("~~~>Must turn gun " + firingAngle + " degrees to hit target!");
                if (firingAngle <= 45.0 && firingAngle >= -45.0) {
                    this.setTurnRadarRight(this.normalRelativeBearing(Math.toDegrees(absoluteEnemyHeading) - this.getRadarHeading()));
                    this.turnGunRight(firingAngle);
                    this.fire(firePower);
                } else {
                    this.setTurnRadarRight(this.normalRelativeBearing(Math.toDegrees(absoluteEnemyHeading) - this.getRadarHeading()));
                    this.setTurnGunRight(this.normalRelativeBearing(Math.toDegrees(absoluteEnemyHeading) - this.getGunHeading()));
                    this.fire(firePower);
                }
            } else {
                double absoluteEnemyHeading = this.getHeading() + this.target.getBearing();
                double bearingFromGun = this.normalRelativeBearing(absoluteEnemyHeading - this.getGunHeading());
                double bearingFromRadar = this.normalRelativeBearing(absoluteEnemyHeading - this.getRadarHeading());
                this.setTurnRadarRight(bearingFromRadar);
                this.turnGunRight(bearingFromGun);
                this.fire(firePower);
            }
        }
    }

    public double normalRelativeBearing(double angle) {
        if (angle > -180.0 && angle <= 180.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle <= -180.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle > 180.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    public double normalRelativeHeading(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double fixedAngle = angle;
        while (fixedAngle < 0.0) {
            fixedAngle += 360.0;
        }
        while (fixedAngle >= 360.0) {
            fixedAngle -= 360.0;
        }
        return fixedAngle;
    }

    void turnBotTo(double angle) {
        if (this.getHeading() > angle) {
            this.turnLeft(this.normalRelativeBearing(this.getHeading() - angle));
        } else {
            this.turnRight(this.normalRelativeBearing(angle - this.getHeading()));
        }
    }

    void turnGunTo(double angle) {
        if (this.getGunHeading() > angle) {
            double newHeading = this.getGunHeading() - angle;
            ((Robot)this).out.println("Turning Gun Left " + newHeading + " degrees...");
            this.turnGunLeft(this.getGunHeading() - angle);
        } else {
            double newHeading = angle - this.getGunHeading();
            ((Robot)this).out.println("Turning Gun Right " + newHeading + " degrees...");
            this.turnGunRight(angle - this.getGunHeading());
        }
    }

    void setTurnGunTo(double angle) {
        if (this.getGunHeading() > angle) {
            double newHeading = this.getGunHeading() - angle;
            ((Robot)this).out.println("Turning Gun Left " + newHeading + " degrees...");
            this.setTurnGunLeft(this.getGunHeading() - angle);
        } else {
            double newHeading = angle - this.getGunHeading();
            ((Robot)this).out.println("Turning Gun Right " + newHeading + " degrees...");
            this.setTurnGunRight(angle - this.getGunHeading());
        }
    }

    void turnRadarTo(double angle) {
        if (this.getRadarHeading() > angle) {
            this.turnRadarLeft(this.getRadarHeading() - angle);
        } else {
            this.turnRadarRight(angle - this.getRadarHeading());
        }
    }

    void setTurnRadarTo(double angle) {
        if (this.getRadarHeading() > angle) {
            this.setTurnRadarLeft(this.normalRelativeBearing(this.getRadarHeading() - angle));
        } else {
            this.setTurnRadarRight(this.normalRelativeBearing(angle - this.getRadarHeading()));
        }
    }

    void goTo(double x, double y) {
        double vx = x - this.getX();
        double vy = y - this.getY();
        double distance = Math.sqrt(vx * vx + vy * vy);
        double angle = Math.toDegrees(Math.acos(vy / distance));
        if (x < 0.0) {
            angle = 360.0 - angle;
        }
        this.turnBotTo(angle);
        this.ahead(distance);
    }

    void evadeAttack(double enemyBearing, double distanceFromTarget) {
        double distanceMoved;
        double adj = distanceMoved = 200.0;
        double opp = distanceFromTarget;
        double angleToTarget = this.normalRelativeBearing(90.0 - Math.toDegrees(Math.atan(opp / adj)));
        this.ScannedRobot = false;
        this.Direction *= -1.0;
        ((Robot)this).out.println("\nEvading Enemy Attack...\n");
        this.setStop(true);
        this.setTurnRight(this.Direction * this.normalRelativeBearing(enemyBearing + 90.0));
        this.execute();
        ((Robot)this).out.println("--->Gun is at " + this.getGunHeading() + ", Moving gun left " + angleToTarget + " degrees...");
    }

    void evadeAttack(double enemyBearing) {
        double distanceMoved = this.Direction * 75.0;
        ((Robot)this).out.println("\nEvading Enemy Attack...\n");
        this.setTurnRight(enemyBearing + 90.0);
        this.setAhead(distanceMoved);
        this.execute();
        this.setBack(distanceMoved);
        this.execute();
    }

    double distFromWall() {
        double x = this.getX();
        double y = this.getY();
        double horizonDist = Math.min(this.getBattleFieldWidth() - x, x);
        double vertDist = Math.min(this.getBattleFieldHeight() - y, y);
        return Math.min(horizonDist, vertDist);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ((Robot)this).out.println(e.getName() + " has been scanned!");
        this.ScannedRobot = true;
        this.target.SetScannedEnemyInfo(e, this.getTime());
    }

    public void onHitRobot(HitRobotEvent e) {
        ((Robot)this).out.println("Ran into " + e.getName());
        this.HitRobot = true;
        double absoluteEnemyBearing = this.normalRelativeHeading(this.getHeading() + e.getBearing());
        double bearingFromRadar = this.normalRelativeBearing(absoluteEnemyBearing - this.getRadarHeading());
        double bearingFromGun = this.normalRelativeBearing(absoluteEnemyBearing - this.getGunHeading());
        this.setTurnRight(e.getBearing());
        this.turnGunRight(bearingFromGun);
        this.setTurnRadarRight(bearingFromRadar);
        if (this.RaptorMode) {
            this.fire(3.0);
            this.back(10.0);
            this.fire(3.0);
        } else {
            this.fire(2.0);
            this.back(100.0);
            this.fire(2.0);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ((Robot)this).out.println("My bullet hit the target!");
        this.BulletHitTarget = true;
        this.target.SetBulletHitEnemyInfo(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        ((Robot)this).out.println("Got shot by " + e.getName());
        this.HitByBullet = true;
        this.target.SetHitByEnemyBulletInfo(e);
        this.setStop(true);
        this.Direction *= -1.0;
    }

    public void onHitWall(HitWallEvent e) {
        ((Robot)this).out.println("******>I hit a wall!!<******");
        if (!this.ScannedRobot) {
            this.HitWall = true;
            this.WallBearing = e.getBearing();
            double wallBearing = e.getBearing();
            double wallHeading = this.getHeading() + wallBearing;
            double gunHeading = this.getGunHeading();
            double bearingFromGun = this.normalRelativeBearing(wallHeading - gunHeading);
            this.setTurnRight(this.normalRelativeBearing(wallBearing + 180.0));
            if (bearingFromGun >= -10.0 && bearingFromGun <= 10.0) {
                this.setTurnGunRight(this.normalRelativeBearing(bearingFromGun + 180.0));
            }
            this.setAhead(100.0);
        }
    }

    public void onBulletMissed(BulletMissedEvent event) {
        ((Robot)this).out.println("Damn, my bullet missed!");
        this.BulletMissedTarget = true;
        this.target.SetEnemyTargetingInfo();
        if (this.target.ShotsMissed >= 1) {
            this.setStop(true);
            this.Direction *= -1.0;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        ((Robot)this).out.println("I'm the man!!!");
        if (this.getOthers() == 0) {
            this.setStop(true);
            ((Robot)this).out.println("Time to do my victory dance!!");
            while (true) {
                this.setTurnGunRight(360000.0);
                this.setTurnRadarLeft(360000.0);
                this.setTurnLeft(360000.0);
                this.execute();
            }
        }
    }

    public void onCustomEvent(CustomEvent e) {
        if ((e.getCondition().getName().equals("NearWall") || e.getCondition().getName().equals("DefensiveNearWall")) && this.getOthers() > 1) {
            double newHeading;
            double d;
            double distToBuffer;
            this.NearWall = true;
            double x = this.getX();
            double y = this.getY();
            ((Robot)this).out.println("Near a wall! Oh my GOD!");
            this.setStop(true);
            if (x < this.wallBufferZone) {
                distToBuffer = this.wallBufferZone - x;
                d = 90.0;
            } else if (y < this.wallBufferZone) {
                distToBuffer = this.wallBufferZone - y;
                d = 0.0;
            } else if (this.arenaXsize - x < this.wallBufferZone) {
                distToBuffer = this.wallBufferZone - (this.arenaXsize - x);
                d = 270.0;
            } else {
                distToBuffer = this.wallBufferZone - (this.arenaYsize - y);
                newHeading = 180.0;
            }
            this.turnBotTo(this.normalRelativeHeading((double)(newHeading - 45.0)));
            this.ahead(distToBuffer + 5.0);
            this.setResume();
        }
    }
}

