/*
 * Decompiled with CFR 0.152.
 */
package emp;

import emp.BulletTracker;
import emp.Consts;
import emp.Enemy;
import emp.My;
import emp.Yngwie;
import robocode.Bullet;

public class Control
implements Consts {
    private Yngwie yngwie;
    private boolean robotUpdate;
    private int robotPriority;
    private double robotDegrees;
    private boolean robotRight;
    private boolean robotMaximum;
    private boolean robotDistUpdate;
    private double robotDistance;
    private double robotExpectedVelocity;
    private boolean turretUpdate;
    private int turretPriority;
    private double turretDegrees;
    private boolean turretRight;
    private boolean turretMaximum;
    private boolean radarUpdate;
    private int radarPriority;
    private double radarDegrees;
    private boolean radarRight;
    private boolean radarMaximum;
    private boolean gunFire;
    private double gunPower;
    private int gunStrategy;
    private Enemy gunEnemy;

    public Control(Yngwie y) {
        this.yngwie = y;
        this.robotUpdate = false;
        this.turretUpdate = false;
        this.radarUpdate = false;
        this.gunFire = false;
        this.gunPower = 0.0;
        this.gunStrategy = 0;
        this.gunEnemy = null;
        this.robotDistUpdate = false;
        this.robotDistance = 0.0;
        this.robotExpectedVelocity = 0.0;
    }

    private void req(int C, int P, double Degrees, boolean R, boolean M) {
        if (C == 1) {
            this.robotUpdate = true;
            this.robotPriority = P;
            this.robotDegrees = Degrees;
            this.robotRight = R;
            this.robotMaximum = M;
        } else if (C == 2) {
            this.turretUpdate = true;
            this.turretPriority = P;
            this.turretDegrees = Degrees;
            this.turretRight = R;
            this.turretMaximum = M;
        } else if (C == 3) {
            this.radarUpdate = true;
            this.radarPriority = P;
            this.radarDegrees = Degrees;
            this.radarRight = R;
            this.radarMaximum = M;
        }
    }

    public void TurnTo(int CallerID, int Priority, double DoHeading, boolean Maximum) {
        if (CallerID == 1) {
            this.req(CallerID, Priority, My.absADiffDeg(this.yngwie.getHeading(), DoHeading), My.isToRightDeg(this.yngwie.getHeading(), DoHeading), Maximum);
        } else if (CallerID == 2) {
            this.req(CallerID, Priority, My.absADiffDeg(this.yngwie.getGunHeading(), DoHeading), My.isToRightDeg(this.yngwie.getGunHeading(), DoHeading), Maximum);
        } else if (CallerID == 3) {
            this.req(CallerID, Priority, My.absADiffDeg(this.yngwie.getRadarHeading(), DoHeading), My.isToRightDeg(this.yngwie.getRadarHeading(), DoHeading), Maximum);
        }
    }

    public void TurnRight(int CallerID, int Priority, double Degrees) {
        this.req(CallerID, Priority, Degrees, true, false);
    }

    public void TurnLeft(int CallerID, int Priority, double Degrees) {
        this.req(CallerID, Priority, Degrees, false, false);
    }

    public void TurnRightMax(int CallerID, int Priority) {
        this.req(CallerID, Priority, 0.0, true, true);
    }

    public void TurnLeftMax(int CallerID, int Priority) {
        this.req(CallerID, Priority, 0.0, false, true);
    }

    public void Fire(double Power, int Strat, Enemy en) {
        this.gunFire = true;
        this.gunPower = Power;
        this.gunStrategy = Strat;
        this.gunEnemy = en;
    }

    public double CalcRobotTurning() {
        if (this.robotRight) {
            if (this.robotMaximum) {
                return My.getRobotMaxTurning(this.yngwie.getVelocity());
            }
            return Math.min(this.robotDegrees, My.getRobotMaxTurning(this.yngwie.getVelocity()));
        }
        if (this.robotMaximum) {
            return -My.getRobotMaxTurning(this.yngwie.getVelocity());
        }
        return -Math.min(this.robotDegrees, My.getRobotMaxTurning(this.yngwie.getVelocity()));
    }

    public double CalcRobotVelocity() {
        if (this.robotDistUpdate) {
            return this.robotExpectedVelocity;
        }
        return this.yngwie.getVelocity();
    }

    public double NextXPos() {
        return this.yngwie.getX() + this.CalcRobotVelocity() * My.sinDeg(My.AddDegrees(this.yngwie.getHeading(), this.CalcRobotTurning()));
    }

    public double NextYPos() {
        return this.yngwie.getY() + this.CalcRobotVelocity() * My.cosDeg(My.AddDegrees(this.yngwie.getHeading(), this.CalcRobotTurning()));
    }

    public void setRobotVelocity(double Velocity) {
        this.robotDistUpdate = true;
        if (Velocity >= 0.0) {
            if (this.yngwie.getVelocity() >= Velocity) {
                if (this.yngwie.getVelocity() - 2.0 >= Velocity) {
                    this.robotExpectedVelocity = this.yngwie.getVelocity() - 2.0;
                    this.robotDistance = 0.0;
                } else {
                    this.robotExpectedVelocity = Math.min(this.yngwie.getVelocity() + 1.0, 8.0);
                    this.robotDistance = 100.0;
                }
            } else if (this.yngwie.getVelocity() < 0.0) {
                if (this.yngwie.getVelocity() + 2.0 <= 0.0) {
                    this.robotExpectedVelocity = this.yngwie.getVelocity() + 2.0;
                    this.robotDistance = 0.0;
                } else {
                    this.robotExpectedVelocity = 0.0;
                    this.robotDistance = 0.0;
                }
            } else if (this.yngwie.getVelocity() + 1.0 <= Velocity) {
                this.robotExpectedVelocity = this.yngwie.getVelocity() + 1.0;
                this.robotDistance = 100.0;
            } else {
                this.robotExpectedVelocity = Math.min(this.yngwie.getVelocity() + 1.0, 8.0);
                this.robotDistance = 100.0;
            }
        } else if (this.yngwie.getVelocity() <= Velocity) {
            if (this.yngwie.getVelocity() + 2.0 <= Velocity) {
                this.robotExpectedVelocity = this.yngwie.getVelocity() + 2.0;
                this.robotDistance = 0.0;
            } else {
                this.robotExpectedVelocity = Math.max(this.yngwie.getVelocity() - 1.0, -8.0);
                this.robotDistance = -100.0;
            }
        } else if (this.yngwie.getVelocity() > 0.0) {
            if (this.yngwie.getVelocity() - 2.0 >= 0.0) {
                this.robotExpectedVelocity = this.yngwie.getVelocity() - 2.0;
                this.robotDistance = 0.0;
            } else {
                this.robotExpectedVelocity = 0.0;
                this.robotDistance = 0.0;
            }
        } else if (this.yngwie.getVelocity() - 1.0 >= Velocity) {
            this.robotExpectedVelocity = this.yngwie.getVelocity() - 1.0;
            this.robotDistance = -100.0;
        } else {
            this.robotExpectedVelocity = Math.max(this.yngwie.getVelocity() - 1.0, -8.0);
            this.robotDistance = -100.0;
        }
    }

    public void Update() {
        double robotTurning = 0.0;
        double turretTurning = 0.0;
        double radarTurning = 0.0;
        if (this.robotUpdate) {
            robotTurning = this.CalcRobotTurning();
            this.robotUpdate = false;
        }
        if (this.robotDistUpdate) {
            if (this.robotDistance >= 0.0) {
                this.yngwie.setAhead(this.robotDistance);
            } else {
                this.yngwie.setBack(-this.robotDistance);
            }
            this.robotDistance = 0.0;
            this.robotExpectedVelocity = 0.0;
            this.robotDistUpdate = false;
        }
        if (this.turretUpdate) {
            turretTurning = this.turretRight ? (this.turretMaximum ? My.getTurretMaxTurning() : Math.min(this.turretDegrees - robotTurning, My.getTurretMaxTurning())) : (this.turretMaximum ? -My.getTurretMaxTurning() : -Math.min(this.turretDegrees + robotTurning, My.getTurretMaxTurning()));
            this.turretUpdate = false;
        }
        if (this.radarUpdate) {
            radarTurning = this.radarRight ? (this.radarMaximum ? My.getRadarMaxTurning() : Math.min(this.radarDegrees - robotTurning - turretTurning, My.getRadarMaxTurning())) : (this.radarMaximum ? -My.getRadarMaxTurning() : -Math.min(this.radarDegrees + robotTurning + turretTurning, My.getRadarMaxTurning()));
            this.radarUpdate = false;
        }
        if (robotTurning < 0.0) {
            this.yngwie.setTurnLeft(-robotTurning);
        } else {
            this.yngwie.setTurnRight(robotTurning);
        }
        if (turretTurning < 0.0) {
            this.yngwie.setTurnGunLeft(-turretTurning);
        } else {
            this.yngwie.setTurnGunRight(turretTurning);
        }
        if (radarTurning < 0.0) {
            this.yngwie.setTurnRadarLeft(-radarTurning);
        } else {
            this.yngwie.setTurnRadarRight(radarTurning);
        }
        if (this.gunFire) {
            if (this.yngwie.getGunHeat() == 0.0) {
                Bullet bullet = this.yngwie.setFireBullet(this.gunPower);
                BulletTracker bt = new BulletTracker(bullet, this.gunStrategy, this.gunEnemy.Name, Yngwie.OneOnOne);
                bt.SetPosition(this.yngwie.getX(), this.yngwie.getY(), this.gunEnemy.X(), this.gunEnemy.Y());
                bt.EnemyVelocity = this.gunEnemy.Velocity();
                bt.EnemyBearing = My.absADiffDeg2(this.yngwie.AngleTo(this.gunEnemy), this.gunEnemy.Heading());
                bt.EnemyHeading = this.gunEnemy.Heading();
                this.yngwie.bullettrackers.addElement(bt);
            }
            this.gunFire = false;
        }
    }
}

