/*
 * Decompiled with CFR 0.152.
 */
package ab;

import ab.EnemyWave;
import ab.SuperEnemyBot;
import ab.Utilities;
import ab.Wave;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public class DengerousRoBatra
extends AdvancedRobot {
    private static double firePower = 1.9;
    private static double lateralDirection = 1.0;
    private static double lastEnemyVelocity = 0.0;
    private static double enemyEnergy = 100.0;
    private static int vel;
    private static int lastVel;
    private static int[][] hits;
    private SuperEnemyBot enemy = new SuperEnemyBot();
    private int moveDirection = 1;
    private byte radarDirection = 1;
    private double moveAmount;
    private int currCondition;
    private double width;
    private double height;
    private boolean won = false;
    private int colorNum = 0;
    private int grayLvl = 0;
    private static double[] surfStats;
    private Point2D.Double myLocation;
    private Point2D.Double enemyLocation;
    private ArrayList enemyWaves;
    private ArrayList surfDirections;
    private ArrayList surfAbsBearings;
    private static Rectangle2D.Double battleFieldRect;
    private double oldEnemyHeading;
    private double enemyHeading;
    private double enemyHeadingChange;
    private double enemyVelocity;
    private double bulletPower;
    private double lateralVelocity;
    private double absBearing;
    private double enemyDistance;

    static {
        hits = new int[16][4];
        surfStats = new double[53];
    }

    public void run() {
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.width = this.getBattleFieldWidth();
        this.height = this.getBattleFieldHeight();
        this.moveAmount = Math.max(this.width, this.height) - 100.0;
        this.enemyWaves = new ArrayList();
        this.surfDirections = new ArrayList();
        this.surfAbsBearings = new ArrayList();
        battleFieldRect = new Rectangle2D.Double(36.0, 36.0, this.width - 36.0, this.height - 36.0);
        if (this.getOthers() > 2) {
            this.setTurnLeft(this.getHeading() % 90.0);
            this.currCondition = 1;
        }
        while (!this.won) {
            if (this.getOthers() > 2) {
                this.doMeleeMovement();
            }
            this.doScanner();
            this.execute();
            if (this.colorNum < 255) {
                this.grayLvl = 255 - this.colorNum;
            } else if (this.colorNum >= 255 && this.colorNum < 510) {
                this.grayLvl = this.colorNum % 255;
            } else {
                this.colorNum = 0;
            }
            this.colorNum += 7;
            this.setColors(new Color(this.grayLvl, this.grayLvl, this.grayLvl), new Color(this.grayLvl, this.grayLvl, this.grayLvl), new Color(this.grayLvl, this.grayLvl, this.grayLvl), Color.darkGray, Color.black);
        }
    }

    private void doMeleeMovement() {
        if (this.getTime() % (long)((int)(Math.random() * 100.0 + 1.0)) == 0L) {
            this.moveDirection *= -1;
        }
        this.setMaxVelocity(8.0);
        switch (this.currCondition) {
            case 1: {
                if (this.getTurnRemaining() != 0.0) break;
                this.setBack(this.moveAmount * (double)this.moveDirection);
                this.currCondition = 2;
                break;
            }
            case 2: {
                if (this.getDistanceRemaining() != 0.0) break;
                this.setTurnLeft(90 * this.moveDirection);
                this.currCondition = 4;
                break;
            }
            case 3: {
                if (this.getDistanceRemaining() == 0.0) {
                    this.setTurnLeft(90.0);
                    this.currCondition = 4;
                }
                this.currCondition = 4;
                break;
            }
            case 4: {
                if (this.getTurnRemaining() != 0.0) break;
                this.setBack(Math.random() * this.moveAmount * (double)this.moveDirection);
                this.currCondition = 3;
                break;
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.enemy.none() || e.getDistance() < this.enemy.getDistance() - 70.0 || e.getName().equals(this.enemy.getName())) {
            this.enemy.update(e, (Robot)this);
        }
        firePower = e.getDistance() < 72.0 ? 3.0 : 1.9;
        this.enemyVelocity = e.getVelocity();
        this.myLocation = new Point2D.Double(this.getX(), this.getY());
        this.lateralVelocity = this.getVelocity() * Math.sin(e.getBearingRadians());
        this.absBearing = e.getBearingRadians() + this.getHeadingRadians();
        this.bulletPower = enemyEnergy - e.getEnergy();
        this.enemyDistance = e.getDistance();
        enemyEnergy = e.getEnergy();
        this.enemyHeading = e.getHeadingRadians();
        this.enemyHeadingChange = this.enemyHeading - this.oldEnemyHeading;
        this.oldEnemyHeading = this.enemyHeading;
        if (this.getOthers() <= 2) {
            this.waveSurf();
            this.GFTarget();
        } else if (this.getOthers() > 2) {
            this.setTurnGunRightRadians(Utilities.normalize(this.circularTargetAngle() - this.getGunHeadingRadians()));
            if (this.getGunHeat() == 0.0) {
                this.setFire(firePower);
            }
        }
        this.velocityChanger(this);
    }

    private void velocityChanger(AdvancedRobot r) {
        double d;
        double d2 = enemyEnergy;
        enemyEnergy = this.enemy.getEnergy();
        if (d2 > d) {
            this.moveDirection *= -1;
            this.setMaxVelocity(Math.min((int)(this.getVelocity() * this.enemy.getVelocity() / (double)vel), 8));
            lastVel = vel + 4 * (int)(this.enemy.getDistance() / 276.0);
            int testVel = 3;
            do {
                if (hits[lastVel][testVel] >= hits[lastVel][vel]) continue;
                vel = testVel;
            } while (testVel - 1 > 0);
            if (vel <= 2) {
                r.onHitWall(null);
            }
        }
    }

    private void GFTarget() {
        Wave wave = new Wave(this);
        if (this.enemyVelocity != 0.0) {
            lateralDirection = Utilities.sign(this.enemyVelocity * Math.sin(this.enemy.getHeading() - this.absBearing));
        }
        wave.gunLocation = new Point2D.Double(this.getX(), this.getY());
        Wave.targetLocation = Utilities.project(wave.gunLocation, this.absBearing, this.enemyDistance);
        wave.lateralDirection = lateralDirection;
        wave.bulletPower = firePower;
        wave.setSegmentations(this.enemyDistance, this.enemyVelocity, lastEnemyVelocity);
        lastEnemyVelocity = this.enemyVelocity;
        wave.bearing = this.absBearing;
        this.setTurnGunRightRadians(Utilities.normalize(this.absBearing - this.getGunHeadingRadians() + wave.mostVisitedBearingOffset()));
        if (this.getGunHeat() == 0.0) {
            this.setFire(wave.bulletPower);
        }
        if (this.getEnergy() >= firePower) {
            this.addCustomEvent(wave);
        }
    }

    private void doScanner() {
        if (this.getOthers() <= 2) {
            if (this.enemy.none()) {
                this.setTurnRadarRightRadians(Math.PI * 2);
            } else {
                double turn = this.getHeadingRadians() - this.getRadarHeadingRadians() + this.enemy.getBearing();
                this.setTurnRadarRightRadians(Utilities.normalize(turn += 0.17453292519943295 * (double)this.radarDirection));
                this.radarDirection = (byte)(this.radarDirection * -1);
            }
        } else if (this.getOthers() > 2) {
            this.setTurnRadarRightRadians(1.0);
        }
    }

    private double circularTargetAngle() {
        double futureX = this.enemy.getX();
        double futureY = this.enemy.getY();
        double time = 0.0;
        while ((time + 1.0) * Utilities.bulletSpeed(firePower) < Point2D.distance(this.getX(), this.getY(), futureX, futureY)) {
            futureY += Math.cos(this.enemyHeading) * this.enemyVelocity;
            this.enemyHeading += this.enemyHeadingChange;
            if ((futureX += Math.sin(this.enemyHeading) * this.enemyVelocity) < 36.0 || futureY < 36.0 || futureX > this.width - 36.0 || futureY > this.height - 36.0) {
                futureX = Math.min(Math.max(36.0, futureX), this.width - 36.0);
                futureY = Math.min(Math.max(36.0, futureY), this.height - 36.0);
                break;
            }
            time += 1.0;
        }
        return Utilities.normalize(Math.atan2(futureX - this.getX(), futureY - this.getY()));
    }

    private void waveSurf() {
        EnemyWave ewave = new EnemyWave();
        if (this.bulletPower < 3.01 && this.bulletPower > 0.09 && this.surfDirections.size() > 2) {
            ewave.fireTime = this.getTime() - 1L;
            ewave.bulletVelocity = Utilities.bulletSpeed(this.bulletPower);
            ewave.distanceTraveled = Utilities.bulletSpeed(this.bulletPower);
            ewave.direction = (Integer)this.surfDirections.get(2);
            ewave.directAngle = (Double)this.surfAbsBearings.get(2);
            ewave.fireLocation = (Point2D.Double)this.enemyLocation.clone();
            this.enemyWaves.add(ewave);
        }
        this.setTurnRadarRightRadians(Utilities.normalize(this.absBearing - this.getRadarHeadingRadians()) * 2.0);
        this.surfDirections.add(0, new Integer(this.lateralVelocity >= 0.0 ? 1 : -1));
        this.surfAbsBearings.add(0, new Double(this.absBearing + Math.PI));
        this.enemyLocation = Utilities.project(this.myLocation, this.absBearing, this.enemyDistance);
        this.updateWaves();
        this.surf();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName().equals(this.enemy.getName())) {
            this.enemy.reset();
        }
    }

    public void onHitWall(HitWallEvent e) {
        this.moveDirection *= -1;
    }

    public void onWin(WinEvent e) {
        this.won = true;
        this.setAdjustRadarForGunTurn(false);
        this.setAdjustGunForRobotTurn(false);
        this.setAdjustRadarForRobotTurn(false);
        this.grayLvl = Math.min((int)(Math.random() * 255.0 + 25.0), 255);
        this.out.println(this.grayLvl);
        this.setColors(new Color(this.grayLvl, 0, 0), new Color(0, 0, this.grayLvl), new Color(0, this.grayLvl, 0), new Color(this.grayLvl, 0, this.grayLvl), new Color(this.grayLvl, this.grayLvl, 0));
        this.setFire(3.0);
        this.setTurnLeft(25.0);
        this.setBack(100.0);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.getOthers() <= 2) {
            if (!this.enemyWaves.isEmpty()) {
                Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
                EnemyWave hitWave = null;
                int x = 0;
                while (x < this.enemyWaves.size()) {
                    EnemyWave ewave = (EnemyWave)this.enemyWaves.get(x);
                    if (Math.abs(ewave.distanceTraveled - this.myLocation.distance(ewave.fireLocation)) < 50.0 && Math.round(Utilities.bulletSpeed(e.getBullet().getPower()) * 10.0) == Math.round(ewave.bulletVelocity * 10.0)) {
                        hitWave = ewave;
                        break;
                    }
                    ++x;
                }
                if (hitWave != null) {
                    this.logHit(hitWave, hitBulletLocation);
                    this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
                }
            }
        } else if (this.getOthers() > 2) {
            this.moveDirection *= -1;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        enemyEnergy = e.getEnergy();
    }

    public void onHitRobot(HitRobotEvent e) {
        this.moveDirection *= -1;
        this.currCondition = 1;
    }

    private void updateWaves() {
        int x = 0;
        while (x < this.enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this.myLocation.distance(ew.fireLocation) + 50.0) {
                this.enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    private EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this.enemyWaves.size()) {
            EnemyWave ewave = (EnemyWave)this.enemyWaves.get(x);
            double distance = this.myLocation.distance(ewave.fireLocation) - ewave.distanceTraveled;
            if (distance > ewave.bulletVelocity && distance < closestDistance) {
                surfWave = ewave;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    private static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = Utilities.absBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utilities.normalize(offsetAngle) / Utilities.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction;
        return (int)Utilities.limit(0.0, factor * (double)((surfStats.length - 1) / 2) + (double)((surfStats.length - 1) / 2), surfStats.length - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = DengerousRoBatra.getFactorIndex(ew, targetLocation);
        int x = 0;
        while (x < surfStats.length) {
            int n = x;
            surfStats[n] = surfStats[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this.myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.avoidWall(predictedPosition, Utilities.absBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utilities.normalize(moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utilities.normalize(predictedHeading + Utilities.limit(-maxTurning, moveAngle, maxTurning));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Utilities.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Utilities.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double lookForDanger(EnemyWave surfWave, int direction) {
        int index = DengerousRoBatra.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return surfStats[index];
    }

    public void surf() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.lookForDanger(surfWave, -1);
        double dangerRight = this.lookForDanger(surfWave, 1);
        double goAngle = Utilities.absBearing(surfWave.fireLocation, this.myLocation);
        goAngle = dangerLeft < dangerRight ? this.avoidWall(this.myLocation, goAngle - 1.5707963267948966, -1) : this.avoidWall(this.myLocation, goAngle + 1.5707963267948966, 1);
        DengerousRoBatra.dodgeAccordingToAngle(this, goAngle);
    }

    public double avoidWall(Point2D.Double botLocation, double angle, int orientation) {
        while (!battleFieldRect.contains(Utilities.project(botLocation, angle, 160.0))) {
            angle += (double)orientation * 0.05;
        }
        return angle;
    }

    public static void dodgeAccordingToAngle(AdvancedRobot r, double goAngle) {
        double angle = Utilities.normalize(goAngle - r.getHeadingRadians());
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                r.setTurnRightRadians(Math.PI + angle);
            } else {
                r.setTurnLeftRadians(Math.PI - angle);
            }
            r.setBack(100.0);
        } else {
            if (angle < 0.0) {
                r.setTurnLeftRadians(-1.0 * angle);
            } else {
                r.setTurnRightRadians(angle);
            }
            r.setAhead(100.0);
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.black);
        g.fillRect(0, 0, (int)this.getX() - 40, (int)this.getY() + 40);
        g.fillRect((int)this.getX() + 40, (int)this.getY() - 40, (int)this.width, (int)this.height);
        g.fillRect((int)this.getX() - 40, 0, (int)this.width + 50, (int)this.getY() - 40);
        g.fillRect(0, (int)this.getY() + 40, (int)this.width, (int)this.height);
        g.setColor(Color.red);
        int i = 0;
        while (i < this.enemyWaves.size()) {
            EnemyWave ewave = (EnemyWave)this.enemyWaves.get(i);
            int radius = (int)ewave.distanceTraveled;
            Point2D.Double center = ewave.fireLocation;
            if ((double)(radius - 40) < center.distance(this.myLocation)) {
                g.drawOval((int)(center.x - (double)radius), (int)(center.y - (double)radius), radius * 2, radius * 2);
            }
            ++i;
        }
    }
}

