/*
 * Decompiled with CFR 0.152.
 */
package steff.guns;

import robocode.Rules;
import robocode.ScannedRobotEvent;
import steff.guns.Gun;

public class VirtualBullet {
    private double x;
    private double y;
    private double bulletPower;
    private double angle;
    private double velocity;
    private Gun gun;

    public VirtualBullet(Gun gun, double x, double y, double angle, double bulletPower, ScannedRobotEvent target) {
        this.x = x;
        this.y = y;
        this.bulletPower = bulletPower;
        this.angle = angle;
        this.gun = gun;
        this.velocity = Rules.getBulletSpeed((double)bulletPower);
    }

    public void move(long ticks) {
        this.x += Math.sin(this.angle) * this.velocity * (double)ticks;
        this.y += Math.cos(this.angle) * this.velocity * (double)ticks;
    }

    public boolean collides(double targetX, double targetY) {
        return this.distance(targetX, targetY) < 30.0;
    }

    private double distance(double targetX, double targetY) {
        double distX = this.x - targetX;
        double distY = this.y - targetY;
        return Math.sqrt(distX * distX + distY * distY);
    }

    public Gun getGun() {
        return this.gun;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getBulletPower() {
        return this.bulletPower;
    }
}

