/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.data.extrapolation;

import lazarecki.data.extrapolation.DataExtrapolator;
import lazarecki.util.RoboUtils;

public class GaussExtrapolator
implements DataExtrapolator {
    protected double[] binWeights;
    protected double variance;
    protected double oldValueWeight;
    protected double newValueWeight;

    public GaussExtrapolator(int segmentCount, double variance, double oldValueWeight, double newValueWeight) {
        this.variance = variance / 10.0;
        this.oldValueWeight = oldValueWeight;
        this.newValueWeight = newValueWeight;
        this.binWeights = new double[segmentCount / 2 * 4 + 1];
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int i = 0;
        while (i < this.binWeights.length) {
            this.binWeights[i] = this.calculateBinWeight(i, this.binWeights.length);
            minValue = Math.min(minValue, this.binWeights[i]);
            maxValue = Math.max(maxValue, this.binWeights[i]);
            ++i;
        }
        i = 0;
        while (i < this.binWeights.length) {
            this.binWeights[i] = (this.binWeights[i] - minValue) / (maxValue - minValue);
            ++i;
        }
    }

    @Override
    public double getValue(int selectedIndex, int index, double oldValue, double newValue) {
        double binValue = this.binWeights[(this.binWeights.length - 1) / 2 - (selectedIndex - index)];
        if (binValue < 0.0) {
            binValue = 0.0;
        }
        return RoboUtils.weightedAverage(oldValue, binValue * newValue, this.oldValueWeight, this.newValueWeight);
    }

    protected double calculateBinWeight(int binIndex, int binCount) {
        double centerIndex = (binCount - 1) / 2;
        double x = Math.abs(centerIndex - (double)binIndex) / centerIndex;
        return this.getStandardGaussVal(x);
    }

    protected double getStandardGaussVal(double x) {
        return Math.pow(Math.E, -Math.pow(x, 2.0) / (2.0 * Math.pow(this.variance, 2.0))) / (this.variance * Math.sqrt(Math.PI * 2));
    }
}

