/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.robot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import lazarecki.robot.RobotInfo;
import lazarecki.robot.event.BulletFiredEvent;
import lazarecki.robot.event.DestinationChangedEvent;
import lazarecki.robot.event.IBasicEvents3;
import lazarecki.robot.painter.MetaPainter;
import lazarecki.robot.painter.Painter;
import lazarecki.robot.strategy.MetaStrategist;
import lazarecki.robot.strategy.Strategist;
import lazarecki.util.RoboUtils;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public abstract class ModularRobot
extends AdvancedRobot
implements IBasicEvents3 {
    private MetaStrategist metaStrategist = new MetaStrategist();
    private MetaPainter metaPainter = new MetaPainter();
    private double firePower;
    private Point2D destination;

    public ModularRobot() {
        this.metaStrategist.setRobot(this);
        this.metaPainter.setRobot(this);
    }

    public abstract void init();

    public boolean addStrategist(Strategist strategist) {
        return this.metaStrategist.add(strategist);
    }

    public boolean removeStrategist(Strategist strategist) {
        return this.metaStrategist.remove(strategist);
    }

    public boolean addPainter(Painter strategist) {
        return this.metaPainter.add(strategist);
    }

    public boolean removePainter(Painter strategist) {
        return this.metaPainter.remove(strategist);
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    public double getFirePower() {
        return this.firePower;
    }

    public void setFirePower(double firePower) {
        this.firePower = RoboUtils.limit(0.0, firePower, 3.0);
    }

    public Point2D getDestination() {
        return this.destination;
    }

    public void setDestination(Point2D destination) {
        this.destination = destination != null ? (Point2D)destination.clone() : null;
        DestinationChangedEvent event = new DestinationChangedEvent(this.getDestination());
        event.setPriority(80);
        event.setTime(this.getTime());
        this.onDestinationChanged(event);
    }

    public void moveToDestination() {
        RobotInfo myInfo = new RobotInfo(this);
        double angle = Utils.normalRelativeAngle((double)(myInfo.absoluteAngle(this.getDestination()) - myInfo.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                this.setTurnRightRadians(Math.PI + angle);
            } else {
                this.setTurnLeftRadians(Math.PI - angle);
            }
            this.setBack(myInfo.distance(this.getDestination()));
        } else {
            if (angle < 0.0) {
                this.setTurnLeftRadians(-angle);
            } else {
                this.setTurnRightRadians(angle);
            }
            this.setAhead(myInfo.distance(this.getDestination()));
        }
    }

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.init();
        while (true) {
            this.onRun();
        }
    }

    public void onBattleEnded(BattleEndedEvent event) {
        this.metaStrategist.onBattleEnded(event);
    }

    @Override
    public void onBulletFired(BulletFiredEvent event) {
        this.metaStrategist.onBulletFired(event);
    }

    public void onBulletHit(BulletHitEvent event) {
        this.metaStrategist.onBulletHit(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        this.metaStrategist.onBulletHitBullet(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        this.metaStrategist.onBulletMissed(event);
    }

    public void onDeath(DeathEvent event) {
        this.metaStrategist.onDeath(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        this.metaStrategist.onHitByBullet(event);
    }

    public void onHitRobot(HitRobotEvent event) {
        this.metaStrategist.onHitRobot(event);
    }

    public void onHitWall(HitWallEvent event) {
        this.metaStrategist.onHitWall(event);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        this.metaStrategist.onRobotDeath(event);
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        this.metaStrategist.onScannedRobot(event);
    }

    public void onStatus(StatusEvent event) {
        this.metaStrategist.onStatus(event);
    }

    public void onWin(WinEvent event) {
        this.metaStrategist.onWin(event);
    }

    @Override
    public void onDestinationChanged(DestinationChangedEvent event) {
        this.metaStrategist.onDestinationChanged(event);
    }

    public void onCustomEvent(CustomEvent event) {
        this.metaStrategist.onCustomEvent(event);
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        this.metaStrategist.onSkippedTurn(event);
    }

    public void onPaint(Graphics2D g) {
        this.metaPainter.onPaint(g);
    }

    @Override
    public void onRun() {
        this.metaStrategist.onRun();
        this.execute();
    }

    public void setFire(double power) {
        this.setFireBullet(power);
    }

    public Bullet setFireBullet(double power) {
        Bullet bullet = super.setFireBullet(power);
        if (bullet != null) {
            BulletFiredEvent event = new BulletFiredEvent(Utils.normalRelativeAngle((double)(this.getGunTurnRemainingRadians() - this.getHeadingRadians())), bullet);
            event.setPriority(80);
            event.setTime(this.getTime());
            this.onBulletFired(event);
        }
        return bullet;
    }
}

