/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.radar;

import gf.Centaur.Data;
import gf.Centaur.radar.RadarControll;
import robocode.AdvancedRobot;
import robocode.CustomEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GunHeatLock
extends RadarControll {
    public GunHeatLock(Data data, AdvancedRobot robot) {
        super(data, robot);
        System.out.println("Neues Radar: GunHeatLock");
    }

    public GunHeatLock(Data data, AdvancedRobot robot, boolean start) {
        super(data, robot, start);
        System.out.println("Neues Radar: GunHeatLock");
    }

    @Override
    public void start() {
        this.robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        if (e.getName() == this.data.getVictimName() && this.robot.getGunHeat() < 0.5) {
            double absoluteBearing = this.robot.getHeadingRadians() + e.getBearingRadians();
            this.robot.setTurnRadarRightRadians(3.5 * Utils.normalRelativeAngle((double)(absoluteBearing - this.robot.getRadarHeadingRadians())));
        } else {
            this.robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        if (this.data.getVictim() == null) {
            this.robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() == this.data.NobodyScannedCondition) {
            this.robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
    }
}

